# FTP Deployment Guide for HireCameroon

## 🎯 **Simplified FTP Deployment Setup**

Since you're using Namecheap with FTP access directly to hirecameroon.com, here's the simplified setup:

## 📋 **Required GitHub Secrets**

Go to: **https://github.com/aloahmilton/hirecameroon/settings/secrets/actions**

### Repository Secrets (not environment-specific):
```
FTP_HOST=ftp.hirecameroon.com
FTP_USERNAME=your-ftp-username-from-namecheap
FTP_PASSWORD=your-ftp-password-from-namecheap
```

## 🔧 **GitHub Actions Workflow**

The workflow is already configured for FTP deployment. Here's what it does:

### **Automatic Deployment Triggers:**
- ✅ **Push to `main` branch** → Deploys to production
- ✅ **Manual trigger** → Choose environment in GitHub Actions

### **Deployment Process:**
1. **Build Phase**: Install dependencies, build assets
2. **FTP Upload**: Upload files to your Namecheap hosting
3. **Health Check**: Verify site is working
4. **Notification**: Deployment status

## 🚀 **How to Deploy**

### **Option 1: Automatic Deployment (Recommended)**
```bash
# Push to main branch
git add .
git commit -m "Ready for production"
git push origin main
```

### **Option 2: Manual Deployment**
1. Go to GitHub repository → **Actions** tab
2. Click **"Deploy to Production (FTP)"**
3. Click **"Run workflow"**
4. Select environment (production)
5. Click **"Run workflow"**

## 📁 **What Gets Uploaded**

The deployment automatically excludes development files:
- ✅ **Includes**: All production files, built assets, vendor folder
- ❌ **Excludes**: `.git/`, `node_modules/`, `tests/`, development docs

## 🗄️ **Database Setup**

Since you're using shared hosting, you may need to:

### **Option A: phpMyAdmin (Namecheap)**
1. Login to Namecheap account
2. Go to **"Hosting"** → **"Manage"** → **"phpMyAdmin"**
3. Create database: `hirecameroon_prod`
4. Create user and grant permissions

### **Option B: Manual Migration**
If you can't run migrations automatically, run this locally and import via phpMyAdmin:
```bash
php artisan migrate --seed
php artisan db:seed
```

## ⚙️ **Environment Configuration**

### **Create .env file on server:**
Upload this file to your server root via FTP or file manager:

```env
APP_NAME=HireCameroon
APP_ENV=production
APP_KEY=base64:your-generated-key-here
APP_DEBUG=false
APP_URL=https://hirecameroon.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=hirecameroon_prod
DB_USERNAME=your-db-username
DB_PASSWORD=your-db-password

MAIL_MAILER=smtp
MAIL_HOST=your-smtp-host
MAIL_PORT=587
MAIL_USERNAME=your-email
MAIL_PASSWORD=your-email-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@hirecameroon.com
MAIL_FROM_NAME="HireCameroon"

# Mesomb Payment Configuration
MESOMB_APPLICATION_KEY=your-mesomb-app-key
MESOMB_ACCESS_KEY=your-mesomb-access-key
MESOMB_SECRET_KEY=your-mesomb-secret-key

# File Upload Configuration
FILESYSTEM_DISK=public
MAX_FILE_SIZE=10240
ALLOWED_FILE_TYPES=pdf,doc,docx,jpg,jpeg,png

# Application Settings
DEFAULT_CURRENCY=XAF
DEFAULT_LANGUAGE=en
TIMEZONE=Africa/Douala

# Admin Configuration
ADMIN_EMAIL=admin@hirecameroon.com
ADMIN_PASSWORD=admin123
```

## 🔐 **Generate App Key**

Run this locally and copy the key:
```bash
php artisan key:generate --show
```

## 🧪 **Testing Deployment**

### **After Deployment:**
1. Visit: **https://hirecameroon.com**
2. Check if homepage loads
3. Try admin login: **admin@hirecameroon.com** / **admin123**
4. Test user registration
5. Test job posting

### **Common Issues:**

#### **1. Database Connection Error**
- Check database credentials in `.env`
- Verify database exists and user has permissions
- Some shared hosts require specific hostnames (not `localhost`)

#### **2. File Permissions**
- Some hosts need specific file permissions
- Try setting `storage/` and `bootstrap/cache/` to `755` or `777`

#### **3. PHP Version**
- Ensure your hosting supports PHP 8.2+
- Check `phpinfo()` to verify extensions

#### **4. Assets Not Loading**
- Clear browser cache
- Check if `public/` folder has correct permissions
- Verify asset URLs in browser dev tools

## 📞 **Troubleshooting**

### **Check Deployment Logs:**
1. Go to GitHub → **Actions** tab
2. Click on your deployment run
3. Check each step for errors

### **Manual FTP Upload (Fallback):**
If automated deployment fails:
1. Download repository as ZIP
2. Run `composer install --no-dev` locally
3. Run `npm run build` locally
4. Upload via FTP client (FileZilla, etc.)

### **Database Issues:**
- Use phpMyAdmin to check table creation
- Import SQL dump if migrations fail
- Check MySQL version compatibility

## 🎯 **Success Checklist**

- [ ] Site loads at https://hirecameroon.com
- [ ] No PHP errors on homepage
- [ ] Admin login works
- [ ] User registration works
- [ ] Job posting works
- [ ] Payment integration works
- [ ] All pages load correctly

## 🚨 **Rollback Plan**

If something goes wrong:
1. **FTP Rollback**: Upload previous version from backup
2. **Database Rollback**: Restore from phpMyAdmin backup
3. **Clear Cache**: Delete `bootstrap/cache/*` files

---

**Your HireCameroon application is ready for FTP deployment!** 🚀

Just push to the `main` branch and watch the magic happen!