# HireCameroon - Job Platform for Cameroon

A modern, comprehensive job platform built specifically for Cameroon's bilingual workforce, connecting talented professionals with forward-thinking companies.

## 🚀 Features

### For Job Seekers
- **Advanced Job Search**: Filter by location, sector, salary, and experience level
- **Professional Profiles**: Build comprehensive profiles with resume upload
- **Application Tracking**: Monitor application status and receive updates
- **Bilingual Support**: Full English and French language support
- **Mobile-First Design**: Optimized for all devices

### For Companies
- **Company Dashboard**: Vercel-inspired interface for job management
- **Application Pipeline**: Visual tracking of candidate applications
- **Analytics & Insights**: Performance metrics and hiring analytics
- **Bulk Operations**: Efficient management of multiple jobs
- **Branded Presence**: Custom company profiles and job postings

### For Administrators
- **Admin Panel**: Complete platform management interface
- **Content Moderation**: Review and approve job postings
- **User Management**: Account controls and user analytics
- **System Monitoring**: Real-time platform health and statistics
- **Configurable Access**: Customizable admin slug via environment variables

## 🎨 Design System

- **Brand Colors**: Black, Yellow, White with vibrant gradients
- **Modern UI**: Glassmorphism effects and smooth animations
- **Responsive Design**: Perfect experience on all screen sizes
- **Accessibility**: WCAG-compliant focus states and navigation
- **Performance**: Optimized animations and efficient rendering

## 🛠️ Tech Stack

- **Backend**: Laravel 10.x
- **Frontend**: Blade Templates with Tailwind CSS
- **Database**: MySQL
- **Authentication**: Laravel Sanctum
- **File Storage**: Local/Public Disk
- **Payment Integration**: Mesomb (XAF, Mobile Money)

## 📦 Installation

1. **Clone the repository**
   ```bash
   git clone https://github.com/yourusername/hirecameroon.git
   cd hirecameroon
   ```

2. **Install dependencies**
   ```bash
   composer install
   npm install
   ```

3. **Environment setup**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

4. **Configure database**
   ```bash
   # Update .env file with your database credentials
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=hirecameroon
   DB_USERNAME=your_username
   DB_PASSWORD=your_password
   ```

5. **Run migrations**
   ```bash
   php artisan migrate
   ```

6. **Seed the database (optional)**
   ```bash
   php artisan db:seed
   ```

7. **Build assets**
   ```bash
   npm run build
   ```

8. **Start the server**
   ```bash
   php artisan serve
   ```

## 🔧 Configuration

### Admin Access
Admin access is available at `/admin`. The system includes a dedicated admin login form.

#### **Admin Login Process**
1. **Navigate to `/admin/login`** - Dedicated admin login page
2. **Enter credentials** - Use admin user credentials
3. **Access granted** - Redirected to admin dashboard at `/admin`

#### **Admin User Creation**
- **First User**: User ID 1 automatically gets admin privileges
- **Email-based**: Any user with email `admin@hirecameroon.com` gets admin access
- **Manual Assignment**: Modify user model to grant admin status

#### **Admin Routes**
- `/admin/login` - Admin login form
- `/admin` - Admin dashboard
- `/admin/users` - User management
- `/admin/jobs` - Job moderation
- `/admin/applications` - Application oversight
- `/admin/analytics` - Platform analytics
- `/admin/settings` - System settings

**Security**: Admin access is protected by authentication middleware and role checking.

### File Uploads
Configure file upload settings:
```env
FILESYSTEM_DISK=public
MAX_FILE_SIZE=5120  # KB
```

## 📁 Project Structure

```
hirecameroon/
├── app/
│   ├── Http/Controllers/
│   │   ├── AdminController.php
│   │   ├── ApplicationController.php
│   │   ├── CompanyDashboardController.php
│   │   ├── JobController.php
│   │   └── ProfileController.php
│   └── Models/
├── resources/views/
│   ├── admin/
│   ├── applications/
│   ├── dashboard/
│   ├── jobs/
│   ├── marketing/
│   └── profile/
├── routes/
│   └── web.php
├── public/
└── database/
    └── migrations/
```

## 🎯 Key Routes

- `/` - Landing page
- `/jobs` - Job search and listings
- `/dashboard` - Company dashboard
- `/profile` - User profile management
- `/admin` - Admin panel (configurable slug)
- `/about` - About page
- `/contact` - Contact page
- `/pricing` - Pricing plans

## 🔐 User Roles

1. **Job Seekers**: Browse jobs, apply, manage profiles
2. **Companies**: Post jobs, manage applications, view analytics
3. **Administrators**: Platform management, content moderation

## 📊 Database Schema

- **users**: User accounts and authentication
- **companies**: Company profiles and information
- **jobs**: Job postings with details
- **applications**: Job applications and status tracking
- **user_profiles**: Extended user information

## 🚀 Deployment

1. **Set up production environment**
   ```bash
   APP_ENV=production
   APP_DEBUG=false
   ```

2. **Configure production database and cache**

3. **Set up file storage for production**

4. **Configure admin access**
   ```env
   ADMIN_SLUG=your_secure_admin_slug
   ```

5. **Run production optimizations**
   ```bash
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   ```

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Add tests if applicable
5. Submit a pull request

## 📄 License

This project is licensed under the MIT License - see the LICENSE file for details.

## 📞 Support

For support, email hello@hirecameroon.com or join our community forum.

---

**Built with ❤️ for Cameroon's workforce**
