<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Jobs\ExpireAdJob;

class ExpireAds extends Command
{
    protected $signature = 'ads:expire';
    protected $description = 'Expire ads whose end_at has passed and dispatch expiration jobs';

    public function handle()
    {
        $this->info('Scanning for expired ads...');

        $expired = DB::table('ads')
            ->where('status', 'active')
            ->whereNotNull('end_at')
            ->where('end_at', '<', now())
            ->get();

        $count = 0;
        foreach ($expired as $ad) {
            try {
                DB::table('ads')->where('id', $ad->id)->update(['status' => 'expired', 'updated_at' => now()]);
                ExpireAdJob::dispatch($ad->id);
                $count++;
            } catch (\Exception $e) {
                Log::error('Failed to expire ad in command', ['ad_id' => $ad->id, 'error' => $e->getMessage()]);
            }
        }

        $this->info("Expired ads processed: {$count}");
        return 0;
    }
}
