<?php

namespace App\Console\Commands;

use App\Services\AdService;
use Illuminate\Console\Command;

class ProcessAdMaintenance extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ads:maintenance';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Perform maintenance tasks for ads (activate scheduled, deactivate expired, pause exhausted budgets)';

    protected AdService $adService;

    public function __construct(AdService $adService)
    {
        parent::__construct();
        $this->adService = $adService;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Starting ad maintenance tasks...');

        // Activate scheduled ads
        $activatedCount = $this->adService->activateScheduledAds();
        $this->info("Activated {$activatedCount} scheduled ads.");

        // Deactivate expired ads
        $deactivatedCount = $this->adService->deactivateExpiredAds();
        $this->info("Deactivated {$deactivatedCount} expired ads.");

        // Pause ads with exhausted budgets
        $pausedCount = $this->adService->pauseExhaustedAds();
        $this->info("Paused {$pausedCount} ads with exhausted budgets.");

        $this->info('Ad maintenance completed successfully.');

        return Command::SUCCESS;
    }
}
