<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Ad;
use App\Services\AdService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class AdController extends Controller
{
    protected AdService $adService;

    public function __construct(AdService $adService)
    {
        $this->adService = $adService;
    }

    /**
     * Get floating ads for current user
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function getFloatingAds(Request $request): JsonResponse
    {
        $ads = $this->adService->getActiveAds(
            auth()->user(),
            'floating'
        );

        return response()->json($ads);
    }

    /**
     * Get banner ads for specific position
     *
     * @param Request $request
     * @param string $position
     * @return JsonResponse
     */
    public function getBannerAds(Request $request, string $position): JsonResponse
    {
        $ads = $this->adService->getActiveAds(
            auth()->user(),
            'banner',
            $position
        );

        return response()->json($ads);
    }

    /**
     * Record ad impression
     *
     * @param Ad $ad
     * @return JsonResponse
     */
    public function recordImpression(Ad $ad): JsonResponse
    {
        $this->adService->recordImpression($ad);

        return response()->json(['success' => true]);
    }

    /**
     * Record ad click
     *
     * @param Ad $ad
     * @return JsonResponse
     */
    public function recordClick(Ad $ad): JsonResponse
    {
        $this->adService->recordClick($ad);

        return response()->json(['success' => true]);
    }

    /**
     * Get ad statistics
     *
     * @param Ad $ad
     * @return JsonResponse
     */
    public function getStats(Ad $ad): JsonResponse
    {
        $stats = $this->adService->getAdStats($ad);

        return response()->json($stats);
    }
}
