<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class EnsureActiveSubscription
{
    public function handle(Request $request, Closure $next)
    {
        $companyId = $request->route('company')?->id ?? $request->get('company_id');
        if (!$companyId) {
            return $next($request);
        }

        $sub = DB::table('subscriptions')
            ->where('company_id', $companyId)
            ->where('status', 'active')
            ->where(function ($q) {
                $q->whereNull('ends_at')->orWhere('ends_at', '>', now());
            })
            ->first();

        if (!$sub) {
            return redirect()->route('subscriptions.subscribe', ['company' => $companyId])
                ->withErrors(['subscription' => 'An active subscription is required.']);
        }

        return $next($request);
    }
}


