<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureInstalled
{
    public function handle(Request $request, Closure $next)
    {
        $isInstalled = file_exists(storage_path('app/hirecameroon_installed')) || env('APP_INSTALLED', false);

        if ($isInstalled) {
            return $next($request);
        }

        // Allow installer routes and assets before installation
        if ($request->is('install*') || $request->is('build/*') || $request->is('storage/*')) {
            return $next($request);
        }

        return redirect()->to('/install');
    }
}


