<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdTransaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'ad_id', 'user_id', 'provider', 'provider_reference', 'amount_cents', 'currency', 'status', 'raw_payload'
    ];

    protected $casts = [
        'amount_cents' => 'integer',
        'raw_payload' => 'array',
    ];

    public function ad()
    {
        return $this->belongsTo(Ad::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
