<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserProfile extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'phone',
        'date_of_birth',
        'location',
        'bio',
        'current_job_title',
        'experience_years',
        'skills',
        'education_level',
        'expected_salary',
        'availability',
        'remote_preference',
        'email_notifications',
        'preferred_industries',
        'resume_path',
    ];

    protected $casts = [
        'date_of_birth' => 'date',
        'expected_salary' => 'decimal:2',
        'remote_preference' => 'boolean',
        'email_notifications' => 'boolean',
        'preferred_industries' => 'array',
    ];

    /**
     * Get the user that owns the profile.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the resume URL.
     */
    public function getResumeUrl(): ?string
    {
        return $this->resume_path ? asset('storage/' . $this->resume_path) : null;
    }

    /**
     * Check if the user has a resume uploaded.
     */
    public function hasResume(): bool
    {
        return !empty($this->resume_path);
    }
}