<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class AdActivated extends Notification
{
    use Queueable;

    public $ad;

    public function __construct($ad)
    {
        $this->ad = $ad;
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Your advertisement is now live')
            ->greeting('Hello!')
            ->line('Your advertisement "' . ($this->ad->title ?? 'Ad') . '" is now active on the site.')
            ->action('View Ad', url('/ads/' . ($this->ad->id ?? '')))
            ->line('Thank you for advertising with us!');
    }

    public function toArray($notifiable)
    {
        return [
            'ad_id' => $this->ad->id ?? null,
            'title' => $this->ad->title ?? null,
            'message' => 'Your ad is now active',
        ];
    }
}
