<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class AdExpiring extends Notification
{
    use Queueable;

    public $ad;

    public function __construct($ad)
    {
        $this->ad = $ad;
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Your advertisement is expiring soon')
            ->greeting('Hello!')
            ->line('Your advertisement "' . ($this->ad->title ?? 'Ad') . '" will expire soon.')
            ->action('Renew Ad', url('/ads/' . ($this->ad->id ?? '') . '/renew'))
            ->line('Please renew if you want your ad to continue running.');
    }

    public function toArray($notifiable)
    {
        return [
            'ad_id' => $this->ad->id ?? null,
            'title' => $this->ad->title ?? null,
            'message' => 'Your ad is expiring soon',
        ];
    }
}
