<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use App\View\Components\Ads\Banner;
use App\View\Components\Ads\Sidebar;
use App\View\Components\Ads\Content;
use App\View\Components\Ads\Footer;
use App\View\Components\AdDisplay;

// Communication Services
use App\Services\CommunicationService;
use App\Services\Email\EmailService;
use App\Services\Sms\SmsService;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        // Register Communication Services
        $this->app->singleton(EmailService::class);
        $this->app->singleton(SmsService::class);
        $this->app->singleton(CommunicationService::class, function ($app) {
            return new CommunicationService(
                $app->make(EmailService::class),
                $app->make(SmsService::class)
            );
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Register ad components
        Blade::component('ads-banner', Banner::class);
        Blade::component('ads-sidebar', Sidebar::class);
        Blade::component('ads-content', Content::class);
        Blade::component('ads-footer', Footer::class);
        Blade::component('ad-display', AdDisplay::class);
    }
}
