<?php

namespace App\Services;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;

class PaymentService
{
    private Client $httpClient;

    public function __construct(?Client $httpClient = null)
    {
        $this->httpClient = $httpClient ?: new Client([
            'base_uri' => 'https://mesomb.hachther.com/api/',
            'timeout' => 30,
        ]);
    }

    public function initiatePayment(array $payload): array
    {
        // Minimal placeholder - replace with official SDK when available
        $headers = [
            'X-MeSomb-Application' => config('services.mesomb.app_key'),
            'X-MeSomb-Access-Key' => config('services.mesomb.access_key'),
            'X-MeSomb-Secret-Key' => config('services.mesomb.secret_key'),
            'Accept' => 'application/json',
        ];

        $response = $this->httpClient->post('v1.0/payment/collect/', [
            'headers' => $headers,
            'json' => $payload,
        ]);

        $body = json_decode((string) $response->getBody(), true) ?: [];
        Log::info('Mesomb initiatePayment response', $body);
        return $body;
    }
}


