<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    public function run()
    {
        // Create admin role if it doesn't exist
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        
        // Create admin user
        $adminUser = User::firstOrCreate(
            ['email' => 'admin@hirecameroon.com'],
            [
                'name' => 'System Administrator',
                'password' => Hash::make('admin123'),
                'account_type' => 'personal',
                'email_verified_at' => now(),
            ]
        );
        
        // Assign admin role
        $adminUser->assignRole('admin');
        
        $this->command->info('Admin user created successfully!');
        $this->command->info('Email: admin@hirecameroon.com');
        $this->command->info('Password: admin123');
    }
}