<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Organization;
use App\Models\User;
use App\Models\Job;

class TestCompaniesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     * Creates test companies, users, and jobs for the optimized database
     */
    public function run()
    {
        // Create test companies
        $companies = [
            [
                'name' => 'Tech Solutions Cameroon',
                'slug' => 'tech-solutions-cameroon',
                'description' => 'Leading technology company in Cameroon providing innovative software solutions, mobile applications, and digital transformation services.',
                'sector' => 'technology',
                'contact_email' => 'contact@techsolutions.cm',
                'contact_phone' => '+237 233 123 456',
                'website' => 'https://techsolutions.cm',
                'status' => 'active',
                'subscription_plan' => 'premium',
                'branding' => json_encode([
                    'primary_color' => '#2563eb',
                    'secondary_color' => '#1e40af',
                    'logo_url' => '/images/logos/tech-solutions.png'
                ]),
                'settings' => json_encode([
                    'allow_remote_work' => true,
                    'hiring_status' => 'active',
                    'benefits' => ['health_insurance', 'paid_leave', 'training']
                ]),
                'seo_data' => json_encode([
                    'meta_title' => 'Tech Solutions Cameroon - Leading Software Development Company',
                    'meta_description' => 'Innovative software solutions and digital transformation services in Cameroon',
                    'keywords' => ['software development', 'mobile apps', 'digital transformation', 'cameroon']
                ])
            ],
            [
                'name' => 'Green Energy Cameroon',
                'slug' => 'green-energy-cameroon',
                'description' => 'Sustainable energy solutions provider specializing in solar power systems, renewable energy consulting, and green technology implementation.',
                'sector' => 'energy',
                'contact_email' => 'info@greenenergy.cm',
                'contact_phone' => '+237 222 987 654',
                'website' => 'https://greenenergy.cm',
                'status' => 'active',
                'subscription_plan' => 'enterprise',
                'branding' => json_encode([
                    'primary_color' => '#059669',
                    'secondary_color' => '#047857',
                    'logo_url' => '/images/logos/green-energy.png'
                ]),
                'settings' => json_encode([
                    'allow_remote_work' => false,
                    'hiring_status' => 'active',
                    'benefits' => ['health_insurance', 'retirement_plan', 'field_allowances']
                ]),
                'seo_data' => json_encode([
                    'meta_title' => 'Green Energy Cameroon - Sustainable Energy Solutions',
                    'meta_description' => 'Leading provider of solar power and renewable energy solutions in Cameroon',
                    'keywords' => ['solar energy', 'renewable energy', 'sustainable power', 'cameroon']
                ])
            ],
            [
                'name' => 'EduTech Cameroon',
                'slug' => 'edutech-cameroon',
                'description' => 'Educational technology company developing e-learning platforms, educational software, and digital learning solutions for schools and institutions.',
                'sector' => 'education',
                'contact_email' => 'hello@edutech.cm',
                'contact_phone' => '+237 233 456 789',
                'website' => 'https://edutech.cm',
                'status' => 'active',
                'subscription_plan' => 'premium',
                'branding' => json_encode([
                    'primary_color' => '#7c3aed',
                    'secondary_color' => '#6d28d9',
                    'logo_url' => '/images/logos/edutech.png'
                ]),
                'settings' => json_encode([
                    'allow_remote_work' => true,
                    'hiring_status' => 'active',
                    'benefits' => ['health_insurance', 'paid_leave', 'professional_development']
                ]),
                'seo_data' => json_encode([
                    'meta_title' => 'EduTech Cameroon - Digital Learning Solutions',
                    'meta_description' => 'Innovative e-learning platforms and educational technology solutions for Cameroon',
                    'keywords' => ['e-learning', 'educational technology', 'digital education', 'cameroon']
                ])
            ],
            [
                'name' => 'Logistics Plus Cameroon',
                'slug' => 'logistics-plus-cameroon',
                'description' => 'Comprehensive logistics and supply chain management company providing transportation, warehousing, and distribution services across Cameroon.',
                'sector' => 'logistics',
                'contact_email' => 'operations@logisticsplus.cm',
                'contact_phone' => '+237 233 321 987',
                'website' => 'https://logisticsplus.cm',
                'status' => 'active',
                'subscription_plan' => 'basic',
                'branding' => json_encode([
                    'primary_color' => '#dc2626',
                    'secondary_color' => '#b91c1c',
                    'logo_url' => '/images/logos/logistics-plus.png'
                ]),
                'settings' => json_encode([
                    'allow_remote_work' => false,
                    'hiring_status' => 'active',
                    'benefits' => ['health_insurance', 'transport_allowance', 'overtime_pay']
                ]),
                'seo_data' => json_encode([
                    'meta_title' => 'Logistics Plus Cameroon - Supply Chain Solutions',
                    'meta_description' => 'Comprehensive logistics and transportation services across Cameroon',
                    'keywords' => ['logistics', 'supply chain', 'transportation', 'warehousing', 'cameroon']
                ])
            ],
            [
                'name' => 'FinanceHub Cameroon',
                'slug' => 'financehub-cameroon',
                'description' => 'Financial services company offering banking solutions, investment advisory, financial planning, and fintech innovations.',
                'sector' => 'finance',
                'contact_email' => 'services@financehub.cm',
                'contact_phone' => '+237 233 654 321',
                'website' => 'https://financehub.cm',
                'status' => 'active',
                'subscription_plan' => 'enterprise',
                'branding' => json_encode([
                    'primary_color' => '#0891b2',
                    'secondary_color' => '#0e7490',
                    'logo_url' => '/images/logos/financehub.png'
                ]),
                'settings' => json_encode([
                    'allow_remote_work' => true,
                    'hiring_status' => 'active',
                    'benefits' => ['health_insurance', 'retirement_plan', 'performance_bonuses']
                ]),
                'seo_data' => json_encode([
                    'meta_title' => 'FinanceHub Cameroon - Financial Services & Fintech Solutions',
                    'meta_description' => 'Comprehensive financial services, investment advisory, and fintech innovations in Cameroon',
                    'keywords' => ['financial services', 'fintech', 'investment', 'banking', 'cameroon']
                ])
            ]
        ];

        foreach ($companies as $companyData) {
            Organization::create($companyData);
        }

        // Create test users
        $users = [
            [
                'name' => 'John Admin',
                'email' => 'admin@test.com',
                'password' => bcrypt('password'),
                'account_type' => 'admin',
                'role' => 'admin',
                'status' => 'active',
                'phone' => '+237 233 123 456',
                'location' => 'douala',
                'bio' => 'System Administrator for HireCameroon platform',
                'current_position' => 'Platform Administrator',
                'industry' => 'technology',
                'profile_data' => json_encode([
                    'skills' => ['system administration', 'project management', 'team leadership'],
                    'experience_years' => 8,
                    'certifications' => ['AWS Certified', 'Laravel Expert']
                ]),
                'preferences' => json_encode([
                    'email_notifications' => true,
                    'job_alerts' => true,
                    'newsletter' => false
                ])
            ],
            [
                'name' => 'Sarah Johnson',
                'email' => 'sarah@test.com',
                'password' => bcrypt('password'),
                'account_type' => 'company_owner',
                'role' => 'user',
                'status' => 'active',
                'phone' => '+237 222 987 654',
                'location' => 'yaounde',
                'bio' => 'Experienced HR professional passionate about connecting talent with opportunities',
                'current_position' => 'HR Director',
                'industry' => 'human_resources',
                'profile_data' => json_encode([
                    'skills' => ['recruitment', 'employee relations', 'performance management'],
                    'experience_years' => 12,
                    'languages' => ['English', 'French']
                ]),
                'preferences' => json_encode([
                    'email_notifications' => true,
                    'job_alerts' => true,
                    'newsletter' => true
                ])
            ],
            [
                'name' => 'Michael Chen',
                'email' => 'michael@test.com',
                'password' => bcrypt('password'),
                'account_type' => 'job_seeker',
                'role' => 'user',
                'status' => 'active',
                'phone' => '+237 233 456 789',
                'location' => 'bamenda',
                'bio' => 'Full-stack developer with 5 years of experience in web and mobile application development',
                'current_position' => 'Senior Developer',
                'industry' => 'technology',
                'highest_education_level' => 'bachelor_degree',
                'profile_data' => json_encode([
                    'skills' => ['PHP', 'Laravel', 'JavaScript', 'React', 'Node.js', 'MySQL'],
                    'experience_years' => 5,
                    'portfolio_url' => 'https://michael-portfolio.com',
                    'github' => 'https://github.com/michaelchen'
                ]),
                'education_details' => json_encode([
                    ['degree' => 'Bachelor of Computer Science', 'institution' => 'University of Bamenda', 'year' => 2019]
                ]),
                'preferences' => json_encode([
                    'email_notifications' => true,
                    'job_alerts' => true,
                    'newsletter' => false
                ])
            ]
        ];

        foreach ($users as $userData) {
            User::create($userData);
        }

        // Assign company ownership
        $techSolutions = Organization::where('slug', 'tech-solutions-cameroon')->first();
        $greenEnergy = Organization::where('slug', 'green-energy-cameroon')->first();

        if ($techSolutions) {
            $techSolutions->update(['owner_user_id' => 2]); // Sarah Johnson
        }

        if ($greenEnergy) {
            $greenEnergy->update(['owner_user_id' => 2]); // Sarah Johnson
        }

        // Create test jobs
        $jobs = [
            [
                'organization_id' => $techSolutions->id ?? 1,
                'title' => 'Senior Full-Stack Developer',
                'slug' => 'senior-full-stack-developer-tech-solutions',
                'description' => 'We are looking for an experienced full-stack developer to join our growing team. You will be responsible for developing and maintaining web applications using modern technologies.',
                'location_region' => 'Littoral',
                'location_city' => 'douala',
                'employment_type' => 'full_time',
                'experience_level' => 'senior',
                'salary_min' => 150000,
                'salary_max' => 250000,
                'currency' => 'XAF',
                'negotiable' => true,
                'application_deadline' => now()->addDays(30),
                'status' => 'active',
                'benefits' => json_encode([
                    'health_insurance' => true,
                    'paid_leave' => true,
                    'training' => true,
                    'remote_work' => true
                ]),
                'seo_data' => json_encode([
                    'meta_title' => 'Senior Full-Stack Developer - Tech Solutions Cameroon',
                    'meta_description' => 'Join our team as a Senior Full-Stack Developer. Competitive salary and great benefits.',
                    'keywords' => ['full-stack developer', 'PHP', 'Laravel', 'JavaScript', 'cameroon']
                ])
            ],
            [
                'organization_id' => $greenEnergy->id ?? 2,
                'title' => 'Solar Energy Consultant',
                'slug' => 'solar-energy-consultant-green-energy',
                'description' => 'Exciting opportunity for a solar energy consultant to help businesses and homeowners transition to renewable energy solutions.',
                'location_region' => 'Centre',
                'location_city' => 'yaounde',
                'employment_type' => 'full_time',
                'experience_level' => 'mid',
                'salary_min' => 120000,
                'salary_max' => 180000,
                'currency' => 'XAF',
                'negotiable' => false,
                'application_deadline' => now()->addDays(21),
                'status' => 'active',
                'benefits' => json_encode([
                    'health_insurance' => true,
                    'paid_leave' => true,
                    'field_allowances' => true,
                    'training' => true
                ]),
                'seo_data' => json_encode([
                    'meta_title' => 'Solar Energy Consultant - Green Energy Cameroon',
                    'meta_description' => 'Join our renewable energy team as a Solar Energy Consultant.',
                    'keywords' => ['solar energy', 'renewable energy', 'consultant', 'cameroon']
                ])
            ],
            [
                'organization_id' => $techSolutions->id ?? 1,
                'title' => 'UI/UX Designer',
                'slug' => 'ui-ux-designer-tech-solutions',
                'description' => 'Creative UI/UX Designer needed to design beautiful and intuitive user interfaces for our web and mobile applications.',
                'location_region' => 'Littoral',
                'location_city' => 'douala',
                'employment_type' => 'full_time',
                'experience_level' => 'mid',
                'salary_min' => 100000,
                'salary_max' => 160000,
                'currency' => 'XAF',
                'negotiable' => true,
                'application_deadline' => now()->addDays(14),
                'status' => 'active',
                'benefits' => json_encode([
                    'health_insurance' => true,
                    'paid_leave' => true,
                    'creative_budget' => true,
                    'remote_work' => true
                ]),
                'seo_data' => json_encode([
                    'meta_title' => 'UI/UX Designer - Tech Solutions Cameroon',
                    'meta_description' => 'Join our design team as a UI/UX Designer. Create beautiful user experiences.',
                    'keywords' => ['ui designer', 'ux designer', 'user experience', 'cameroon']
                ])
            ]
        ];

        foreach ($jobs as $jobData) {
            Job::create($jobData);
        }

        $this->command->info('Test data seeded successfully!');
        $this->command->info('Created ' . count($companies) . ' companies, ' . count($users) . ' users, and ' . count($jobs) . ' jobs');
    }
}
