<x-layouts.app>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Integration Management
            </h2>
            <div class="flex items-center space-x-4">
                <span class="px-3 py-1 bg-indigo-100 text-indigo-800 rounded-full text-sm font-medium">
                    API & Integrations
                </span>
            </div>
        </div>
    </x-slot>

    <!-- Integration Overview Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Active APIs</p>
                    <p class="text-3xl font-black text-black">{{ $integrationStats['active_apis'] ?? 0 }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
            </div>
            <div class="mt-4 flex items-center text-sm">
                <span class="text-green-600 font-medium">All operational</span>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">API Calls Today</p>
                    <p class="text-3xl font-black text-black">{{ number_format($integrationStats['api_calls_today'] ?? 0) }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                </div>
            </div>
            <div class="mt-4 flex items-center text-sm">
                <span class="text-green-600 font-medium">+12%</span>
                <span class="text-gray-500 ml-2">vs yesterday</span>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Webhook Events</p>
                    <p class="text-3xl font-black text-black">{{ number_format($integrationStats['webhook_events'] ?? 0) }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                </div>
            </div>
            <div class="mt-4 flex items-center text-sm">
                <span class="text-green-600 font-medium">98.5%</span>
                <span class="text-gray-500 ml-2">success rate</span>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Failed Requests</p>
                    <p class="text-3xl font-black text-black">{{ $integrationStats['failed_requests'] ?? 0 }}</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-red-500 to-red-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 16.5c-.77.833.192 2.5 1.732 2.5z"/>
                    </svg>
                </div>
            </div>
            <div class="mt-4 flex items-center text-sm">
                <span class="text-red-600 font-medium">+2</span>
                <span class="text-gray-500 ml-2">this hour</span>
            </div>
        </div>
    </div>

    <!-- Integration Management Tabs -->
    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 mb-8">
        <div class="border-b border-gray-100">
            <nav class="flex">
                <button onclick="switchIntegrationTab('apis')" id="apis-tab" class="tab-button active px-6 py-4 text-sm font-medium border-b-2 border-blue-500 text-blue-600">
                    API Keys & Access
                </button>
                <button onclick="switchIntegrationTab('webhooks')" id="webhooks-tab" class="tab-button px-6 py-4 text-sm font-medium text-gray-500 hover:text-gray-700">
                    Webhooks
                </button>
                <button onclick="switchIntegrationTab('third-party')" id="third-party-tab" class="tab-button px-6 py-4 text-sm font-medium text-gray-500 hover:text-gray-700">
                    Third-Party Services
                </button>
                <button onclick="switchIntegrationTab('logs')" id="logs-tab" class="tab-button px-6 py-4 text-sm font-medium text-gray-500 hover:text-gray-700">
                    Integration Logs
                </button>
            </nav>
        </div>

        <!-- API Keys & Access Tab -->
        <div id="apis-content" class="tab-content p-6">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold text-black">API Keys & Access Management</h3>
                <div class="flex items-center space-x-2">
                    <button onclick="generateApiKey()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium transition">
                        Generate API Key
                    </button>
                    <button onclick="viewApiDocs()" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg font-medium transition">
                        API Documentation
                    </button>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">API Key</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Permissions</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Last Used</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Requests</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody id="apiKeysTable" class="bg-white divide-y divide-gray-200">
                        <!-- API keys will be loaded here -->
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Webhooks Tab -->
        <div id="webhooks-content" class="tab-content p-6 hidden">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold text-black">Webhook Endpoints</h3>
                <button onclick="addWebhook()" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-lg font-medium transition">
                    Add Webhook
                </button>
            </div>

            <div class="space-y-4" id="webhooksList">
                <!-- Webhooks will be loaded here -->
            </div>
        </div>

        <!-- Third-Party Services Tab -->
        <div id="third-party-content" class="tab-content p-6 hidden">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold text-black">Third-Party Service Integrations</h3>
                <button onclick="configureService()" class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded-lg font-medium transition">
                    Configure Service
                </button>
            </div>

            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                <!-- Payment Services -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <svg class="w-6 h-6 text-green-600" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                                </svg>
                            </div>
                            <div>
                                <h4 class="text-lg font-semibold text-black">Mesomb Payment</h4>
                                <p class="text-sm text-gray-600">Mobile money payments</p>
                            </div>
                        </div>
                        <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs font-medium">Active</span>
                    </div>
                    <div class="space-y-2 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-600">API Status:</span>
                            <span class="text-green-600 font-medium">Operational</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Last Sync:</span>
                            <span class="text-black">2 minutes ago</span>
                        </div>
                    </div>
                    <div class="mt-4 flex space-x-2">
                        <button onclick="testPaymentIntegration()" class="text-xs bg-blue-100 text-blue-700 px-3 py-1 rounded hover:bg-blue-200">Test</button>
                        <button onclick="configurePayment()" class="text-xs bg-gray-100 text-gray-700 px-3 py-1 rounded hover:bg-gray-200">Configure</button>
                    </div>
                </div>

                <!-- Email Services -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                </svg>
                            </div>
                            <div>
                                <h4 class="text-lg font-semibold text-black">SMTP Service</h4>
                                <p class="text-sm text-gray-600">Email delivery service</p>
                            </div>
                        </div>
                        <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs font-medium">Active</span>
                    </div>
                    <div class="space-y-2 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Provider:</span>
                            <span class="text-black">SendGrid</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Daily Limit:</span>
                            <span class="text-black">10,000</span>
                        </div>
                    </div>
                    <div class="mt-4 flex space-x-2">
                        <button onclick="testEmailIntegration()" class="text-xs bg-blue-100 text-blue-700 px-3 py-1 rounded hover:bg-blue-200">Test</button>
                        <button onclick="configureEmail()" class="text-xs bg-gray-100 text-gray-700 px-3 py-1 rounded hover:bg-gray-200">Configure</button>
                    </div>
                </div>

                <!-- Analytics Services -->
                <div class="bg-gray-50 rounded-xl p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                                </svg>
                            </div>
                            <div>
                                <h4 class="text-lg font-semibold text-black">Google Analytics</h4>
                                <p class="text-sm text-gray-600">Website analytics</p>
                            </div>
                        </div>
                        <span class="px-2 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs font-medium">Configuring</span>
                    </div>
                    <div class="space-y-2 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Tracking ID:</span>
                            <span class="text-black">GA-XXXXXXX</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Status:</span>
                            <span class="text-yellow-600">Setup Required</span>
                        </div>
                    </div>
                    <div class="mt-4 flex space-x-2">
                        <button onclick="setupAnalytics()" class="text-xs bg-blue-100 text-blue-700 px-3 py-1 rounded hover:bg-blue-200">Setup</button>
                        <button onclick="configureAnalytics()" class="text-xs bg-gray-100 text-gray-700 px-3 py-1 rounded hover:bg-gray-200">Configure</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Integration Logs Tab -->
        <div id="logs-content" class="tab-content p-6 hidden">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold text-black">Integration Activity Logs</h3>
                <div class="flex items-center space-x-2">
                    <select id="logFilter" class="px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        <option value="all">All Logs</option>
                        <option value="api">API Calls</option>
                        <option value="webhook">Webhooks</option>
                        <option value="error">Errors</option>
                    </select>
                    <button onclick="exportLogs()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium transition">
                        Export Logs
                    </button>
                </div>
            </div>

            <div class="space-y-4" id="logsContainer">
                <!-- Logs will be loaded here -->
            </div>
        </div>
    </div>

    <!-- API Key Modal -->
    <div id="apiKeyModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-2/3 shadow-lg rounded-md bg-white">
            <div class="mt-3">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-gray-900">Generate API Key</h3>
                    <button onclick="closeApiKeyModal()" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>

                <form id="apiKeyForm" class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Key Name</label>
                        <input type="text" name="name" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="e.g., Mobile App API Key">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Permissions</label>
                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="checkbox" name="permissions[]" value="read_jobs" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <span class="ml-2 text-sm">Read Jobs</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="permissions[]" value="write_jobs" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <span class="ml-2 text-sm">Create/Update Jobs</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="permissions[]" value="read_applications" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <span class="ml-2 text-sm">Read Applications</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="permissions[]" value="read_users" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                <span class="ml-2 text-sm">Read Users</span>
                            </label>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Rate Limit (requests per hour)</label>
                        <input type="number" name="rate_limit" value="1000" min="1" max="10000" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    </div>

                    <div class="flex items-center justify-end space-x-4">
                        <button type="button" onclick="closeApiKeyModal()" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">Cancel</button>
                        <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Generate Key</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        let currentIntegrationTab = 'apis';

        document.addEventListener('DOMContentLoaded', function() {
            loadApiKeys();
            loadWebhooks();
            loadIntegrationLogs();

            // Tab switching
            document.querySelectorAll('.tab-button').forEach(button => {
                button.addEventListener('click', function() {
                    const tabName = this.id.replace('-tab', '');
                    switchIntegrationTab(tabName);
                });
            });

            // Form submissions
            document.getElementById('apiKeyForm').addEventListener('submit', function(e) {
                e.preventDefault();
                generateApiKey();
            });

            // Filter changes
            document.getElementById('logFilter').addEventListener('change', function() {
                loadIntegrationLogs();
            });
        });

        function switchIntegrationTab(tabName) {
            // Update tab buttons
            document.querySelectorAll('.tab-button').forEach(button => {
                button.classList.remove('active', 'border-b-2', 'border-blue-500', 'text-blue-600');
                button.classList.add('text-gray-500');
            });

            document.getElementById(tabName + '-tab').classList.add('active', 'border-b-2', 'border-blue-500', 'text-blue-600');

            // Update content visibility
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.add('hidden');
            });

            document.getElementById(tabName + '-content').classList.remove('hidden');

            currentIntegrationTab = tabName;
        }

        function loadApiKeys() {
            fetch('/admin/integration-management/api-keys', {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                renderApiKeys(data.apiKeys);
            })
            .catch(error => {
                console.error('Error loading API keys:', error);
            });
        }

        function renderApiKeys(apiKeys) {
            const tbody = document.getElementById('apiKeysTable');
            tbody.innerHTML = '';

            if (apiKeys.length === 0) {
                tbody.innerHTML = `
                    <tr>
                        <td colspan="7" class="px-6 py-8 text-center text-gray-500">
                            <svg class="w-12 h-12 mx-auto mb-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"/>
                            </svg>
                            <p>No API keys found</p>
                        </td>
                    </tr>
                `;
                return;
            }

            apiKeys.forEach(key => {
                const statusClass = key.is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800';
                const statusText = key.is_active ? 'Active' : 'Inactive';

                const row = document.createElement('tr');
                row.className = 'hover:bg-gray-50';

                row.innerHTML = `
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-mono text-gray-900">
                        ${key.masked_key || key.api_key.substring(0, 20) + '...'}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                        ${key.name}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        ${key.permissions ? key.permissions.join(', ') : 'Full Access'}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        ${key.last_used_at ? new Date(key.last_used_at).toLocaleDateString() : 'Never'}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                        ${key.request_count || 0}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 py-1 text-xs font-medium rounded-full ${statusClass}">
                            ${statusText}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <div class="flex items-center space-x-2">
                            <button onclick="toggleApiKey(${key.id})" class="text-blue-600 hover:text-blue-900">${key.is_active ? 'Deactivate' : 'Activate'}</button>
                            <button onclick="regenerateApiKey(${key.id})" class="text-yellow-600 hover:text-yellow-900">Regenerate</button>
                            <button onclick="deleteApiKey(${key.id})" class="text-red-600 hover:text-red-900">Delete</button>
                        </div>
                    </td>
                `;

                tbody.appendChild(row);
            });
        }

        function loadWebhooks() {
            fetch('/admin/integration-management/webhooks', {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                renderWebhooks(data.webhooks);
            })
            .catch(error => {
                console.error('Error loading webhooks:', error);
            });
        }

        function renderWebhooks(webhooks) {
            const container = document.getElementById('webhooksList');
            container.innerHTML = '';

            if (webhooks.length === 0) {
                container.innerHTML = `
                    <div class="text-center py-8">
                        <svg class="w-12 h-12 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                        <p class="text-gray-500">No webhooks configured</p>
                    </div>
                `;
                return;
            }

            webhooks.forEach(webhook => {
                const webhookCard = document.createElement('div');
                webhookCard.className = 'bg-gray-50 rounded-xl p-6';

                webhookCard.innerHTML = `
                    <div class="flex items-center justify-between mb-4">
                        <div>
                            <h4 class="text-lg font-semibold text-black">${webhook.name}</h4>
                            <p class="text-sm text-gray-600">${webhook.url}</p>
                        </div>
                        <div class="flex items-center space-x-2">
                            <span class="px-2 py-1 bg-green-100 text-green-800 rounded-full text-xs font-medium">Active</span>
                            <button onclick="testWebhook(${webhook.id})" class="text-blue-600 hover:text-blue-800 text-sm">Test</button>
                        </div>
                    </div>
                    <div class="grid md:grid-cols-3 gap-4 text-sm">
                        <div>
                            <span class="text-gray-600">Events:</span>
                            <span class="text-black ml-2">${webhook.events.join(', ')}</span>
                        </div>
                        <div>
                            <span class="text-gray-600">Last Delivery:</span>
                            <span class="text-black ml-2">${webhook.last_delivery ? new Date(webhook.last_delivery).toLocaleString() : 'Never'}</span>
                        </div>
                        <div>
                            <span class="text-gray-600">Success Rate:</span>
                            <span class="text-black ml-2">${webhook.success_rate || 0}%</span>
                        </div>
                    </div>
                `;

                container.appendChild(webhookCard);
            });
        }

        function loadIntegrationLogs() {
            const filter = document.getElementById('logFilter').value;

            fetch(`/admin/integration-management/logs?filter=${filter}`, {
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                renderIntegrationLogs(data.logs);
            })
            .catch(error => {
                console.error('Error loading integration logs:', error);
            });
        }

        function renderIntegrationLogs(logs) {
            const container = document.getElementById('logsContainer');
            container.innerHTML = '';

            if (logs.length === 0) {
                container.innerHTML = `
                    <div class="text-center py-8">
                        <svg class="w-12 h-12 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        <p class="text-gray-500">No integration logs found</p>
                    </div>
                `;
                return;
            }

            logs.forEach(log => {
                const logEntry = document.createElement('div');
                logEntry.className = 'bg-gray-50 rounded-lg p-4';

                const statusClass = log.status === 'success' ? 'text-green-600' : log.status === 'error' ? 'text-red-600' : 'text-yellow-600';

                logEntry.innerHTML = `
                    <div class="flex items-start justify-between">
                        <div class="flex-1">
                            <div class="flex items-center mb-2">
                                <span class="text-sm font-medium text-black">${log.type.toUpperCase()}</span>
                                <span class="ml-2 px-2 py-1 text-xs font-medium rounded-full ${statusClass} bg-opacity-20">
                                    ${log.status}
                                </span>
                            </div>
                            <p class="text-sm text-gray-700 mb-2">${log.message}</p>
                            <div class="text-xs text-gray-500">
                                ${new Date(log.created_at).toLocaleString()} • ${log.endpoint || 'N/A'} • ${log.response_time ? log.response_time + 'ms' : 'N/A'}
                            </div>
                        </div>
                        ${log.error_details ? `<div class="ml-4 text-xs text-red-600">${log.error_details}</div>` : ''}
                    </div>
                `;

                container.appendChild(logEntry);
            });
        }

        function generateApiKey() {
            const formData = new FormData(document.getElementById('apiKeyForm'));

            fetch('/admin/integration-management/api-keys', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    closeApiKeyModal();
                    loadApiKeys();
                    // Show the generated key to the user
                    alert(`API Key Generated: ${data.apiKey}\n\nPlease save this key securely. It will not be shown again.`);
                    showSuccess('API key generated successfully');
                } else {
                    showError(data.message || 'Failed to generate API key');
                }
            })
            .catch(error => {
                console.error('Error generating API key:', error);
                showError('Failed to generate API key');
            });
        }

        function openApiKeyModal() {
            document.getElementById('apiKeyModal').classList.remove('hidden');
        }

        function closeApiKeyModal() {
            document.getElementById('apiKeyModal').classList.add('hidden');
            document.getElementById('apiKeyForm').reset();
        }

        function toggleApiKey(id) {
            fetch(`/admin/integration-management/api-keys/${id}/toggle`, {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    loadApiKeys();
                    showSuccess('API key status updated');
                } else {
                    showError(data.message || 'Failed to update API key');
                }
            })
            .catch(error => {
                console.error('Error toggling API key:', error);
                showError('Failed to update API key');
            });
        }

        function deleteApiKey(id) {
            if (confirm('Are you sure you want to delete this API key? This action cannot be undone.')) {
                fetch(`/admin/integration-management/api-keys/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        loadApiKeys();
                        showSuccess('API key deleted successfully');
                    } else {
                        showError(data.message || 'Failed to delete API key');
                    }
                })
                .catch(error => {
                    console.error('Error deleting API key:', error);
                    showError('Failed to delete API key');
                });
            }
        }

        function viewApiDocs() {
            window.open('/api/documentation', '_blank');
        }

        function testPaymentIntegration() {
            fetch('/admin/integration-management/test-payment', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showSuccess('Payment integration test successful');
                } else {
                    showError(data.message || 'Payment integration test failed');
                }
            })
            .catch(error => {
                console.error('Error testing payment integration:', error);
                showError('Payment integration test failed');
            });
        }

        function exportLogs() {
            const filter = document.getElementById('logFilter').value;
            window.open(`/admin/integration-management/logs/export?filter=${filter}`, '_blank');
        }

        function showSuccess(message) {
            // Simple success notification
            alert(message);
        }

        function showError(message) {
            // Simple error notification
            alert(message);
        }
    </script>
</x-layouts.app>