<x-layouts.app>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                System Health Monitoring
            </h2>
            <div class="flex items-center space-x-4">
                <select id="timeRange" class="px-3 py-2 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    <option value="1">Last hour</option>
                    <option value="6" selected>Last 6 hours</option>
                    <option value="24">Last 24 hours</option>
                    <option value="72">Last 3 days</option>
                </select>
                <button id="refreshBtn" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm font-medium transition">
                    Refresh
                </button>
            </div>
        </div>
    </x-slot>

    <!-- Health Status Overview -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">System Status</p>
                    <p class="text-2xl font-black text-black" id="systemStatus">Loading...</p>
                    <p class="text-sm text-gray-500" id="statusMessage">-</p>
                </div>
                <div class="w-12 h-12 rounded-xl flex items-center justify-center" id="statusIcon">
                    <div class="w-6 h-6 bg-gray-300 rounded-full animate-pulse"></div>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">CPU Usage</p>
                    <p class="text-3xl font-black text-black" id="cpuUsage">-</p>
                    <p class="text-sm text-gray-500">current load</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 3v2m6-2v2M9 19v2m6-2v2M5 9H3m2 6H3m18-6h-2m2 6h-2M7 19h10a2 2 0 002-2V7a2 2 0 00-2-2H7a2 2 0 00-2 2v10a2 2 0 002 2zM9 9h6v6H9V9z"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Memory Usage</p>
                    <p class="text-3xl font-black text-black" id="memoryUsage">-</p>
                    <p class="text-sm text-gray-500" id="memoryDetails">-</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-green-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01"/>
                    </svg>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-medium">Disk Usage</p>
                    <p class="text-3xl font-black text-black" id="diskUsage">-</p>
                    <p class="text-sm text-gray-500" id="diskDetails">-</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 19a2 2 0 01-2-2V7a2 2 0 012-2h4l2 2h4a2 2 0 012 2v1M5 19h14a2 2 0 002-2v-5a2 2 0 00-2-2H9a2 2 0 00-2 2v5a2 2 0 01-2 2z"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- System Metrics Charts -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
        <!-- CPU Usage Trend -->
        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold text-gray-900">CPU Usage Trend</h3>
                <div class="flex items-center space-x-2">
                    <div class="w-3 h-3 bg-blue-500 rounded-full"></div>
                    <span class="text-sm text-gray-600">CPU %</span>
                </div>
            </div>
            <canvas id="cpuChart" class="w-full h-64"></canvas>
        </div>

        <!-- Memory Usage Trend -->
        <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-lg font-bold text-gray-900">Memory Usage Trend</h3>
                <div class="flex items-center space-x-2">
                    <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                    <span class="text-sm text-gray-600">Memory %</span>
                </div>
            </div>
            <canvas id="memoryChart" class="w-full h-64"></canvas>
        </div>
    </div>

    <!-- Additional Metrics -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
        <!-- Services Status -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100">
            <div class="p-6 border-b border-gray-100">
                <h3 class="text-lg font-bold text-gray-900">Services Status</h3>
                <p class="text-sm text-gray-600 mt-1">Core system services health</p>
            </div>
            <div class="p-6">
                <div id="servicesStatus" class="space-y-4">
                    <!-- Services will be loaded here -->
                </div>
            </div>
        </div>

        <!-- System Information -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100">
            <div class="p-6 border-b border-gray-100">
                <h3 class="text-lg font-bold text-gray-900">System Information</h3>
                <p class="text-sm text-gray-600 mt-1">Server and environment details</p>
            </div>
            <div class="p-6">
                <div id="systemInfo" class="space-y-3">
                    <!-- System info will be loaded here -->
                </div>
            </div>
        </div>

        <!-- Performance Metrics -->
        <div class="bg-white rounded-2xl shadow-lg border border-gray-100">
            <div class="p-6 border-b border-gray-100">
                <h3 class="text-lg font-bold text-gray-900">Performance Metrics</h3>
                <p class="text-sm text-gray-600 mt-1">Response times and error rates</p>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-3 h-3 bg-yellow-500 rounded-full mr-3"></div>
                            <span class="font-medium text-gray-900">Response Time</span>
                        </div>
                        <span class="text-gray-600 font-semibold" id="responseTime">-</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-3 h-3 bg-red-500 rounded-full mr-3"></div>
                            <span class="font-medium text-gray-900">Error Count</span>
                        </div>
                        <span class="text-gray-600 font-semibold" id="errorCount">-</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-3 h-3 bg-blue-500 rounded-full mr-3"></div>
                            <span class="font-medium text-gray-900">Active Sessions</span>
                        </div>
                        <span class="text-gray-600 font-semibold" id="activeSessions">-</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let cpuChart, memoryChart;

            // Load initial data
            loadHealthData();

            // Refresh button handler
            document.getElementById('refreshBtn').addEventListener('click', function() {
                loadHealthData();
            });

            // Time range change handler
            document.getElementById('timeRange').addEventListener('change', function() {
                loadHealthData();
            });

            function loadHealthData() {
                const hours = document.getElementById('timeRange').value;

                fetch(`/admin/system-health/data?hours=${hours}`)
                    .then(response => response.json())
                    .then(data => {
                        updateHealthOverview(data);
                        updateCharts(data);
                        updateServicesStatus(data.current.services_status);
                        updateSystemInfo(data.current.additional_metrics);
                    })
                    .catch(error => console.error('Error loading health data:', error));
            }

            function updateHealthOverview(data) {
                const current = data.current;
                const status = data.status;

                // System Status
                document.getElementById('systemStatus').textContent = status.status.charAt(0).toUpperCase() + status.status.slice(1);
                document.getElementById('statusMessage').textContent = status.issues.length > 0 ? `${status.issues.length} issue(s)` : 'All systems healthy';

                const statusIcon = document.getElementById('statusIcon');
                statusIcon.innerHTML = getStatusIcon(status.status);

                // CPU Usage
                document.getElementById('cpuUsage').textContent = current.cpu_usage ? `${current.cpu_usage}%` : '-';

                // Memory Usage
                document.getElementById('memoryUsage').textContent = current.memory_usage ? `${current.memory_usage}%` : '-';
                document.getElementById('memoryDetails').textContent = current.memory_used_mb && current.memory_total_mb ?
                    `${current.memory_used_mb}MB / ${current.memory_total_mb}MB` : '-';

                // Disk Usage
                document.getElementById('diskUsage').textContent = current.disk_usage ? `${current.disk_usage}%` : '-';
                document.getElementById('diskDetails').textContent = current.disk_used_gb && current.disk_total_gb ?
                    `${current.disk_used_gb}GB / ${current.disk_total_gb}GB` : '-';

                // Performance Metrics
                document.getElementById('responseTime').textContent = current.response_time_ms ? `${current.response_time_ms}ms` : '-';
                document.getElementById('errorCount').textContent = current.error_count || '0';
                document.getElementById('activeSessions').textContent = current.active_sessions || '0';
            }

            function updateCharts(data) {
                const history = data.history;

                // CPU Chart
                const cpuCtx = document.getElementById('cpuChart').getContext('2d');
                if (cpuChart) cpuChart.destroy();

                cpuChart = new Chart(cpuCtx, {
                    type: 'line',
                    data: {
                        labels: history.map(h => formatTime(h.created_at)),
                        datasets: [{
                            label: 'CPU Usage %',
                            data: history.map(h => h.cpu_usage),
                            borderColor: 'rgb(59, 130, 246)',
                            backgroundColor: 'rgba(59, 130, 246, 0.1)',
                            tension: 0.4,
                            fill: true
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: { legend: { display: false } },
                        scales: {
                            y: { beginAtZero: true, max: 100, grid: { color: 'rgba(0, 0, 0, 0.1)' } },
                            x: { grid: { color: 'rgba(0, 0, 0, 0.1)' } }
                        }
                    }
                });

                // Memory Chart
                const memoryCtx = document.getElementById('memoryChart').getContext('2d');
                if (memoryChart) memoryChart.destroy();

                memoryChart = new Chart(memoryCtx, {
                    type: 'line',
                    data: {
                        labels: history.map(h => formatTime(h.created_at)),
                        datasets: [{
                            label: 'Memory Usage %',
                            data: history.map(h => h.memory_usage),
                            borderColor: 'rgb(34, 197, 94)',
                            backgroundColor: 'rgba(34, 197, 94, 0.1)',
                            tension: 0.4,
                            fill: true
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: { legend: { display: false } },
                        scales: {
                            y: { beginAtZero: true, max: 100, grid: { color: 'rgba(0, 0, 0, 0.1)' } },
                            x: { grid: { color: 'rgba(0, 0, 0, 0.1)' } }
                        }
                    }
                });
            }

            function updateServicesStatus(services) {
                const container = document.getElementById('servicesStatus');
                container.innerHTML = '';

                if (!services) {
                    container.innerHTML = '<p class="text-gray-500">No service data available</p>';
                    return;
                }

                Object.entries(services).forEach(([service, status]) => {
                    const div = document.createElement('div');
                    div.className = 'flex items-center justify-between';

                    const leftDiv = document.createElement('div');
                    leftDiv.className = 'flex items-center';

                    const indicator = document.createElement('div');
                    indicator.className = `w-3 h-3 rounded-full mr-3 ${getServiceStatusColor(status)}`;

                    const span = document.createElement('span');
                    span.className = 'font-medium text-gray-900 capitalize';
                    span.textContent = service.replace('_', ' ');

                    leftDiv.appendChild(indicator);
                    leftDiv.appendChild(span);

                    const statusSpan = document.createElement('span');
                    statusSpan.className = `font-semibold ${getServiceStatusTextColor(status)}`;
                    statusSpan.textContent = status.charAt(0).toUpperCase() + status.slice(1);

                    div.appendChild(leftDiv);
                    div.appendChild(statusSpan);

                    container.appendChild(div);
                });
            }

            function updateSystemInfo(metrics) {
                const container = document.getElementById('systemInfo');
                container.innerHTML = '';

                if (!metrics) {
                    container.innerHTML = '<p class="text-gray-500">No system data available</p>';
                    return;
                }

                const infoItems = [
                    { label: 'PHP Version', value: metrics.php_version },
                    { label: 'Laravel Version', value: metrics.laravel_version },
                    { label: 'Server OS', value: metrics.server_os },
                    { label: 'Server Software', value: metrics.server_software },
                ];

                infoItems.forEach(item => {
                    if (item.value) {
                        const div = document.createElement('div');
                        div.className = 'flex justify-between items-center py-2';

                        const label = document.createElement('span');
                        label.className = 'text-gray-600';
                        label.textContent = item.label;

                        const value = document.createElement('span');
                        value.className = 'font-medium text-gray-900';
                        value.textContent = item.value;

                        div.appendChild(label);
                        div.appendChild(value);
                        container.appendChild(div);
                    }
                });
            }

            function getStatusIcon(status) {
                switch (status) {
                    case 'healthy':
                        return '<div class="w-6 h-6 bg-green-500 rounded-full flex items-center justify-center"><svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg></div>';
                    case 'warning':
                        return '<div class="w-6 h-6 bg-yellow-500 rounded-full flex items-center justify-center"><svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"/></svg></div>';
                    case 'critical':
                        return '<div class="w-6 h-6 bg-red-500 rounded-full flex items-center justify-center"><svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg></div>';
                    default:
                        return '<div class="w-6 h-6 bg-gray-500 rounded-full flex items-center justify-center"><svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg></div>';
                }
            }

            function getServiceStatusColor(status) {
                switch (status) {
                    case 'healthy': return 'bg-green-500';
                    case 'warning': return 'bg-yellow-500';
                    case 'error': return 'bg-red-500';
                    default: return 'bg-gray-500';
                }
            }

            function getServiceStatusTextColor(status) {
                switch (status) {
                    case 'healthy': return 'text-green-600';
                    case 'warning': return 'text-yellow-600';
                    case 'error': return 'text-red-600';
                    default: return 'text-gray-600';
                }
            }

            function formatTime(dateString) {
                const date = new Date(dateString);
                return date.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });
            }
        });
    </script>
</x-layouts.app>