@extends('layouts.app')

@section('content')
<div class="max-w-3xl mx-auto p-6 bg-white rounded shadow">
    <div class="flex items-center justify-between mb-4">
        <h1 class="text-xl font-semibold">Ad Details</h1>
        <div class="space-x-2">
            <a href="{{ route('ads.create', ['plan' => $ad->ad_plan_id]) }}" class="px-3 py-1 bg-green-600 text-white rounded">Renew / Repost</a>
            <a href="{{ route('ads.index') }}" class="px-3 py-1 bg-gray-200 rounded">Back</a>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <div class="md:col-span-2">
            <h2 class="font-semibold text-lg">{{ $ad->title ?? 'Untitled' }}</h2>
            <p class="text-sm text-gray-600 mt-2">Status: <strong>{{ ucfirst($ad->status) }}</strong></p>
            <p class="text-sm text-gray-600">Start: {{ $ad->start_at ?? '—' }} — End: {{ $ad->end_at ?? '—' }}</p>
            <p class="mt-4">Target URL: <a href="{{ $ad->target_url }}" class="text-indigo-600">{{ $ad->target_url }}</a></p>

            @if($ad->image_path)
                <div class="mt-4">
                    <img src="{{ asset('storage/' . $ad->image_path) }}" alt="ad" style="max-width:100%; height:auto;" />
                </div>
            @endif
        </div>

        <div>
            <h3 class="font-semibold">Transactions</h3>
            @if($transactions->isEmpty())
                <p class="text-sm text-gray-500 mt-2">No transactions found for this ad.</p>
            @else
                <ul class="mt-2 space-y-2">
                    @foreach($transactions as $tx)
                        <li class="p-2 border rounded">
                            <div class="text-sm">ID: {{ $tx->id }} — {{ strtoupper($tx->provider) }}</div>
                            <div class="text-xs text-gray-600">Amount: {{ number_format($tx->amount_cents/100, 0) }} {{ $tx->currency }}</div>
                            <div class="text-xs">Status: <strong>{{ $tx->status }}</strong></div>
                            <div class="text-xs text-gray-500">Created: {{ $tx->created_at }}</div>
                        </li>
                    @endforeach
                </ul>
            @endif
        </div>
    </div>
</div>
@endsection
