<x-layouts.app>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Apply for: {{ $job->title }}
            </h2>
            <a href="{{ route('jobs.show', $job) }}" class="text-gray-600 hover:text-gray-800">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </a>
        </div>
    </x-slot>

    <!-- Application Form -->
    <div class="max-w-4xl mx-auto">
        <!-- Job Summary Card -->
        <div class="bg-white rounded-2xl shadow-lg p-6 mb-8 border border-gray-100">
            <div class="flex items-start">
                <div class="w-16 h-16 bg-gradient-to-br from-yellow-400 to-yellow-500 rounded-2xl flex items-center justify-center mr-4 shadow-lg">
                    <span class="text-black font-bold text-xl">{{ substr($job->company->name ?? 'C', 0, 1) }}</span>
                </div>
                <div class="flex-1">
                    <h3 class="text-xl font-bold text-black mb-1">{{ $job->title }}</h3>
                    <p class="text-gray-600 font-medium mb-2">{{ $job->company->name ?? 'Company Name' }} • {{ $job->location }}</p>
                    <div class="flex items-center text-sm text-gray-500">
                        <span class="font-bold text-black">XAF {{ number_format($job->salary_max ?? $job->salary_min ?? 0) }}</span>
                        <span class="mx-2">•</span>
                        <span>{{ $job->employment_type ?? 'Full-time' }}</span>
                        <span class="mx-2">•</span>
                        <span>{{ $job->experience_level ?? 'Mid-level' }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Application Form -->
        <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
            <div class="bg-gradient-to-r from-black to-gray-900 text-white p-6">
                <h3 class="text-2xl font-bold">Submit Your Application</h3>
                <p class="text-gray-300 mt-2">Complete the form below to apply for this position.</p>
            </div>

            <form method="POST" action="{{ route('applications.store') }}" enctype="multipart/form-data" class="p-8">
                @csrf
                <input type="hidden" name="job_id" value="{{ $job->id }}">

                <!-- Personal Information Section -->
                <div class="mb-8">
                    <h4 class="text-xl font-bold text-black mb-6 flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-r from-yellow-400 to-yellow-500 rounded-lg flex items-center justify-center mr-3">
                            <span class="text-black font-bold">1</span>
                        </div>
                        Personal Information
                    </h4>

                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">First Name *</label>
                            <input type="text" name="first_name" value="{{ old('first_name', auth()->user()->name ? explode(' ', auth()->user()->name)[0] : '') }}"
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition" required>
                            @error('first_name')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Last Name *</label>
                            <input type="text" name="last_name" value="{{ old('last_name', auth()->user()->name ? explode(' ', auth()->user()->name)[1] ?? '' : '') }}"
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition" required>
                            @error('last_name')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <div class="mt-6">
                        <label class="block text-sm font-bold text-black mb-2">Email Address *</label>
                        <input type="email" name="email" value="{{ old('email', auth()->user()->email) }}"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition" required>
                        @error('email')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="mt-6">
                        <label class="block text-sm font-bold text-black mb-2">Phone Number</label>
                        <input type="tel" name="phone" value="{{ old('phone') }}"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition"
                               placeholder="+237 6XX XXX XXX">
                        @error('phone')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Professional Information Section -->
                <div class="mb-8">
                    <h4 class="text-xl font-bold text-black mb-6 flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-r from-yellow-400 to-yellow-500 rounded-lg flex items-center justify-center mr-3">
                            <span class="text-black font-bold">2</span>
                        </div>
                        Professional Information
                    </h4>

                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Expected Salary (XAF)</label>
                            <input type="number" name="expected_salary" value="{{ old('expected_salary') }}"
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition"
                                   placeholder="e.g., 350000">
                            @error('expected_salary')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                            <p class="text-gray-500 text-xs mt-1">Optional - helps employers understand your expectations</p>
                        </div>

                        <div>
                            <label class="block text-sm font-bold text-black mb-2">Availability Date</label>
                            <input type="date" name="availability_date" value="{{ old('availability_date') }}"
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition">
                            @error('availability_date')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <div class="mt-6">
                        <label class="block text-sm font-bold text-black mb-2">Resume/CV *</label>
                        <div class="border-2 border-dashed border-gray-300 rounded-xl p-6 text-center hover:border-yellow-400 transition">
                            <input type="file" name="resume" accept=".pdf,.doc,.docx"
                                   class="hidden" id="resume-upload" onchange="updateFileName(this)">
                            <label for="resume-upload" class="cursor-pointer">
                                <svg class="w-12 h-12 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                                </svg>
                                <p class="text-gray-600 font-medium">Click to upload your resume</p>
                                <p class="text-gray-400 text-sm mt-1">PDF, DOC, DOCX up to 5MB</p>
                            </label>
                            <div id="file-name" class="mt-4 text-sm text-green-600 font-medium hidden"></div>
                        </div>
                        @error('resume')
                            <p class="text-red-500 text-sm mt-2">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Cover Letter Section -->
                <div class="mb-8">
                    <h4 class="text-xl font-bold text-black mb-6 flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-r from-yellow-400 to-yellow-500 rounded-lg flex items-center justify-center mr-3">
                            <span class="text-black font-bold">3</span>
                        </div>
                        Cover Letter
                    </h4>

                    <div>
                        <label class="block text-sm font-bold text-black mb-2">Tell us why you're interested in this role</label>
                        <textarea name="cover_letter" rows="8"
                                  class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:border-yellow-400 focus:ring-0 transition resize-none"
                                  placeholder="Explain why you're a great fit for this position, what excites you about the role, and any relevant experience you have...">{{ old('cover_letter') }}</textarea>
                        @error('cover_letter')
                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                        @enderror
                        <p class="text-gray-500 text-xs mt-2">Optional but recommended - helps employers understand your motivation</p>
                    </div>
                </div>

                <!-- Terms and Submit -->
                <div class="border-t border-gray-200 pt-8">
                    <div class="flex items-start mb-6">
                        <input type="checkbox" id="terms" name="terms" class="mt-1" required>
                        <label for="terms" class="ml-3 text-sm text-gray-700">
                            I agree to the <a href="{{ route('privacy') }}" class="text-yellow-600 hover:text-yellow-700 font-medium">Privacy Policy</a>
                            and consent to my information being processed for recruitment purposes.
                        </label>
                    </div>

                    <div class="flex gap-4">
                        <button type="submit" class="flex-1 bg-gradient-to-r from-yellow-400 to-yellow-500 hover:from-yellow-500 hover:to-yellow-600 text-black font-bold py-4 px-6 rounded-xl transition-all duration-300 shadow-lg hover:shadow-2xl transform hover:scale-105">
                            <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/>
                            </svg>
                            Submit Application
                        </button>
                        <a href="{{ route('jobs.show', $job) }}" class="px-6 py-4 border-2 border-gray-300 text-gray-700 rounded-xl hover:bg-gray-50 transition font-medium">
                            Cancel
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</x-layouts.app>

<script>
function updateFileName(input) {
    const fileName = input.files[0]?.name;
    const fileNameDiv = document.getElementById('file-name');

    if (fileName) {
        fileNameDiv.textContent = 'Selected: ' + fileName;
        fileNameDiv.classList.remove('hidden');
    } else {
        fileNameDiv.classList.add('hidden');
    }
}

// Form validation
document.querySelector('form').addEventListener('submit', function(e) {
    const resumeInput = document.getElementById('resume-upload');
    const termsCheckbox = document.getElementById('terms');

    if (!resumeInput.files[0]) {
        alert('Please upload your resume/CV.');
        e.preventDefault();
        return;
    }

    if (!termsCheckbox.checked) {
        alert('Please agree to the terms and conditions.');
        e.preventDefault();
        return;
    }
});
</script>