<x-layouts.app>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-4">
                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                    </svg>
                </div>
                <div>
                    <h2 class="font-bold text-2xl text-gray-900 leading-tight">
                        Application Details
                    </h2>
                    <p class="text-sm text-gray-600">Review application for {{ $application->job->title }}</p>
                </div>
            </div>
            <div class="flex items-center space-x-3">
                <a href="{{ route('dashboard.applications') }}" class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg font-medium transition flex items-center">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                    </svg>
                    Back to Applications
                </a>
            </div>
        </div>
    </x-slot>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Main Application Details -->
        <div class="lg:col-span-2 space-y-8">
            <!-- Applicant Information -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden hover:shadow-xl transition-shadow duration-300">
                <div class="p-6 border-b border-gray-100">
                    <div class="flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg flex items-center justify-center mr-3">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-black">Applicant Information</h3>
                    </div>
                </div>

                <div class="p-6">
                    <div class="flex items-start">
                        <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl flex items-center justify-center mr-4 shadow-lg">
                            <span class="text-white font-bold text-xl">{{ substr($application->user->name ?? 'U', 0, 1) }}</span>
                        </div>
                        <div class="flex-1">
                            <h4 class="text-xl font-bold text-black mb-1">{{ $application->user->name ?? 'Unknown User' }}</h4>
                            <p class="text-gray-600 mb-2">{{ $application->user->email ?? '' }}</p>
                            <div class="flex items-center text-sm text-gray-500">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                Applied {{ $application->created_at->diffForHumans() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Job Information -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden hover:shadow-xl transition-shadow duration-300">
                <div class="p-6 border-b border-gray-100">
                    <div class="flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg flex items-center justify-center mr-3">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m8 0V8a2 2 0 01-2 2H8a2 2 0 01-2-2V6m8 0H8"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-black">Job Information</h3>
                    </div>
                </div>

                <div class="p-6">
                    <div class="flex items-start">
                        <div class="w-16 h-16 bg-gradient-to-br from-yellow-400 to-yellow-500 rounded-xl flex items-center justify-center mr-4 shadow-lg">
                            <span class="text-black font-bold text-xl">{{ substr($application->job->company->name ?? 'C', 0, 1) }}</span>
                        </div>
                        <div class="flex-1">
                            <h4 class="text-xl font-bold text-black mb-1">{{ $application->job->title }}</h4>
                            <p class="text-gray-600 mb-2">{{ $application->job->company->name ?? 'Company Name' }}</p>
                            <div class="flex items-center text-sm text-gray-500 mb-2">
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                                {{ $application->job->location }}
                                <span class="mx-2">•</span>
                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                Posted {{ $application->job->created_at->diffForHumans() }}
                            </div>
                            <div class="grid grid-cols-2 gap-4 text-sm">
                                <div>
                                    <span class="text-gray-600">Salary Range:</span>
                                    <span class="font-bold text-black ml-1">
                                        XAF {{ number_format($application->job->salary_min ?? 0) }} -
                                        {{ number_format($application->job->salary_max ?? 0) }}
                                    </span>
                                </div>
                                <div>
                                    <span class="text-gray-600">Employment Type:</span>
                                    <span class="font-bold text-black ml-1">{{ $application->job->job_type ?? 'Full-time' }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Application Details -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden hover:shadow-xl transition-shadow duration-300">
                <div class="p-6 border-b border-gray-100">
                    <div class="flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center mr-3">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-black">Application Details</h3>
                    </div>
                </div>

                <div class="p-6 space-y-6">
                    <!-- Expected Salary -->
                    @if($application->expected_salary)
                    <div>
                        <h4 class="font-bold text-black mb-2">Expected Salary</h4>
                        <p class="text-gray-700">XAF {{ number_format($application->expected_salary) }}</p>
                    </div>
                    @endif

                    <!-- Availability Date -->
                    @if($application->availability_date)
                    <div>
                        <h4 class="font-bold text-black mb-2">Available From</h4>
                        <p class="text-gray-700">{{ $application->availability_date->format('M j, Y') }}</p>
                    </div>
                    @endif

                    <!-- Cover Letter -->
                    @if($application->cover_letter)
                    <div>
                        <h4 class="font-bold text-black mb-2">Cover Letter</h4>
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <p class="text-gray-700 leading-relaxed">{{ $application->cover_letter }}</p>
                        </div>
                    </div>
                    @endif

                    <!-- Resume -->
                    @if($application->resume_path)
                    <div>
                        <h4 class="font-bold text-black mb-2">Resume</h4>
                        <a href="{{ route('applications.download-resume', $application) }}"
                           class="inline-flex items-center bg-gradient-to-r from-green-500 to-green-600 hover:from-green-600 hover:to-green-700 text-white px-4 py-2 rounded-lg font-bold transition">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                            Download Resume
                        </a>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-8">
            <!-- Application Status -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden hover:shadow-xl transition-shadow duration-300">
                <div class="p-6 border-b border-gray-100">
                    <div class="flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-br from-orange-500 to-orange-600 rounded-lg flex items-center justify-center mr-3">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-black">Application Status</h3>
                    </div>
                </div>

                <div class="p-6">
                    @php
                        $statusColors = [
                            'pending' => 'bg-gray-100 text-gray-800',
                            'reviewing' => 'bg-blue-100 text-blue-800',
                            'shortlisted' => 'bg-yellow-100 text-yellow-800',
                            'interviewed' => 'bg-purple-100 text-purple-800',
                            'offered' => 'bg-green-100 text-green-800',
                            'rejected' => 'bg-red-100 text-red-800',
                            'withdrawn' => 'bg-gray-100 text-gray-600'
                        ];
                        $statusLabels = [
                            'pending' => 'Pending Review',
                            'reviewing' => 'Under Review',
                            'shortlisted' => 'Shortlisted',
                            'interviewed' => 'Interview Scheduled',
                            'offered' => 'Offer Extended',
                            'rejected' => 'Not Selected',
                            'withdrawn' => 'Withdrawn'
                        ];
                    @endphp
                    <div class="text-center mb-6">
                        <span class="px-4 py-2 rounded-full text-sm font-bold {{ $statusColors[$application->status] ?? 'bg-gray-100 text-gray-800' }}">
                            {{ $statusLabels[$application->status] ?? ucfirst($application->status) }}
                        </span>
                    </div>

                    <!-- Status Update Form -->
                    <form method="POST" action="{{ route('applications.update-status', $application) }}" class="space-y-4">
                        @csrf
                        <div>
                            <label for="status" class="block text-sm font-bold text-black mb-2">Update Status</label>
                            <select name="status" id="status" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                                <option value="pending" {{ $application->status === 'pending' ? 'selected' : '' }}>Pending Review</option>
                                <option value="reviewing" {{ $application->status === 'reviewing' ? 'selected' : '' }}>Under Review</option>
                                <option value="shortlisted" {{ $application->status === 'shortlisted' ? 'selected' : '' }}>Shortlisted</option>
                                <option value="interviewed" {{ $application->status === 'interviewed' ? 'selected' : '' }}>Interview Scheduled</option>
                                <option value="offered" {{ $application->status === 'offered' ? 'selected' : '' }}>Offer Extended</option>
                                <option value="rejected" {{ $application->status === 'rejected' ? 'selected' : '' }}>Not Selected</option>
                            </select>
                        </div>

                        <div>
                            <label for="notes" class="block text-sm font-bold text-black mb-2">Notes (Optional)</label>
                            <textarea name="notes" id="notes" rows="4" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="Add notes about this application...">{{ $application->employer_notes }}</textarea>
                        </div>

                        <button type="submit" class="w-full bg-gradient-to-r from-blue-500 to-blue-600 hover:from-blue-600 hover:to-blue-700 text-white font-bold py-2 px-4 rounded-lg transition">
                            Update Status
                        </button>
                    </form>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden hover:shadow-xl transition-shadow duration-300">
                <div class="p-6 border-b border-gray-100">
                    <div class="flex items-center">
                        <div class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-indigo-600 rounded-lg flex items-center justify-center mr-3">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-black">Quick Actions</h3>
                    </div>
                </div>

                <div class="p-6 space-y-3">
                    <a href="{{ route('jobs.show', $application->job) }}" class="flex items-center w-full bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-3 rounded-lg font-medium transition">
                        <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                        </svg>
                        View Job Posting
                    </a>

                    @if($application->user->email)
                    <a href="mailto:{{ $application->user->email }}" class="flex items-center w-full bg-blue-100 hover:bg-blue-200 text-blue-700 px-4 py-3 rounded-lg font-medium transition">
                        <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                        Send Email
                    </a>
                    @endif

                    <a href="{{ route('dashboard.applications') }}" class="flex items-center w-full bg-purple-100 hover:bg-purple-200 text-purple-700 px-4 py-3 rounded-lg font-medium transition">
                        <svg class="w-4 h-4 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                        View All Applications
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>