<x-layouts.app>
    <div class="min-h-screen flex">
        <!-- Left Side - Form -->
        <div class="w-full flex items-center justify-center p-8">
            <div class="w-full max-w-md">
                <!-- Logo Section -->
                <div class="text-center mb-8">
                    <a href="/" class="inline-flex items-center space-x-3">
                        <img src="{{ asset('assets/brand/logo.png') }}" alt="HireCameroon" class="h-12 w-auto">
                        <span class="text-2xl font-bold text-gray-900">HireCameroon</span>
                    </a>
                    <p class="mt-2 text-gray-600">Reset your password</p>
                </div>

                <!-- Password Reset Card -->
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">
                    <!-- Header -->
                    <div class="px-8 py-6 bg-gray-50 border-b border-gray-200">
                        <h2 class="text-xl font-semibold text-gray-900 text-center">Forgot Your Password?</h2>
                        <p class="mt-2 text-center text-sm text-gray-600">
                            Enter your email address and we'll send you a link to reset your password.
                        </p>
                    </div>

                    <!-- Form -->
                    <div class="px-8 py-6">
                        <!-- Session Status -->
                        <x-auth-session-status class="mb-4" :status="session('status')" />

                        <form method="POST" action="{{ route('password.email') }}" class="space-y-6">
                            @csrf

                            <!-- Email Address -->
                            <div>
                                <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                                    Email Address
                                </label>
                                <div class="relative">
                                    <input id="email" type="email" name="email" :value="old('email')"
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-500 focus:border-yellow-500 transition-colors duration-200 bg-gray-50 focus:bg-white"
                                           required autofocus placeholder="Enter your email address">
                                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                                        <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"/>
                                        </svg>
                                    </div>
                                </div>
                                <x-input-error :messages="$errors->get('email')" class="mt-2" />
                            </div>

                            <!-- Submit Button -->
                            <button type="submit"
                                    class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-black bg-yellow-400 hover:bg-yellow-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 transition-colors duration-200">
                                <span>Send Password Reset Link</span>
                                <svg class="ml-2 -mr-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/>
                                </svg>
                            </button>
                        </form>
                    </div>

                    <!-- Footer -->
                    <div class="px-8 py-4 bg-gray-50 border-t border-gray-200">
                        <p class="text-center text-sm text-gray-600">
                            Remember your password?
                            <a href="{{ route('login') }}" class="font-medium text-yellow-600 hover:text-yellow-700">
                                Sign in here
                            </a>
                        </p>
                    </div>
                </div>

                <!-- Additional Info -->
                <div class="mt-6 text-center">
                    <p class="text-xs text-gray-500">
                        Having trouble? Contact our support team for assistance.
                    </p>
                </div>
            </div>
        </div>

        <!-- Right Side - Image/Design -->
        <div class="hidden lg:flex bg-gradient-to-br from-yellow-400 via-yellow-500 to-orange-500 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 bg-black/20"></div>
            <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.1"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-20"></div>

            <!-- Content -->
            <div class="relative z-10 flex flex-col justify-center items-center text-white p-12 w-full">
                <!-- Main Illustration -->
                <div class="mb-8">
                    <div class="w-64 h-64 bg-white/10 backdrop-blur-sm rounded-3xl flex items-center justify-center shadow-2xl">
                        <svg class="w-32 h-32 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"/>
                        </svg>
                    </div>
                </div>

                <!-- Text Content -->
                <div class="text-center max-w-md">
                    <h2 class="text-4xl font-bold mb-6 leading-tight">
                        Secure Password<br>
                        <span class="text-white">Recovery</span>
                    </h2>

                    <p class="text-xl text-yellow-100 mb-8 leading-relaxed">
                        No worries! We'll help you get back into your account safely and securely.
                    </p>

                    <!-- Security Features -->
                    <div class="space-y-4 text-left">
                        <div class="flex items-center">
                            <div class="w-6 h-6 bg-white rounded-full flex items-center justify-center mr-3">
                                <svg class="w-3 h-3 text-yellow-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <span class="text-yellow-100">Secure email verification</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-6 h-6 bg-white rounded-full flex items-center justify-center mr-3">
                                <svg class="w-3 h-3 text-yellow-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <span class="text-yellow-100">Fast password reset</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-6 h-6 bg-white rounded-full flex items-center justify-center mr-3">
                                <svg class="w-3 h-3 text-yellow-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <span class="text-yellow-100">Account protection</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>
