<x-layouts.app>
    <div class="min-h-screen flex">
        <!-- Left Side - Form -->
        <div class="w-full flex items-center justify-center p-8">
            <div class="w-full max-w-2xl">
                <!-- Back Arrow and Logo Section -->
                <div class="mb-8">
                    <div class="flex items-center justify-between mb-4">
                        <a href="{{ route('register') }}" class="flex items-center text-gray-600 hover:text-yellow-600 transition-colors">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                            </svg>
                            Back to Account Types
                        </a>
                    </div>
                    <div class="text-center">
                        <a href="/" class="inline-flex items-center space-x-3">
                            <img src="{{ asset('assets/brand/logo.png') }}" alt="HireCameroon" class="h-12 w-auto">
                            <span class="text-2xl font-bold text-gray-900">HireCameroon</span>
                        </a>
                        <p class="mt-2 text-gray-600">Create Your Company Account</p>
                    </div>
                </div>

                <!-- Registration Form -->
                <form method="POST" action="{{ route('register.company') }}" class="space-y-6">
                    @csrf
                    
                    <!-- Basic Information -->
                    <div class="bg-yellow-50 border border-yellow-200 rounded-xl p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Company Representative Information</h3>
                        
                        <!-- Profile Image -->
                        <div class="mb-6">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Profile Picture (Optional)</label>
                            <div class="flex items-center space-x-6">
                                <div class="relative">
                                    <x-profile-avatar
                                        :user="(object)['name' => old('name') ?: 'User', 'initials' => '', 'avatar_color' => '#6B7280']"
                                        size="2xl"
                                        :show-tooltip="false"
                                        id="avatar-preview-company"
                                    />
                                    <img id="profilePreviewCompany" class="hidden w-32 h-32 rounded-full object-cover border-4 border-white shadow-lg" alt="Profile Preview">
                                </div>
                                <div class="flex-1">
                                    <label for="profile_picture_company" class="cursor-pointer inline-flex items-center px-4 py-2 border border-gray-300 rounded-lg shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500">
                                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                        </svg>
                                        Upload Photo
                                    </label>
                                    <input type="file" id="profile_picture_company" name="profile_picture" accept="image/*" class="hidden" onchange="previewProfileImageCompany(this)">
                                    <p class="text-xs text-gray-500 mt-1">Max 2MB, JPG/PNG</p>
                                    @error('profile_picture')
                                        <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <!-- Full Name and Position -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="name" class="block text-sm font-semibold text-gray-700 mb-2">Your Full Name *</label>
                                <input type="text" name="name" id="name" value="{{ old('name') }}" required
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300"
                                       placeholder="Enter your full name">
                                @error('name')
                                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div>
                                <label for="position" class="block text-sm font-semibold text-gray-700 mb-2">Your Position *</label>
                                <input type="text" name="position" id="position" value="{{ old('position') }}" required
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300"
                                       placeholder="e.g., HR Manager, CEO, Recruiter">
                                @error('position')
                                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Account Information -->
                    <div class="bg-gray-50 border border-gray-200 rounded-xl p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Account Information</h3>
                        
                        <!-- Email -->
                        <div class="mb-4">
                            <label for="email" class="block text-sm font-semibold text-gray-700 mb-2">Email Address *</label>
                            <input type="email" name="email" id="email" value="{{ old('email') }}" required
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300"
                                   placeholder="your.email@company.com">
                            @error('email')
                                <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Password Fields -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="password" class="block text-sm font-semibold text-gray-700 mb-2">Password *</label>
                                <input type="password" name="password" id="password" required
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300"
                                       placeholder="Create a strong password">
                                @error('password')
                                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            <div>
                                <label for="password_confirmation" class="block text-sm font-semibold text-gray-700 mb-2">Confirm Password *</label>
                                <input type="password" name="password_confirmation" id="password_confirmation" required
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300"
                                       placeholder="Confirm your password">
                            </div>
                        </div>
                    </div>

                    <!-- Company Information -->
                    <div class="bg-blue-50 border border-blue-200 rounded-xl p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Company Information</h3>
                        
                        <!-- Company Name -->
                        <div class="mb-4">
                            <label for="company_name" class="block text-sm font-semibold text-gray-700 mb-2">Company Name *</label>
                            <input type="text" name="company_name" id="company_name" value="{{ old('company_name') }}" required
                                   class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300"
                                   placeholder="Enter your company name">
                            @error('company_name')
                                <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Company Details -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="company_sector" class="block text-sm font-semibold text-gray-700 mb-2">Industry/Sector *</label>
                                <select name="company_sector" id="company_sector" required
                                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300 appearance-none">
                                    <option value="">Select Industry</option>
                                    <option value="technology" {{ old('company_sector') == 'technology' ? 'selected' : '' }}>Technology</option>
                                    <option value="finance" {{ old('company_sector') == 'finance' ? 'selected' : '' }}>Finance & Banking</option>
                                    <option value="healthcare" {{ old('company_sector') == 'healthcare' ? 'selected' : '' }}>Healthcare</option>
                                    <option value="education" {{ old('company_sector') == 'education' ? 'selected' : '' }}>Education</option>
                                    <option value="retail" {{ old('company_sector') == 'retail' ? 'selected' : '' }}>Retail & Commerce</option>
                                    <option value="manufacturing" {{ old('company_sector') == 'manufacturing' ? 'selected' : '' }}>Manufacturing</option>
                                    <option value="agriculture" {{ old('company_sector') == 'agriculture' ? 'selected' : '' }}>Agriculture</option>
                                    <option value="oil_gas" {{ old('company_sector') == 'oil_gas' ? 'selected' : '' }}>Oil & Gas</option>
                                    <option value="telecommunications" {{ old('company_sector') == 'telecommunications' ? 'selected' : '' }}>Telecommunications</option>
                                    <option value="other" {{ old('company_sector') == 'other' ? 'selected' : '' }}>Other</option>
                                </select>
                                @error('company_sector')
                                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label for="company_size" class="block text-sm font-semibold text-gray-700 mb-2">Company Size *</label>
                                <select name="company_size" id="company_size" required
                                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300 appearance-none">
                                    <option value="">Select Size</option>
                                    <option value="1-10" {{ old('company_size') == '1-10' ? 'selected' : '' }}>1-10 employees</option>
                                    <option value="11-50" {{ old('company_size') == '11-50' ? 'selected' : '' }}>11-50 employees</option>
                                    <option value="51-200" {{ old('company_size') == '51-200' ? 'selected' : '' }}>51-200 employees</option>
                                    <option value="201-500" {{ old('company_size') == '201-500' ? 'selected' : '' }}>201-500 employees</option>
                                    <option value="500+" {{ old('company_size') == '500+' ? 'selected' : '' }}>500+ employees</option>
                                </select>
                                @error('company_size')
                                    <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Company Logo Upload -->
                        <div class="mt-4">
                            <label for="company_logo" class="block text-sm font-semibold text-gray-700 mb-2">Company Logo (Optional)</label>
                            <div class="flex items-center space-x-4">
                                <div class="w-20 h-20 bg-gray-200 rounded-xl flex items-center justify-center overflow-hidden">
                                    <img id="logoPreview" src="" alt="Logo Preview" class="w-full h-full object-cover hidden">
                                    <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                                    </svg>
                                </div>
                                <div>
                                    <input type="file" name="company_logo" id="company_logo" accept="image/*"
                                           onchange="previewImage(this, 'logoPreview')"
                                           class="w-full px-4 py-2 border-2 border-gray-200 rounded-xl text-gray-900 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300">
                                    <p class="text-xs text-gray-500 mt-1">Max 2MB, JPG/PNG</p>
                                </div>
                            </div>
                        </div>

                        <!-- Website and Social Media Links -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                            <div>
                                <label for="company_website" class="block text-sm font-semibold text-gray-700 mb-2">Company Website</label>
                                <input type="url" name="company_website" id="company_website" value="{{ old('company_website') }}"
                                       placeholder="https://example.com"
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300">
                            </div>
                            
                            <div>
                                <label for="company_social" class="block text-sm font-semibold text-gray-700 mb-2">Social Media Link</label>
                                <input type="url" name="company_social" id="company_social" value="{{ old('company_social') }}"
                                       placeholder="LinkedIn, Facebook, etc."
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300">
                            </div>
                        </div>
                    </div>

                    <!-- Terms and Conditions -->
                    <div class="flex items-start">
                        <input type="checkbox" name="terms" id="terms" value="1" required
                               class="mt-1 w-4 h-4 text-yellow-600 border-gray-300 rounded focus:ring-yellow-500">
                        <label for="terms" class="ml-3 text-sm text-gray-600">
                            I agree to the <a href="{{ route('privacy') }}" class="text-yellow-600 hover:text-yellow-700 font-medium">Terms of Service</a> and <a href="{{ route('privacy') }}" class="text-yellow-600 hover:text-yellow-700 font-medium">Privacy Policy</a>
                        </label>
                    </div>
                    @error('terms')
                        <p class="text-sm text-red-600">{{ $message }}</p>
                    @enderror

                    <!-- Submit Button -->
                    <button type="submit"
                            class="w-full bg-gradient-to-r from-yellow-400 to-yellow-500 hover:from-yellow-500 hover:to-yellow-600 text-black font-bold py-4 px-6 rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">
                        Create Company Account
                    </button>
                </form>

                <!-- Sign In Link -->
                <div class="mt-6 text-center">
                    <p class="text-sm text-gray-600">
                        Already have an account?
                        <a href="{{ route('login') }}" class="font-medium text-yellow-600 hover:text-yellow-700">
                            Sign in here
                        </a>
                    </p>
                </div>
            </div>
        </div>

        <!-- Right Side - Image/Design -->
        <div class="hidden bg-gradient-to-br from-yellow-400 via-yellow-500 to-orange-500 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 bg-black/20"></div>
            <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.1"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-20"></div>

            <!-- Content -->
            <div class="relative z-10 flex flex-col justify-center items-center text-white p-12 w-full">
                <!-- Main Illustration -->
                <div class="mb-8">
                    <div class="w-64 h-64 bg-white/10 backdrop-blur-sm rounded-3xl flex items-center justify-center shadow-2xl">
                        <svg class="w-32 h-32 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                    </div>
                </div>

                <!-- Text Content -->
                <div class="text-center max-w-md">
                    <h2 class="text-4xl font-bold mb-6 leading-tight">
                        Build Your Team<br>
                        <span class="text-white">with HireCameroon</span>
                    </h2>

                    <p class="text-xl text-yellow-100 mb-8 leading-relaxed">
                        Connect with talented professionals across Cameroon. Post jobs, manage applications, and grow your business.
                    </p>

                    <!-- Stats -->
                    <div class="grid grid-cols-3 gap-6 mb-8">
                        <div class="text-center">
                            <div class="text-3xl font-bold text-white mb-1">500+</div>
                            <div class="text-sm text-yellow-200">Active Jobs</div>
                        </div>
                        <div class="text-center">
                            <div class="text-3xl font-bold text-white mb-1">10K+</div>
                            <div class="text-sm text-yellow-200">Job Seekers</div>
                        </div>
                        <div class="text-center">
                            <div class="text-3xl font-bold text-white mb-1">200+</div>
                            <div class="text-sm text-yellow-200">Companies</div>
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="space-y-4 text-left">
                        <div class="flex items-center">
                            <div class="w-6 h-6 bg-white rounded-full flex items-center justify-center mr-3">
                                <svg class="w-3 h-3 text-yellow-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <span class="text-yellow-100">Unlimited job postings</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-6 h-6 bg-white rounded-full flex items-center justify-center mr-3">
                                <svg class="w-3 h-3 text-yellow-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <span class="text-yellow-100">Advanced applicant tracking</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-6 h-6 bg-white rounded-full flex items-center justify-center mr-3">
                                <svg class="w-3 h-3 text-yellow-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <span class="text-yellow-100">Detailed analytics dashboard</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>

@push('scripts')
<script>
function previewImage(input, previewId) {
    const preview = document.getElementById(previewId);
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.classList.remove('hidden');
            // Hide the default icon
            const icon = preview.parentElement.querySelector('svg');
            if (icon) icon.style.display = 'none';
        };
        reader.readAsDataURL(input.files[0]);
    }
}

function previewProfileImageCompany(input) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const preview = document.getElementById('profilePreviewCompany');
            const defaultAvatar = document.getElementById('avatar-preview-company');
            
            preview.src = e.target.result;
            preview.classList.remove('hidden');
            if (defaultAvatar) {
                defaultAvatar.classList.add('hidden');
            }
        };
        reader.readAsDataURL(input.files[0]);
    }
}
</script>
@endpush