@extends('layouts.guest')

@section('title', 'Register - HireCameroon')

@section('content')
<div class="min-h-screen flex">
    <!-- Left Side - Form -->
    <div class="w-full flex items-center justify-center p-8">
        <div class="w-full max-w-2xl">
            <!-- Back Arrow and Logo Section -->
            <div class="mb-8">
                <div class="flex items-center justify-between mb-4">
                    <a href="{{ url()->previous() }}" class="flex items-center text-gray-600 hover:text-yellow-600 transition-colors">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                        </svg>
                        Back
                    </a>
                </div>
                <div class="text-center">
                    <a href="/" class="inline-flex items-center space-x-3">
                        <img src="{{ asset('assets/brand/logo.png') }}" alt="HireCameroon" class="h-12 w-auto">
                        <span class="text-2xl font-bold text-gray-900">HireCameroon</span>
                    </a>
                    <p class="mt-2 text-gray-600">Choose your account type</p>
                </div>
            </div>

            <!-- Account Type Selection -->
            <div class="bg-gray-50 rounded-xl p-8">
                <div class="text-center mb-8">
                    <h2 class="text-2xl font-bold text-gray-900 mb-4">Select Your Account Type</h2>
                    <p class="text-gray-600">Choose the option that best describes you</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <!-- Personal Account Option -->
                    <div class="transform transition-all duration-300 hover:scale-105">
                        <a href="{{ route('register.personal') }}" 
                           class="flex flex-col items-center p-8 border-2 border-gray-200 rounded-xl cursor-pointer bg-white shadow-sm hover:shadow-md transition-all hover:border-yellow-400 group">
                            <div class="w-20 h-20 bg-gradient-to-br from-blue-400 to-blue-500 rounded-3xl flex items-center justify-center mb-6 transform transition-transform group-hover:scale-110">
                                <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                            </div>
                            <span class="font-bold text-2xl text-gray-900 mb-3">Personal Account</span>
                            <span class="text-sm text-gray-600 text-center mb-6">For job seekers and professionals looking for opportunities</span>
                            
                            <ul class="space-y-3 text-sm text-gray-600 w-full">
                                <li class="flex items-center">
                                    <svg class="w-5 h-5 text-green-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    Create professional profile
                                </li>
                                <li class="flex items-center">
                                    <svg class="w-5 h-5 text-green-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    Apply to jobs easily
                                </li>
                                <li class="flex items-center">
                                    <svg class="w-5 h-5 text-green-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    Track applications
                                </li>
                                <li class="flex items-center">
                                    <svg class="w-5 h-5 text-green-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    Get job recommendations
                                </li>
                            </ul>

                            <div class="mt-6 w-full">
                                <button class="w-full bg-blue-500 hover:bg-blue-600 text-white font-semibold py-3 px-6 rounded-lg transition-colors">
                                    Create Personal Account
                                </button>
                            </div>
                        </a>
                    </div>

                    <!-- Company Account Option -->
                    <div class="transform transition-all duration-300 hover:scale-105">
                        <a href="{{ route('register.company') }}" 
                           class="flex flex-col items-center p-8 border-2 border-gray-200 rounded-xl cursor-pointer bg-white shadow-sm hover:shadow-md transition-all hover:border-yellow-400 group">
                            <div class="w-20 h-20 bg-gradient-to-br from-yellow-400 to-yellow-500 rounded-3xl flex items-center justify-center mb-6 transform transition-transform group-hover:scale-110">
                                <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                                </svg>
                            </div>
                            <span class="font-bold text-2xl text-gray-900 mb-3">Company Account</span>
                            <span class="text-sm text-gray-600 text-center mb-6">For employers, recruiters, and businesses</span>
                            
                            <ul class="space-y-3 text-sm text-gray-600 w-full">
                                <li class="flex items-center">
                                    <svg class="w-5 h-5 text-green-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    Post unlimited jobs
                                </li>
                                <li class="flex items-center">
                                    <svg class="w-5 h-5 text-green-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    Manage applications
                                </li>
                                <li class="flex items-center">
                                    <svg class="w-5 h-5 text-green-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    Advanced analytics
                                </li>
                                <li class="flex items-center">
                                    <svg class="w-5 h-5 text-green-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                    </svg>
                                    Company branding
                                </li>
                            </ul>

                            <div class="mt-6 w-full">
                                <button class="w-full bg-yellow-400 hover:bg-yellow-500 text-black font-semibold py-3 px-6 rounded-lg transition-colors">
                                    Create Company Account
                                </button>
                            </div>
                        </a>
                    </div>
                </div>

                <!-- Sign In Link -->
                <div class="mt-8 text-center">
                    <p class="text-sm text-gray-600">
                        Already have an account?
                        <a href="{{ route('login') }}" class="font-medium text-yellow-600 hover:text-yellow-700">
                            Sign in here
                        </a>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Right Side - Image/Design -->
    <div class="hidden bg-gradient-to-br from-yellow-400 via-yellow-500 to-orange-500 relative overflow-hidden">
        <!-- Background Pattern -->
        <div class="absolute inset-0 bg-black/20"></div>
        <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.1"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-20"></div>

        <!-- Content -->
        <div class="relative z-10 flex flex-col justify-center items-center text-white p-12 w-full">
            <!-- Main Illustration -->
            <div class="mb-8">
                <div class="w-64 h-64 bg-white/10 backdrop-blur-sm rounded-3xl flex items-center justify-center shadow-2xl">
                    <svg class="w-32 h-32 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m8 0V8a2 2 0 01-2 2H8a2 2 0 01-2-2V6m8 0H8"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 10v4m0 0l-3-3m3 3l3-3"/>
                    </svg>
                </div>
            </div>

            <!-- Text Content -->
            <div class="text-center max-w-md">
                <h2 class="text-4xl font-bold mb-6 leading-tight">
                    Choose the Right<br>
                    <span class="text-white">Account for You</span>
                </h2>

                <p class="text-xl text-yellow-100 mb-8 leading-relaxed">
                    Whether you're looking for your next opportunity or building your team, we have the perfect solution for you.
                </p>

                <!-- Stats -->
                <div class="grid grid-cols-3 gap-6 mb-8">
                    <div class="text-center">
                        <div class="text-3xl font-bold text-white mb-1">500+</div>
                        <div class="text-sm text-yellow-200">Active Jobs</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-white mb-1">10K+</div>
                        <div class="text-sm text-yellow-200">Job Seekers</div>
                    </div>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-white mb-1">200+</div>
                        <div class="text-sm text-yellow-200">Companies</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection