<x-layouts.app>
    <div class="min-h-screen flex">
        <!-- Left Side - Form -->
        <div class="w-full flex items-center justify-center p-8">
            <div class="w-full max-w-md">
                <!-- Logo Section -->
                <div class="text-center mb-8">
                    <a href="/" class="inline-flex items-center space-x-3">
                        <img src="{{ asset('assets/brand/logo.png') }}" alt="HireCameroon" class="h-12 w-auto">
                        <span class="text-2xl font-bold text-gray-900">HireCameroon</span>
                    </a>
                    <p class="mt-2 text-gray-600">Verify your email</p>
                </div>

                <!-- Email Verification Card -->
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">
                    <!-- Header -->
                    <div class="px-8 py-6 bg-gray-50 border-b border-gray-200">
                        <div class="text-center">
                            <!-- Verification Icon -->
                            <div class="mx-auto w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mb-4">
                                <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 7.89a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                </svg>
                            </div>
                            <h2 class="text-xl font-semibold text-gray-900">Check Your Email</h2>
                        </div>
                        <p class="mt-4 text-center text-sm text-gray-600">
                            Thanks for signing up! We've sent a verification link to your email address.
                        </p>
                    </div>

                    <!-- Content -->
                    <div class="px-8 py-6">
                        <!-- Success Message -->
                        @if (session('status') == 'verification-link-sent')
                            <div class="mb-4 p-4 bg-green-50 border border-green-200 rounded-lg">
                                <div class="flex items-center">
                                    <svg class="w-5 h-5 text-green-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                    <p class="text-sm text-green-700">
                                        A new verification link has been sent to your email address.
                                    </p>
                                </div>
                            </div>
                        @endif

                        <div class="text-sm text-gray-600 mb-6">
                            Please click the verification link in the email to activate your account.
                            If you didn't receive the email, check your spam folder or click the button below.
                        </div>

                        <!-- Action Buttons -->
                        <div class="space-y-4">
                            <!-- Resend Verification Email -->
                            <form method="POST" action="{{ route('verification.send') }}">
                                @csrf
                                <button type="submit"
                                        class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-yellow-600 hover:bg-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 transition-colors duration-200">
                                    <svg class="mr-2 -ml-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                                    </svg>
                                    Resend Verification Email
                                </button>
                            </form>

                            <!-- Log Out -->
                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit"
                                        class="w-full flex justify-center py-3 px-4 border border-gray-300 rounded-lg shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 transition-colors duration-200">
                                    <svg class="mr-2 -ml-1 w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/>
                                    </svg>
                                    Sign Out
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div class="px-8 py-4 bg-gray-50 border-t border-gray-200">
                        <p class="text-center text-sm text-gray-600">
                            Need help?
                            <a href="/contact" class="font-medium text-yellow-600 hover:text-yellow-700">
                                Contact Support
                            </a>
                        </p>
                    </div>
                </div>

                <!-- Additional Info -->
                <div class="mt-6 text-center">
                    <p class="text-xs text-gray-500">
                        Check your email (including spam folder) for a verification link from HireCameroon.
                    </p>
                </div>
            </div>
        </div>

        <!-- Right Side - Image/Design -->
        <div class="hidden lg:flex bg-gradient-to-br from-blue-600 via-indigo-600 to-purple-800 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 bg-black/20"></div>
            <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.1"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-20"></div>

            <!-- Content -->
            <div class="relative z-10 flex flex-col justify-center items-center text-white p-12 w-full">
                <!-- Main Illustration -->
                <div class="mb-8">
                    <div class="w-64 h-64 bg-white/10 backdrop-blur-sm rounded-3xl flex items-center justify-center shadow-2xl">
                        <svg class="w-32 h-32 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 7.89a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                    </div>
                </div>

                <!-- Text Content -->
                <div class="text-center max-w-md">
                    <h2 class="text-4xl font-bold mb-6 leading-tight">
                        Verify Your<br>
                        <span class="text-yellow-300">Email Address</span>
                    </h2>

                    <p class="text-xl text-blue-100 mb-8 leading-relaxed">
                        We need to verify your email address to ensure the security of your HireCameroon account.
                    </p>

                    <!-- Verification Benefits -->
                    <div class="space-y-4 text-left">
                        <div class="flex items-center">
                            <div class="w-6 h-6 bg-blue-400 rounded-full flex items-center justify-center mr-3">
                                <svg class="w-3 h-3 text-white" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <span class="text-blue-100">Account security</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-6 h-6 bg-blue-400 rounded-full flex items-center justify-center mr-3">
                                <svg class="w-3 h-3 text-white" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <span class="text-blue-100">Job notifications</span>
                        </div>
                        <div class="flex items-center">
                            <div class="w-6 h-6 bg-blue-400 rounded-full flex items-center justify-center mr-3">
                                <svg class="w-3 h-3 text-white" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <span class="text-blue-100">Company updates</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>
