<x-layouts.app>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <button onclick="window.history.back()" class="mr-4 p-2 text-gray-400 hover:text-gray-600 transition rounded-lg hover:bg-gray-100">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                    </svg>
                </button>
                <div>
                    <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                        {{ $company->name }}
                    </h2>
                    <p class="text-sm text-gray-600">{{ $company->sector ?? 'Company' }} • {{ $company->location ?? 'Cameroon' }}</p>
                </div>
            </div>
        </div>
    </x-slot>

    <div class="grid lg:grid-cols-3 gap-8">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Company Header Card -->
            <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                <!-- Company Image Header -->
                <div class="relative h-64 bg-gradient-to-br from-purple-600/10 via-indigo-600/10 to-blue-600/10 flex items-center justify-center">
                    @if($company->logo)
                        <img src="{{ asset('storage/' . $company->logo) }}" alt="{{ $company->name }}" class="w-32 h-32 rounded-3xl object-cover shadow-2xl border-4 border-white">
                    @else
                        <div class="w-32 h-32 bg-gradient-to-br from-purple-600 to-indigo-700 rounded-3xl flex items-center justify-center shadow-2xl border-4 border-white">
                            <span class="text-white font-black text-4xl">{{ substr($company->name, 0, 1) }}</span>
                        </div>
                    @endif
                </div>

                <!-- Company Info Section -->
                <div class="p-8">
                    <div class="text-center mb-6">
                        <h1 class="text-3xl font-black text-gray-900 mb-3">{{ $company->name }}</h1>
                        <p class="text-xl text-gray-600 font-medium">{{ $company->sector ?? 'Company Sector' }}</p>

                        <!-- Company Meta -->
                        <div class="flex flex-wrap items-center justify-center gap-4 mt-4 text-sm text-gray-500">
                            <div class="flex items-center bg-purple-50 text-purple-700 px-3 py-1 rounded-full">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                                {{ $company->location ?? 'Cameroon' }}
                            </div>
                            @if($company->size)
                            <div class="flex items-center bg-indigo-50 text-indigo-700 px-3 py-1 rounded-full">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                                </svg>
                                {{ $company->size }}
                            </div>
                            @endif
                            @if($company->founded_year)
                            <div class="flex items-center bg-green-50 text-green-700 px-3 py-1 rounded-full">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                </svg>
                                Founded {{ $company->founded_year }}
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Quick Stats -->
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
                        <div class="bg-gradient-to-br from-purple-50 to-purple-100 rounded-xl p-4 text-center border border-purple-200">
                            <div class="text-2xl font-bold text-purple-600 mb-1">{{ $company->jobs->count() }}</div>
                            <div class="text-gray-600 text-sm">Active Jobs</div>
                        </div>
                        <div class="bg-gradient-to-br from-indigo-50 to-indigo-100 rounded-xl p-4 text-center border border-indigo-200">
                            <div class="text-2xl font-bold text-indigo-600 mb-1">{{ $company->jobs->where('created_at', '>=', now()->subDays(30))->count() }}</div>
                            <div class="text-gray-600 text-sm">Jobs This Month</div>
                        </div>
                        <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl p-4 text-center border border-blue-200">
                            <div class="text-2xl font-bold text-blue-600 mb-1">{{ $company->jobs->avg('salary_max') ? number_format($company->jobs->avg('salary_max')) : 'N/A' }}</div>
                            <div class="text-gray-600 text-sm">Avg Salary (XAF)</div>
                        </div>
                        <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-xl p-4 text-center border border-green-200">
                            <div class="text-2xl font-bold text-green-600 mb-1">{{ $company->jobs->where('featured', true)->count() }}</div>
                            <div class="text-gray-600 text-sm">Featured Jobs</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Company Description -->
            @if($company->description)
            <div class="bg-white rounded-2xl shadow-lg p-8">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">About {{ $company->name }}</h2>
                <div class="prose prose-lg max-w-none text-gray-700">
                    {!! nl2br(e($company->description)) !!}
                </div>
            </div>
            @endif

            <!-- Active Jobs -->
            @if($company->jobs->count() > 0)
            <div class="bg-white rounded-2xl shadow-lg p-8">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Current Job Openings</h2>
                <div class="space-y-4">
                    @foreach($company->jobs->take(5) as $job)
                    <div class="border border-gray-200 rounded-xl p-4 hover:border-purple-300 hover:shadow-md transition-all">
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <h3 class="font-bold text-gray-900 mb-1">
                                    <a href="{{ route('jobs.show', $job) }}" class="hover:text-purple-600 transition-colors">
                                        {{ $job->title }}
                                    </a>
                                </h3>
                                <div class="flex flex-wrap items-center gap-4 text-sm text-gray-600 mb-2">
                                    <span class="flex items-center">
                                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                        </svg>
                                        {{ $job->location }}
                                    </span>
                                    <span class="flex items-center">
                                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"/>
                                        </svg>
                                        XAF {{ number_format($job->salary_max ?? $job->salary_min ?? 0) }}
                                    </span>
                                    <span class="flex items-center">
                                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                        {{ $job->created_at->diffForHumans() }}
                                    </span>
                                </div>
                                <p class="text-gray-700 text-sm line-clamp-2">{{ Str::limit($job->description, 150) }}</p>
                            </div>
                            <a href="{{ route('jobs.show', $job) }}" class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded-lg text-sm font-medium transition-colors">
                                Apply Now
                            </a>
                        </div>
                    </div>
                    @endforeach

                    @if($company->jobs->count() > 5)
                    <div class="text-center pt-4">
                        <a href="{{ route('jobs.index', ['q' => $company->name]) }}" class="text-purple-600 hover:text-purple-700 font-medium">
                            View all {{ $company->jobs->count() }} jobs →
                        </a>
                    </div>
                    @endif
                </div>
            </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Company Details -->
            <div class="bg-white rounded-2xl shadow-lg p-6">
                <h3 class="text-xl font-bold text-gray-900 mb-4">Company Details</h3>
                <div class="space-y-4">
                    @if($company->website)
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600 flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"/>
                            </svg>
                            Website
                        </span>
                        <a href="{{ $company->website }}" target="_blank" class="text-purple-600 hover:text-purple-700 font-medium">
                            Visit Site →
                        </a>
                    </div>
                    @endif

                    @if($company->sector)
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600 flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                            </svg>
                            Sector
                        </span>
                        <span class="font-bold text-gray-900">{{ $company->sector }}</span>
                    </div>
                    @endif

                    @if($company->size)
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600 flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                            </svg>
                            Company Size
                        </span>
                        <span class="font-bold text-gray-900">{{ $company->size }}</span>
                    </div>
                    @endif

                    @if($company->founded_year)
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600 flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                            Founded
                        </span>
                        <span class="font-bold text-gray-900">{{ $company->founded_year }}</span>
                    </div>
                    @endif

                    @if($company->registration_no)
                    <div class="flex justify-between items-center">
                        <span class="text-gray-600 flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                            Registration
                        </span>
                        <span class="font-bold text-gray-900">{{ $company->registration_no }}</span>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Contact Information -->
            @if($company->owner)
            <div class="bg-white rounded-2xl shadow-lg p-6">
                <h3 class="text-xl font-bold text-gray-900 mb-4">Contact Information</h3>
                <div class="flex items-center mb-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-indigo-600 rounded-xl flex items-center justify-center mr-4">
                        <span class="text-white font-bold">{{ substr($company->owner->name, 0, 1) }}</span>
                    </div>
                    <div>
                        <h4 class="font-bold text-gray-900">{{ $company->owner->name }}</h4>
                        <p class="text-gray-600 text-sm">Company Representative</p>
                    </div>
                </div>
                <p class="text-gray-700 text-sm">
                    For inquiries about job opportunities or partnerships, please reach out through our job postings or contact form.
                </p>
            </div>
            @endif

            <!-- Similar Companies -->
            <div class="bg-white rounded-2xl shadow-lg p-6">
                <h3 class="text-xl font-bold text-gray-900 mb-4">Similar Companies</h3>
                <div class="space-y-3">
                    <!-- This would be populated with similar companies based on sector/location -->
                    <div class="text-center py-8">
                        <svg class="w-12 h-12 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                        <p class="text-gray-500 text-sm">Similar companies will be shown here</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layouts.app>