<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'HireCameroon') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Favicon -->
        <link rel="icon" type="image/png" href="{{ asset('assets/brand/logo.png') }}">

        <!-- Scripts -->
        <!-- Production assets -->
        <link rel="stylesheet" href="/build/assets/app-0504b4a9.css">
        <script type="module" src="/build/assets/app-4fed7f7e.js"></script>

        <!-- Custom Styles -->
        <style>
            @keyframes slideIn {
                0% { transform: translateX(-100%) translateY(-50%); }
                100% { transform: translateX(0) translateY(-50%); }
            }
            @keyframes pulse {
                0% { transform: translateY(-50%) scale(1); }
                50% { transform: translateY(-50%) scale(1.05); }
                100% { transform: translateY(-50%) scale(1); }
            }
            .floating-ad-button {
                animation: slideIn 0.5s ease-out forwards, pulse 2s ease-in-out 1s 1;
            }
            @media (max-width: 640px) {
                .floating-ad-button {
                    padding: 0.75rem !important;
                }
                .floating-ad-button span {
                    display: none;
                }
                .floating-ad-button:hover {
                    padding: 0.75rem !important;
                }
            }
        </style>
    </head>
    <body class="font-sans antialiased">
        <!-- Floating Ads Button with proper z-index management -->
        <div class="fixed left-0 top-1/2 -translate-y-1/2 z-40 group" style="margin-left: 0;">
            <button onclick="window.location.href='/ads/create'"
               class="floating-ad-button flex items-center bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white px-4 py-3 rounded-r-lg shadow-xl transition-all duration-300 hover:px-6 relative hover:shadow-2xl">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z" />
                </svg>
                <span class="font-semibold">Post an Ad</span>
                
                <!-- Tooltip -->
                <div class="hidden group-hover:block absolute left-full ml-2 px-3 py-2 bg-gray-800 text-white text-sm rounded whitespace-nowrap shadow-lg z-50">
                    <div class="absolute left-0 top-1/2 transform -translate-x-1/2 -translate-y-1/2">
                        <div class="border-8 border-transparent border-r-gray-800"></div>
                    </div>
                    Boost your visibility! Create an advertisement
                </div>
            </button>
        </div>
        
        <div class="min-h-screen bg-gray-100 relative z-0" style="z-index: 1;">
            @auth
                @include('layouts.navigation')
            @endauth

            <!-- Page Heading -->
            @if (isset($header))
                <header class="bg-white shadow">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        {{ $header }}
                    </div>
                </header>
            @endif

            <!-- Page Content -->
            <main>
                {{ $slot }}
            </main>

            <!-- Footer -->
            <footer class="bg-gray-50 border-t border-gray-200">
                <div class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:py-16 lg:px-8">
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                        <!-- Company Info -->
                        <div class="col-span-1 md:col-span-2">
                            <div class="flex items-center mb-4">
                                <img src="{{ asset('assets/brand/logo.png') }}" alt="HireCameroon" class="h-8 w-auto mr-3">
                                <span class="text-xl font-bold text-gray-900">HireCameroon</span>
                            </div>
                            <p class="text-gray-600 max-w-md">
                                Connecting talent with opportunities across Cameroon. Find your next career move or hire the best professionals.
                            </p>
                            <div class="mt-6 flex space-x-4">
                                <a href="#" class="text-gray-400 hover:text-gray-500">
                                    <span class="sr-only">Facebook</span>
                                    <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
                                        <path fill-rule="evenodd" d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z" clip-rule="evenodd" />
                                    </svg>
                                </a>
                                <a href="#" class="text-gray-400 hover:text-gray-500">
                                    <span class="sr-only">Twitter</span>
                                    <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84" />
                                    </svg>
                                </a>
                            </div>
                        </div>

                        <!-- Quick Links -->
                        <div>
                            <h3 class="text-sm font-semibold text-gray-900 tracking-wider uppercase">Quick Links</h3>
                            <ul class="mt-4 space-y-4">
                                <li><a href="{{ route('jobs.index') }}" class="text-base text-gray-600 hover:text-gray-900">Browse Jobs</a></li>
                                <li><a href="{{ route('companies.index') }}" class="text-base text-gray-600 hover:text-gray-900">Companies</a></li>
                                <li><a href="{{ route('pricing') }}" class="text-base text-gray-600 hover:text-gray-900">Pricing</a></li>
                                <li><a href="{{ route('about') }}" class="text-base text-gray-600 hover:text-gray-900">About</a></li>
                            </ul>
                        </div>

                        <!-- Support -->
                        <div>
                            <h3 class="text-sm font-semibold text-gray-900 tracking-wider uppercase">Support</h3>
                            <ul class="mt-4 space-y-4">
                                <li><a href="{{ route('contact') }}" class="text-base text-gray-600 hover:text-gray-900">Contact Us</a></li>
                                <li><a href="{{ route('faq') }}" class="text-base text-gray-600 hover:text-gray-900">FAQ</a></li>
                                <li><a href="{{ route('privacy') }}" class="text-base text-gray-600 hover:text-gray-900">Privacy Policy</a></li>
                                <li><a href="#" class="text-base text-gray-600 hover:text-gray-900">Terms of Service</a></li>
                            </ul>
                        </div>
                    </div>

                    <div class="mt-8 border-t border-gray-200 pt-8">
                        <p class="text-base text-gray-400 xl:text-center">
                            &copy; 2025 HireCameroon. All rights reserved.
                        </p>
                    </div>
                </div>
            </footer>
        </div>
    </body>
</html>