@props(['user' => null, 'size' => 'md', 'showTooltip' => false, 'id' => null])

@php
    $sizes = [
        'xs' => 'w-6 h-6 text-xs',
        'sm' => 'w-8 h-8 text-sm', 
        'md' => 'w-10 h-10 text-sm',
        'lg' => 'w-16 h-16 text-lg',
        'xl' => 'w-20 h-20 text-xl',
        '2xl' => 'w-32 h-32 text-2xl',
    ];
    
    $sizeClass = $sizes[$size] ?? $sizes['md'];
@endphp

<div class="relative inline-flex items-center justify-center {{ $sizeClass }} bg-gray-200 rounded-full overflow-hidden group"
     @if($showTooltip) title="{{ $user?->name ?? 'User' }}" @endif
     @if($id) id="{{ $id }}" @endif>
    
    <div class="w-full h-full flex items-center justify-center font-semibold text-white"
         style="background-color: {{ $user?->avatar_color ?? '#6B7280' }}">
        {{ strtoupper($user?->initials ?? 'U') }}
    </div>
    
    @if($showTooltip)
        <div class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-3 py-2 bg-gray-900 text-white text-sm rounded-lg opacity-0 group-hover:opacity-100 transition-opacity duration-200 pointer-events-none whitespace-nowrap z-50">
            {{ $user?->name ?? 'User' }}
            <div class="absolute top-full left-1/2 transform -translate-x-1/2 border-4 border-transparent border-t-gray-900"></div>
        </div>
    @endif
</div>