<x-mail::message>
# Application Status Update

Hello {{ $user->name }},

Your application status for the position **{{ $job->title }}** at **{{ $company->name }}** has been updated.

## Application Details
- **Position:** {{ $job->title }}
- **Company:** {{ $company->name }}
- **Location:** {{ $job->location }}
- **Status:** {{ ucfirst($application->status) }}

@if($application->status === 'accepted')
## Congratulations! 🎉

Your application has been accepted! The company will be in touch soon with next steps.
@elseif($application->status === 'rejected')
## Application Update

We regret to inform you that your application was not selected for this position. We encourage you to apply for other opportunities that match your skills.
@elseif($application->status === 'under_review')
## Under Review

Your application is currently under review. The company will contact you soon with an update.
@elseif($application->status === 'interview_scheduled')
## Interview Scheduled

Congratulations! Your application has progressed to the interview stage. The company will contact you with scheduling details.
@endif

You can view your application details and track its progress by logging into your HireCameroon account.

<x-mail::button :url="route('applications.show', $application)" color="primary">
View Application Details
</x-mail::button>

If you have any questions, please don't hesitate to contact us.

Best regards,<br>
The HireCameroon Team

---
<small>This is an automated message. Please do not reply to this email.</small>
</x-mail::message>