<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HireCameroon Installer</title>
    <link rel="stylesheet" href="/build/assets/app-3c551ebb.css">
    <style>
        :root{--brand-navy:#0F2D3A;--brand-red:#D62D2D;--brand-green:#157D4B;--brand-gold:#F0B323}
        body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;background:#f8fafc}
        .card{max-width:760px;margin:2rem auto;background:#fff;border-radius:8px;border:1px solid #e5e7eb;padding:1.25rem}
        .btn{background:var(--brand-green);color:#fff;padding:.6rem 1rem;border:none;border-radius:6px;cursor:pointer}
        .btn:disabled{opacity:.6;cursor:not-allowed}
        .title{color:var(--brand-navy)}
        .hint{color:#6b7280;font-size:.9rem}
        .error{color:#b91c1c}
        label{display:block;margin-top:.75rem}
        input{width:100%;padding:.55rem;border:1px solid #d1d5db;border-radius:6px}
        .grid{display:grid;grid-template-columns:1fr 1fr;gap:12px}
    </style>
    @vite(['resources/css/app.css','resources/js/app.js'])
    </head>
<body>
    <div class="card">
        <h2 class="title">HireCameroon Installer</h2>
        <p class="hint">Fill in your database and admin details. The installer will write .env and either import <code>database/HireCameroon.sql</code> if present, or run migrations and create the admin account.</p>

        @if ($errors->any())
            <div class="error">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="post" action="{{ route('install.store') }}">
            @csrf
            <label>App URL
                <input type="text" name="app_url" value="{{ old('app_url', config('app.url')) }}" placeholder="http://yourdomain.com">
            </label>

            <div class="grid">
                <div>
                    <label>DB Host
                        <input type="text" name="db_host" value="{{ old('db_host','127.0.0.1') }}">
                    </label>
                </div>
                <div>
                    <label>DB Port
                        <input type="text" name="db_port" value="{{ old('db_port','3306') }}">
                    </label>
                </div>
            </div>

            <div class="grid">
                <div>
                    <label>DB Database
                        <input type="text" name="db_database" value="{{ old('db_database','hirecameroon') }}">
                    </label>
                </div>
                <div>
                    <label>DB Username
                        <input type="text" name="db_username" value="{{ old('db_username','root') }}">
                    </label>
                </div>
            </div>

            <label>DB Password
                <input type="password" name="db_password" value="{{ old('db_password') }}">
            </label>

            <hr style="margin:1rem 0;">
            <div class="grid">
                <div>
                    <label>Admin Name
                        <input type="text" name="admin_name" value="{{ old('admin_name','Administrator') }}">
                    </label>
                </div>
                <div>
                    <label>Admin Email
                        <input type="email" name="admin_email" value="{{ old('admin_email') }}" placeholder="admin@example.com">
                    </label>
                </div>
            </div>

            <label>Admin Password
                <input type="password" name="admin_password" value="{{ old('admin_password') }}" placeholder="Minimum 8 characters">
            </label>

            <div style="margin-top:1rem">
                <button class="btn" type="submit">Install HireCameroon</button>
            </div>
        </form>
    </div>
</body>
</html>


