@extends('layouts.marketing')

@section('title', 'FAQ – HireCameroon')

@section('content')
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-brand-navy via-slate-800 to-brand-navy text-white py-20 relative overflow-hidden">
        <div class="absolute inset-0 bg-black/20"></div>
        <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.05"%3E%3Ccircle cx="30" cy="30" r="1"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-20"></div>
        <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h1 class="text-5xl md:text-6xl font-bold mb-6">
                Frequently Asked <span class="bg-gradient-to-r from-yellow-400 to-orange-500 bg-clip-text text-transparent">Questions</span>
            </h1>
            <p class="text-xl text-slate-300 max-w-3xl mx-auto leading-relaxed">
                Everything you need to know about HireCameroon. Can't find what you're looking for? Contact our support team.
            </p>
        </div>
    </section>

    <!-- FAQ Accordion Section -->
    <section class="py-20 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="space-y-4">
                <!-- Getting Started -->
                <div class="mb-8">
                    <h2 class="text-2xl font-bold text-brand-navy mb-6 flex items-center">
                        <svg class="w-6 h-6 mr-3 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                        Getting Started
                    </h2>

                    <div class="space-y-4">
                        <!-- FAQ Item 1 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-1">
                                <h3 class="font-semibold text-gray-900 pr-4">Is HireCameroon free to use?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-1" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Yes! Creating an account and searching for jobs is completely free. Employers can post one job for free, with paid plans starting at 25,000 XAF/month for unlimited postings and premium features like featured listings and advanced analytics.</p>
                            </div>
                        </div>

                        <!-- FAQ Item 2 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-2">
                                <h3 class="font-semibold text-gray-900 pr-4">How do I create an account?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-2" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Click the "Sign Up" button in the top right corner. Fill in your basic information, verify your email, and complete your profile. For job seekers, we recommend uploading your CV and adding your skills for better job matches.</p>
                            </div>
                        </div>

                        <!-- FAQ Item 3 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-3">
                                <h3 class="font-semibold text-gray-900 pr-4">How does the bilingual support work?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-3" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Our platform supports both English and French seamlessly. You can create your profile, search for jobs, and communicate in your preferred language. All major features are available in both languages, and our AI matching system works across languages.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- For Job Seekers -->
                <div class="mb-8">
                    <h2 class="text-2xl font-bold text-brand-navy mb-6 flex items-center">
                        <svg class="w-6 h-6 mr-3 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        For Job Seekers
                    </h2>

                    <div class="space-y-4">
                        <!-- FAQ Item 4 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-4">
                                <h3 class="font-semibold text-gray-900 pr-4">How do I search for jobs?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-4" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Use the search bar on our homepage or visit the Jobs page. You can search by job title, company, location, or keywords. Use filters to narrow down results by salary, experience level, job type, and more.</p>
                            </div>
                        </div>

                        <!-- FAQ Item 5 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-5">
                                <h3 class="font-semibold text-gray-900 pr-4">How do I apply for jobs?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-5" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Click on any job listing to view details, then click "Apply Now". You'll need to submit your CV/resume and may be asked to answer screening questions. Track your applications in your dashboard.</p>
                            </div>
                        </div>

                        <!-- FAQ Item 6 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-6">
                                <h3 class="font-semibold text-gray-900 pr-4">How quickly can I get hired?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-6" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Our average time to first applicant is just 48 hours! Many users find suitable opportunities within their first week on the platform. Premium job postings get even faster response times.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- For Employers -->
                <div class="mb-8">
                    <h2 class="text-2xl font-bold text-brand-navy mb-6 flex items-center">
                        <svg class="w-6 h-6 mr-3 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                        For Employers
                    </h2>

                    <div class="space-y-4">
                        <!-- FAQ Item 7 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-7">
                                <h3 class="font-semibold text-gray-900 pr-4">How do I post a job?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-7" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Sign up for a company account, then click "Post a Job" from your dashboard. Fill in job details, requirements, and salary. You can post one job for free, or upgrade to unlimited postings.</p>
                            </div>
                        </div>

                        <!-- FAQ Item 8 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-8">
                                <h3 class="font-semibold text-gray-900 pr-4">What are featured listings?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-8" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Featured listings appear at the top of search results and get premium placement. They include up to 5 featured listings per month in our Professional plan, helping you reach more qualified candidates faster.</p>
                            </div>
                        </div>

                        <!-- FAQ Item 9 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-9">
                                <h3 class="font-semibold text-gray-900 pr-4">How do I manage applications?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-9" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Use your company dashboard to view all applications. Our ATS system helps you track candidates through different stages: Applied, Shortlisted, Interviewed, Offered, and Hired. You can also schedule interviews and communicate directly with candidates.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payments & Billing -->
                <div class="mb-8">
                    <h2 class="text-2xl font-bold text-brand-navy mb-6 flex items-center">
                        <svg class="w-6 h-6 mr-3 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"/>
                        </svg>
                        Payments & Billing
                    </h2>

                    <div class="space-y-4">
                        <!-- FAQ Item 10 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-10">
                                <h3 class="font-semibold text-gray-900 pr-4">What payment methods do you accept?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-10" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">We accept all major mobile money providers in Cameroon (MTN, Orange, etc.) through our Mesomb integration, as well as bank transfers. All payments are secure and processed through trusted financial institutions.</p>
                            </div>
                        </div>

                        <!-- FAQ Item 11 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-11">
                                <h3 class="font-semibold text-gray-900 pr-4">Can I change plans at any time?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-11" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Yes! You can upgrade or downgrade your plan at any time. Changes take effect immediately, and we'll prorate any charges. No long-term contracts or cancellation fees.</p>
                            </div>
                        </div>

                        <!-- FAQ Item 12 -->
                        <div class="bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
                            <button class="faq-toggle w-full px-6 py-4 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-12">
                                <h3 class="font-semibold text-gray-900 pr-4">Are payments secure?</h3>
                                <svg class="faq-icon w-5 h-5 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div id="faq-12" class="faq-content px-6 pb-4 hidden">
                                <p class="text-gray-600 leading-relaxed">Absolutely! We use Mesomb for secure mobile money payments and bank-level encryption for all data. All transactions are processed through trusted financial institutions with industry-standard security protocols.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact CTA -->
            <div class="mt-16 text-center">
                <div class="bg-gradient-to-r from-brand-navy to-slate-800 rounded-2xl p-8 text-white">
                    <h3 class="text-2xl font-bold mb-4">Still have questions?</h3>
                    <p class="text-slate-300 mb-6">Our support team is here to help you succeed on HireCameroon.</p>
                    <div class="flex flex-col sm:flex-row gap-4 justify-center">
                        <a href="/contact" class="inline-flex items-center px-6 py-3 bg-yellow-400 hover:bg-yellow-500 text-black font-semibold rounded-lg transition">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                            </svg>
                            Contact Support
                        </a>
                        <a href="mailto:hello@hirecameroon.com" class="inline-flex items-center px-6 py-3 bg-white/10 backdrop-blur-sm border border-white/20 text-white font-semibold rounded-lg hover:bg-white/20 transition">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                            Email Us
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const toggles = document.querySelectorAll('.faq-toggle');

            toggles.forEach(toggle => {
                toggle.addEventListener('click', function() {
                    const targetId = this.getAttribute('data-target');
                    const content = document.getElementById(targetId);
                    const icon = this.querySelector('.faq-icon');

                    // Close all other FAQs
                    document.querySelectorAll('.faq-content').forEach(item => {
                        if (item.id !== targetId) {
                            item.classList.add('hidden');
                            item.previousElementSibling.querySelector('.faq-icon').classList.remove('rotate-180');
                        }
                    });

                    // Toggle current FAQ
                    content.classList.toggle('hidden');
                    icon.classList.toggle('rotate-180');
                });
            });
        });
    </script>
@endsection