@extends('layouts.marketing')

@section('title', 'Privacy Policy – HireCameroon')

@section('content')
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-black via-gray-900 to-black text-white py-20 relative overflow-hidden">
        <div class="absolute inset-0 bg-black/20"></div>
        <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.05"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-20"></div>
        <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h1 class="text-5xl md:text-6xl font-bold mb-6">
                Privacy <span class="bg-gradient-to-r from-yellow-400 to-yellow-500 bg-clip-text text-transparent">Policy</span>
            </h1>
            <p class="text-xl text-gray-300 max-w-3xl mx-auto leading-relaxed">
                Your privacy is our priority. Learn how we collect, use, and protect your personal information.
            </p>
        </div>
    </section>

    <!-- Privacy Content -->
    <section class="py-20 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="prose prose-lg max-w-none">
                <div class="bg-yellow-400/10 border-l-4 border-yellow-400 p-6 mb-8 rounded-r-lg">
                    <p class="text-black font-semibold text-lg m-0">
                        <strong>Last Updated:</strong> October 30, 2024
                    </p>
                </div>

                <h2 class="text-3xl font-bold text-black mb-6">1. Information We Collect</h2>

                <h3 class="text-2xl font-bold text-black mb-4">Personal Information</h3>
                <p class="text-gray-700 text-lg leading-relaxed mb-6">
                    We collect information you provide directly to us, such as when you create an account, post jobs, apply for positions, or contact us for support. This includes:
                </p>
                <ul class="list-disc pl-8 text-gray-700 text-lg mb-8 space-y-2">
                    <li>Name, email address, phone number</li>
                    <li>Professional information (resume, work experience, skills)</li>
                    <li>Company information for employers</li>
                    <li>Communication preferences</li>
                </ul>

                <h3 class="text-2xl font-bold text-black mb-4">Automatically Collected Information</h3>
                <p class="text-gray-700 text-lg leading-relaxed mb-6">
                    When you use our platform, we automatically collect certain information:
                </p>
                <ul class="list-disc pl-8 text-gray-700 text-lg mb-8 space-y-2">
                    <li>IP address and location data</li>
                    <li>Device and browser information</li>
                    <li>Usage patterns and platform interactions</li>
                    <li>Cookies and similar technologies</li>
                </ul>

                <h2 class="text-3xl font-bold text-black mb-6">2. How We Use Your Information</h2>

                <div class="grid md:grid-cols-2 gap-8 mb-8">
                    <div class="bg-gray-50 p-6 rounded-xl">
                        <h4 class="text-xl font-bold text-black mb-3">For Job Seekers</h4>
                        <ul class="text-gray-700 space-y-2">
                            <li>• Create and manage your profile</li>
                            <li>• Match you with relevant opportunities</li>
                            <li>• Facilitate job applications</li>
                            <li>• Send job recommendations</li>
                        </ul>
                    </div>
                    <div class="bg-gray-50 p-6 rounded-xl">
                        <h4 class="text-xl font-bold text-black mb-3">For Employers</h4>
                        <ul class="text-gray-700 space-y-2">
                            <li>• Post and manage job listings</li>
                            <li>• Review and manage applications</li>
                            <li>• Communicate with candidates</li>
                            <li>• Access hiring analytics</li>
                        </ul>
                    </div>
                </div>

                <h2 class="text-3xl font-bold text-black mb-6">3. Information Sharing</h2>

                <p class="text-gray-700 text-lg leading-relaxed mb-6">
                    We do not sell, trade, or rent your personal information to third parties. We may share your information only in the following circumstances:
                </p>

                <div class="space-y-4 mb-8">
                    <div class="bg-white border-2 border-yellow-400 rounded-xl p-6 shadow-lg">
                        <h4 class="text-lg font-bold text-black mb-2">With Your Consent</h4>
                        <p class="text-gray-700">When you explicitly agree to share information with employers or other users.</p>
                    </div>

                    <div class="bg-white border-2 border-black rounded-xl p-6 shadow-lg">
                        <h4 class="text-lg font-bold text-black mb-2">Service Providers</h4>
                        <p class="text-gray-700">With trusted third-party service providers who help us operate our platform (payment processors, email services, etc.).</p>
                    </div>

                    <div class="bg-white border-2 border-yellow-400 rounded-xl p-6 shadow-lg">
                        <h4 class="text-lg font-bold text-black mb-2">Legal Requirements</h4>
                        <p class="text-gray-700">When required by law or to protect our rights, safety, or the rights of others.</p>
                    </div>
                </div>

                <h2 class="text-3xl font-bold text-black mb-6">4. Data Security</h2>

                <div class="bg-gradient-to-r from-black to-gray-800 text-white p-8 rounded-2xl mb-8">
                    <h3 class="text-2xl font-bold mb-4">Enterprise-Grade Security</h3>
                    <div class="grid md:grid-cols-3 gap-6">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-yellow-400 rounded-full flex items-center justify-center mx-auto mb-3">
                                <span class="text-black font-bold text-xl">🔒</span>
                            </div>
                            <h4 class="font-bold mb-2">256-bit SSL</h4>
                            <p class="text-gray-300 text-sm">Bank-level encryption</p>
                        </div>
                        <div class="text-center">
                            <div class="w-12 h-12 bg-yellow-400 rounded-full flex items-center justify-center mx-auto mb-3">
                                <span class="text-black font-bold text-xl">🛡️</span>
                            </div>
                            <h4 class="font-bold mb-2">SOC 2 Certified</h4>
                            <p class="text-gray-300 text-sm">Security compliance</p>
                        </div>
                        <div class="text-center">
                            <div class="w-12 h-12 bg-yellow-400 rounded-full flex items-center justify-center mx-auto mb-3">
                                <span class="text-black font-bold text-xl">🔐</span>
                            </div>
                            <h4 class="font-bold mb-2">GDPR Compliant</h4>
                            <p class="text-gray-300 text-sm">Privacy protection</p>
                        </div>
                    </div>
                </div>

                <h2 class="text-3xl font-bold text-black mb-6">5. Your Rights</h2>

                <p class="text-gray-700 text-lg leading-relaxed mb-6">
                    You have the following rights regarding your personal information:
                </p>

                <div class="grid md:grid-cols-2 gap-6 mb-8">
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="w-8 h-8 bg-yellow-400 rounded-full flex items-center justify-center mr-4 mt-1 flex-shrink-0">
                                <span class="text-black font-bold">✓</span>
                            </div>
                            <div>
                                <h4 class="font-bold text-black">Access</h4>
                                <p class="text-gray-700">Request a copy of your personal data</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="w-8 h-8 bg-black rounded-full flex items-center justify-center mr-4 mt-1 flex-shrink-0">
                                <span class="text-yellow-400 font-bold">✓</span>
                            </div>
                            <div>
                                <h4 class="font-bold text-black">Rectification</h4>
                                <p class="text-gray-700">Correct inaccurate or incomplete data</p>
                            </div>
                        </div>
                    </div>
                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div class="w-8 h-8 bg-yellow-400 rounded-full flex items-center justify-center mr-4 mt-1 flex-shrink-0">
                                <span class="text-black font-bold">✓</span>
                            </div>
                            <div>
                                <h4 class="font-bold text-black">Erasure</h4>
                                <p class="text-gray-700">Request deletion of your data</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="w-8 h-8 bg-black rounded-full flex items-center justify-center mr-4 mt-1 flex-shrink-0">
                                <span class="text-yellow-400 font-bold">✓</span>
                            </div>
                            <div>
                                <h4 class="font-bold text-black">Portability</h4>
                                <p class="text-gray-700">Receive your data in a portable format</p>
                            </div>
                        </div>
                    </div>
                </div>

                <h2 class="text-3xl font-bold text-black mb-6">6. Cookies and Tracking</h2>

                <p class="text-gray-700 text-lg leading-relaxed mb-6">
                    We use cookies and similar technologies to enhance your experience, analyze usage, and provide personalized content. You can control cookie preferences through your browser settings.
                </p>

                <h2 class="text-3xl font-bold text-black mb-6">7. Data Retention</h2>

                <p class="text-gray-700 text-lg leading-relaxed mb-6">
                    We retain your personal information for as long as necessary to provide our services and comply with legal obligations. You can request deletion of your account and associated data at any time.
                </p>

                <h2 class="text-3xl font-bold text-black mb-6">8. International Data Transfers</h2>

                <p class="text-gray-700 text-lg leading-relaxed mb-6">
                    Your data is primarily stored in secure data centers. When international transfers occur, we ensure appropriate safeguards are in place to protect your information.
                </p>

                <h2 class="text-3xl font-bold text-black mb-6">9. Children's Privacy</h2>

                <p class="text-gray-700 text-lg leading-relaxed mb-6">
                    Our services are not intended for individuals under 16 years of age. We do not knowingly collect personal information from children under 16.
                </p>

                <h2 class="text-3xl font-bold text-black mb-6">10. Changes to This Policy</h2>

                <p class="text-gray-700 text-lg leading-relaxed mb-6">
                    We may update this Privacy Policy from time to time. We will notify you of any material changes via email or platform notification.
                </p>

                <h2 class="text-3xl font-bold text-black mb-6">11. Contact Us</h2>

                <p class="text-gray-700 text-lg leading-relaxed mb-8">
                    If you have any questions about this Privacy Policy or our data practices, please contact us:
                </p>

                <div class="bg-gray-50 p-8 rounded-2xl">
                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="font-bold text-black mb-2">Email</h4>
                            <p class="text-gray-700">privacy@hirecameroon.com</p>
                        </div>
                        <div>
                            <h4 class="font-bold text-black mb-2">Address</h4>
                            <p class="text-gray-700">Akwa, Bonanjo District<br>Douala, Cameroon</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection