<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Subscribe to Pro for ') }} {{ $company->name }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    @if (session('status'))
                        <div class="mb-4 text-green-700">{{ session('status') }}</div>
                    @endif
                    @if ($errors->any())
                        <div class="mb-4 text-red-700">{{ $errors->first() }}</div>
                    @endif

                    <p class="text-slate-700">Price: <strong>15,000 XAF / month</strong></p>

                    <form class="mt-4" method="post" action="{{ route('subscriptions.start', $company) }}">
                        @csrf
                        <label class="block text-sm text-slate-600">Mobile number (MSISDN)
                            <input name="msisdn" class="mt-1 w-full border border-gray-300 rounded-md p-3" placeholder="67XXXXXXXX" required>
                        </label>
                        <button class="hc-btn-primary mt-4" type="submit">Pay with Mesomb</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>


