<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['job']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['job']); ?>
<?php foreach (array_filter((['job']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div class="bg-white rounded-xl shadow-sm hover:shadow-lg transition-shadow duration-300 border border-gray-100 overflow-hidden">
    <!-- Company Header -->
    <div class="p-4 flex items-start justify-between">
        <div class="flex items-start space-x-3">
            <div class="flex-shrink-0">
                <?php if($job->organization->logo): ?>
                    <img src="<?php echo e(Storage::url($job->organization->logo)); ?>" alt="<?php echo e($job->organization->name); ?>"
                         class="w-12 h-12 rounded-lg object-cover bg-gray-50">
                <?php else: ?>
                    <div class="w-12 h-12 rounded-lg bg-gradient-to-br from-yellow-400 to-yellow-500 flex items-center justify-center">
                        <span class="text-white font-bold text-xl"><?php echo e(substr($job->organization->name, 0, 1)); ?></span>
                    </div>
                <?php endif; ?>
            </div>
            <div>
                <div class="flex items-center space-x-2">
                    <h3 class="font-bold text-gray-900 hover:text-yellow-600 transition-colors">
                        <a href="<?php echo e(route('companies.show', $job->organization)); ?>"><?php echo e($job->organization->name); ?></a>
                    </h3>
                    <?php if($job->organization->is_verified ?? false): ?>
                        <svg class="w-5 h-5 text-blue-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                    <?php endif; ?>
                </div>
                <div class="flex items-center text-sm text-gray-500 mt-0.5">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    <?php echo e($job->created_at->diffForHumans()); ?>

                    <?php if($job->is_promoted): ?>
                        <span class="ml-2 px-2 py-0.5 text-xs font-medium bg-gradient-to-r from-yellow-400 to-yellow-500 text-black rounded-full">
                            Promoted
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Action Menu -->
        <div class="relative" x-data="{ open: false }">
            <button @click="open = !open" class="p-1 rounded-full hover:bg-gray-100 focus:outline-none">
                <svg class="w-6 h-6 text-gray-500" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M6 10a2 2 0 11-4 0 2 2 0 014 0zM12 10a2 2 0 11-4 0 2 2 0 014 0zM16 12a2 2 0 100-4 2 2 0 000 4z"/>
                </svg>
            </button>
            <div x-show="open" @click.away="open = false" 
                 class="absolute right-0 mt-2 w-48 bg-white rounded-xl shadow-lg border border-gray-100 z-50"
                 x-transition:enter="transition ease-out duration-200"
                 x-transition:enter-start="opacity-0 transform scale-95"
                 x-transition:enter-end="opacity-100 transform scale-100"
                 x-transition:leave="transition ease-in duration-75"
                 x-transition:leave-start="opacity-100 transform scale-100"
                 x-transition:leave-end="opacity-0 transform scale-95">
                <div class="py-1">
                    <a href="#" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 5a2 2 0 012-2h10a2 2 0 012 2v16l-7-3.5L5 21V5z"/>
                        </svg>
                        Save Job
                    </a>
                    <a href="#" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"/>
                        </svg>
                        Share Job
                    </a>
                    <a href="#" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                        </svg>
                        Report Job
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Job Content -->
    <div class="px-4 pb-4">
        <a href="<?php echo e(route('jobs.show', $job)); ?>" class="block group">
            <h2 class="text-xl font-bold text-gray-900 group-hover:text-yellow-600 transition-colors mb-2">
                <?php echo e($job->title); ?>

            </h2>
            
            <div class="flex flex-wrap gap-2 mb-3">
                <?php if($job->salary_range): ?>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                        <?php echo e($job->salary_range); ?>

                    </span>
                <?php endif; ?>
                
                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                    <?php echo e($job->type); ?>

                </span>

                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-purple-100 text-purple-800">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    <?php echo e($job->location); ?>

                </span>
            </div>

            <p class="text-gray-600 line-clamp-3 mb-4"><?php echo e($job->description); ?></p>

            <!-- Requirements Preview -->
            <?php if($job->requirements): ?>
                <div class="space-y-2 mb-4">
                    <h4 class="font-semibold text-gray-900">Key Requirements:</h4>
                    <ul class="space-y-1">
                        <?php $__currentLoopData = explode("\n", $job->requirements); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requirement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(trim($requirement)): ?>
                                <li class="flex items-start">
                                    <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                    <span class="text-sm text-gray-600"><?php echo e(trim($requirement)); ?></span>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
        </a>
    </div>

    <!-- Engagement Stats -->
    <div class="border-t border-gray-100 px-4 py-3">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-4">
                <button type="button" 
                        class="flex items-center text-gray-500 hover:text-yellow-600 transition-colors"
                        onclick="likeJob(<?php echo e($job->id); ?>)">
                    <svg class="w-5 h-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                    </svg>
                    <span class="text-sm"><?php echo e(number_format($job->likes_count ?? 0)); ?></span>
                </button>

                <button type="button" 
                        class="flex items-center text-gray-500 hover:text-yellow-600 transition-colors"
                        onclick="showComments(<?php echo e($job->id); ?>)">
                    <svg class="w-5 h-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                    </svg>
                    <span class="text-sm"><?php echo e(number_format($job->comments_count ?? 0)); ?></span>
                </button>

                <button type="button" 
                        class="flex items-center text-gray-500 hover:text-yellow-600 transition-colors"
                        onclick="shareJob(<?php echo e($job->id); ?>)">
                    <svg class="w-5 h-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"/>
                    </svg>
                    <span class="text-sm"><?php echo e(number_format($job->shares_count ?? 0)); ?></span>
                </button>
            </div>

            <a href="<?php echo e(route('jobs.show', $job)); ?>" 
               class="inline-flex items-center px-4 py-2 border border-yellow-400 rounded-lg text-sm font-medium text-black bg-yellow-400 hover:bg-yellow-500 transition-colors">
                Apply Now
                <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"/>
                </svg>
            </a>
        </div>
    </div>

    <!-- Comments Section (Initially Hidden) -->
    <div id="comments-<?php echo e($job->id); ?>" class="hidden border-t border-gray-100">
        <div class="p-4 space-y-4">
            <!-- Comment Input -->
            <div class="flex items-start space-x-3">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 rounded-full bg-gray-200"></div>
                </div>
                <div class="flex-grow">
                    <textarea rows="1" 
                              class="w-full px-3 py-2 border border-gray-200 rounded-lg text-sm focus:ring-2 focus:ring-yellow-400 focus:border-yellow-400"
                              placeholder="Write a comment..."></textarea>
                </div>
                <button type="button" 
                        class="px-4 py-2 bg-yellow-400 text-black rounded-lg text-sm font-medium hover:bg-yellow-500 transition-colors">
                    Post
                </button>
            </div>

            <!-- Comments List -->
            <div class="space-y-4">
                <?php $__currentLoopData = $job->comments ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-start space-x-3">
                        <div class="flex-shrink-0">
                            <?php if($comment->user->avatar): ?>
                                <img src="<?php echo e(Storage::url($comment->user->avatar)); ?>" 
                                     alt="<?php echo e($comment->user->name); ?>"
                                     class="w-8 h-8 rounded-full">
                            <?php else: ?>
                                <div class="w-8 h-8 rounded-full bg-gray-200 flex items-center justify-center">
                                    <span class="text-sm font-medium text-gray-600">
                                        <?php echo e(substr($comment->user->name, 0, 1)); ?>

                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="flex-grow">
                            <div class="bg-gray-50 rounded-2xl px-4 py-2">
                                <div class="font-medium text-gray-900"><?php echo e($comment->user->name); ?></div>
                                <p class="text-gray-600 text-sm"><?php echo e($comment->content); ?></p>
                            </div>
                            <div class="flex items-center space-x-4 mt-1 text-xs text-gray-500">
                                <button type="button" class="hover:text-yellow-600 transition-colors">Like</button>
                                <button type="button" class="hover:text-yellow-600 transition-colors">Reply</button>
                                <span><?php echo e($comment->created_at->diffForHumans()); ?></span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function likeJob(jobId) {
    // Implementation for liking a job
    fetch(`/api/jobs/${jobId}/like`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        // Update the like count in the UI
        const likeButton = event.currentTarget;
        const likeCount = likeButton.querySelector('span');
        likeCount.textContent = data.likes_count;
        
        // Add visual feedback
        likeButton.querySelector('svg').classList.add('text-red-500', 'fill-current');
        setTimeout(() => {
            likeButton.querySelector('svg').classList.remove('text-red-500', 'fill-current');
        }, 200);
    });
}

function showComments(jobId) {
    const commentsSection = document.getElementById(`comments-${jobId}`);
    if (commentsSection.classList.contains('hidden')) {
        commentsSection.classList.remove('hidden');
        // Load comments if not already loaded
        loadComments(jobId);
    } else {
        commentsSection.classList.add('hidden');
    }
}

function loadComments(jobId) {
    // Implementation for loading comments
    fetch(`/api/jobs/${jobId}/comments`)
        .then(response => response.json())
        .then(data => {
            // Update the comments section with the loaded comments
            // Implementation details here
        });
}

function shareJob(jobId) {
    // Implementation for sharing a job
    if (navigator.share) {
        fetch(`/api/jobs/${jobId}`)
            .then(response => response.json())
            .then(job => {
                navigator.share({
                    title: job.title,
                    text: `Check out this job at ${job.organization.name}: ${job.title}`,
                    url: window.location.origin + `/jobs/${job.id}`
                });
            });
    } else {
        // Fallback for browsers that don't support Web Share API
        const shareUrl = `${window.location.origin}/jobs/${jobId}`;
        // Show a modal or tooltip with sharing options
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\xampp\htdocs\www\github\hiringcameroon\resources\views/components/job-card.blade.php ENDPATH**/ ?>