

<?php $__env->startSection('title', 'Pricing – HireCameroon'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-brand-navy via-slate-800 to-brand-navy text-white py-20 relative overflow-hidden">
        <!-- Background Image -->
        <div class="absolute inset-0 bg-cover bg-center bg-no-repeat" style="background-image: url('/assets/images/pricing-hero.jpg');"></div>
        <div class="absolute inset-0 bg-black/40"></div>
        <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.05"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-20"></div>
        <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h1 class="text-5xl md:text-6xl font-bold mb-6">
                Simple, Transparent <span class="bg-gradient-to-r from-black to-yellow bg-clip-text text-transparent">Pricing</span>
            </h1>
            <p class="text-xl text-slate-300 max-w-3xl mx-auto leading-relaxed">
                Start free and scale as you grow. No hidden fees, no surprises. Just powerful tools to help you hire better.
            </p>
        </div>
    </section>

    <!-- Pricing Toggle -->
    <section class="py-8 bg-white border-b border-gray-100">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-center">
                <div class="bg-gray-100 p-1 rounded-lg flex items-center">
                    <button id="monthly-toggle" class="px-6 py-2 rounded-md text-sm font-medium transition bg-white text-brand-navy shadow-sm">Monthly</button>
                    <button id="yearly-toggle" class="px-6 py-2 rounded-md text-sm font-medium transition text-slate-600 hover:text-brand-navy active-toggle">Yearly</button>
                    <div class="ml-3 bg-green-600 text-white px-2 py-1 rounded text-xs font-bold">Save 20%</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Advertising Pricing Section -->
    <section class="py-20 bg-gradient-to-br from-blue-50 to-indigo-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl font-bold text-slate-900 mb-4">Advertising Plans</h2>
                <p class="text-xl text-slate-600 max-w-3xl mx-auto">
                    Reach qualified job seekers and grow your business with targeted advertising on HireCameroon. Bonus: Ads also run in our WhatsApp channels!
                </p>
            </div>
            <div class="grid md:grid-cols-4 gap-6">
                <!-- 2 Days Plan -->
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-gray-200">
                    <div class="p-6">
                        <div class="w-12 h-12 bg-blue-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2">2 Days</h3>
                        <div class="mb-4">
                            <span class="text-3xl font-bold text-slate-900">3,000</span>
                            <span class="text-slate-500">XAF</span>
                        </div>
                        <a href="<?php echo e(route('login')); ?>" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition text-sm inline-block text-center">
                            Start Advertising
                        </a>
                    </div>
                </div>

                <!-- 3 Days Plan -->
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-gray-200">
                    <div class="p-6">
                        <div class="w-12 h-12 bg-green-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2">3 Days</h3>
                        <div class="mb-4">
                            <span class="text-3xl font-bold text-slate-900">4,500</span>
                            <span class="text-slate-500">XAF</span>
                        </div>
                        <a href="<?php echo e(route('login')); ?>" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition text-sm inline-block text-center shadow-md">
                            Start Advertising
                        </a>
                    </div>
                </div>

                <!-- 5 Days Plan -->
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-gray-200">
                    <div class="p-6">
                        <div class="w-12 h-12 bg-yellow-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2">5 Days</h3>
                        <div class="mb-4">
                            <span class="text-3xl font-bold text-slate-900">5,500</span>
                            <span class="text-slate-500">XAF</span>
                        </div>
                        <a href="<?php echo e(route('login')); ?>" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition text-sm inline-block text-center shadow-md">
                            Start Advertising
                        </a>
                    </div>
                </div>

                <!-- 1 Week Plan -->
                <div class="bg-white rounded-2xl shadow-2xl hover:shadow-3xl transition-all duration-300 hover:-translate-y-4 border-2 border-blue-500 relative">
                    <div class="absolute -top-3 left-1/2 transform -translate-x-1/2">
                        <span class="bg-blue-500 text-white px-3 py-1 rounded-full text-xs font-bold">Popular</span>
                    </div>
                    <div class="p-6">
                        <div class="w-12 h-12 bg-blue-500/10 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2">1 Week</h3>
                        <div class="mb-4">
                            <span class="text-3xl font-bold text-slate-900">7,500</span>
                            <span class="text-slate-500">XAF</span>
                        </div>
                        <a href="<?php echo e(route('login')); ?>" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition text-sm inline-block text-center shadow-md">
                            Start Advertising
                        </a>
                    </div>
                </div>

                <!-- 2 Weeks Plan -->
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-gray-200">
                    <div class="p-6">
                        <div class="w-12 h-12 bg-purple-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2">2 Weeks</h3>
                        <div class="mb-4">
                            <span class="text-3xl font-bold text-slate-900">14,000</span>
                            <span class="text-slate-500">XAF</span>
                        </div>
                        <a href="<?php echo e(route('login')); ?>" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition text-sm inline-block text-center shadow-md">
                            Start Advertising
                        </a>
                    </div>
                </div>

                <!-- 3 Weeks Plan -->
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-gray-200">
                    <div class="p-6">
                        <div class="w-12 h-12 bg-pink-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-pink-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2">3 Weeks</h3>
                        <div class="mb-4">
                            <span class="text-3xl font-bold text-slate-900">22,000</span>
                            <span class="text-slate-500">XAF</span>
                        </div>
                        <a href="<?php echo e(route('login')); ?>" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition text-sm inline-block text-center shadow-md">
                            Start Advertising
                        </a>
                    </div>
                </div>

                <!-- 1 Month Plan -->
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-gray-200">
                    <div class="p-6">
                        <div class="w-12 h-12 bg-indigo-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2">1 Month</h3>
                        <div class="mb-4">
                            <span class="text-3xl font-bold text-slate-900">27,000</span>
                            <span class="text-slate-500">XAF</span>
                        </div>
                        <a href="<?php echo e(route('login')); ?>" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition text-sm inline-block text-center shadow-md">
                            Start Advertising
                        </a>
                    </div>
                </div>

                <!-- 2 Months Plan -->
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-gray-200">
                    <div class="p-6">
                        <div class="w-12 h-12 bg-red-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-6 h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2">2 Months</h3>
                        <div class="mb-4">
                            <span class="text-3xl font-bold text-slate-900">50,000</span>
                            <span class="text-slate-500">XAF</span>
                        </div>
                        <a href="<?php echo e(route('login')); ?>" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition text-sm inline-block text-center shadow-md">
                            Start Advertising
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing Cards -->
    <section class="py-20 bg-gradient-to-br from-slate-50 to-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl font-bold text-slate-900 mb-4">Subscription Plans</h2>
                <p class="text-xl text-slate-600 max-w-3xl mx-auto">
                    Choose the perfect plan for your hiring needs
                </p>
            </div>
            <div class="grid md:grid-cols-3 gap-8">
                <!-- Free Plan -->
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-gray-200">
                    <div class="p-8">
                        <div class="w-12 h-12 bg-gray-100 rounded-xl flex items-center justify-center mb-6">
                            <svg class="w-6 h-6 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                            </svg>
                        </div>
                        <h3 class="text-2xl font-bold text-slate-900 mb-2">Starter</h3>
                        <p class="text-slate-600 mb-6">Perfect for small businesses getting started with online hiring.</p>
                        <div class="mb-6">
                            <span class="text-4xl font-bold text-slate-900">Free</span>
                            <span class="text-slate-500">/forever</span>
                        </div>
                        <ul class="space-y-4 mb-8">
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Up to 3 job posts</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Basic candidate tracking</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Email notifications</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Mobile-friendly interface</span>
                            </li>
                        </ul>
                        <a href="<?php echo e(route('register')); ?>" class="w-full bg-gray-900 hover:bg-gray-800 text-white font-semibold py-3 px-6 rounded-lg transition inline-block text-center">
                            Get Started Free
                        </a>
                    </div>
                </div>

                <!-- Pro Plan -->
                <div class="bg-white rounded-2xl shadow-2xl hover:shadow-3xl transition-all duration-300 hover:-translate-y-4 border-2 border-brand-gold relative">
                    <div class="absolute -top-4 left-1/2 transform -translate-x-1/2">
                        <span class="bg-brand-gold text-white px-4 py-2 rounded-full text-sm font-bold">Most Popular</span>
                    </div>
                    <div class="p-8">
                        <div class="w-12 h-12 bg-brand-gold/10 rounded-xl flex items-center justify-center mb-6">
                            <svg class="w-6 h-6 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                            </svg>
                        </div>
                        <h3 class="text-2xl font-bold text-slate-900 mb-2">Professional</h3>
                        <p class="text-slate-600 mb-6">For growing companies that need advanced hiring tools and priority support.</p>
                        <div class="mb-6">
                            <span id="monthly-price" class="text-4xl font-bold text-slate-900 hidden">25,000</span>
                            <span id="yearly-price" class="text-4xl font-bold text-slate-900">240,000</span>
                            <span class="text-slate-500">XAF/year</span>
                            <div class="text-sm text-slate-600">Save 20% with annual billing</div>
                        </div>
                        <ul class="space-y-4 mb-8">
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Unlimited job posts</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Advanced ATS pipeline</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">5 featured job listings/month</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Priority customer support</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Analytics & reporting</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Custom branding options</span>
                            </li>
                        </ul>
                        <a href="<?php echo e(route('login')); ?>" class="w-full bg-brand-gold hover:bg-brand-gold/90 text-white font-semibold py-3 px-6 rounded-lg transition shadow-lg hover:shadow-xl inline-block text-center">
                            <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.1 5H19M7 13l-1.1-5m1.1 5l1.1 5M9 21h6m-3-3v3"/>
                            </svg>
                            Subscribe with Mesomb
                        </a>
                    </div>
                </div>

                <!-- Enterprise Plan -->
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 hover:-translate-y-2 border border-gray-200">
                    <div class="p-8">
                        <div class="w-12 h-12 bg-brand-navy/10 rounded-xl flex items-center justify-center mb-6">
                            <svg class="w-6 h-6 text-brand-navy" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                            </svg>
                        </div>
                        <h3 class="text-2xl font-bold text-slate-900 mb-2">Enterprise</h3>
                        <p class="text-slate-600 mb-6">For large organizations with complex hiring needs and dedicated support.</p>
                        <div class="mb-6">
                            <span class="text-4xl font-bold text-slate-900">Custom</span>
                            <div class="text-sm text-slate-600">Contact us for pricing</div>
                        </div>
                        <ul class="space-y-4 mb-8">
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Everything in Professional</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Dedicated account manager</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Custom integrations</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">Advanced analytics</span>
                            </li>
                            <li class="flex items-center">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                                </svg>
                                <span class="text-slate-700">SLA guarantees</span>
                            </li>
                        </ul>
                        <a href="/contact" class="w-full bg-brand-navy hover:bg-brand-navy/90 text-white font-semibold py-3 px-6 rounded-lg transition inline-block text-center">
                            Contact Sales
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="py-20 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl font-bold text-brand-navy mb-4">Frequently Asked Questions</h2>
                <p class="text-slate-600">Everything you need to know about our pricing and plans</p>
            </div>
            <div class="space-y-6">
                <div class="bg-gray-50 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-brand-navy mb-3">Can I change plans at any time?</h3>
                    <p class="text-slate-600">Yes, you can upgrade or downgrade your plan at any time. Changes take effect immediately, and we'll prorate any charges.</p>
                </div>
                <div class="bg-gray-50 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-brand-navy mb-3">What payment methods do you accept?</h3>
                    <p class="text-slate-600">We accept all major mobile money providers in Cameroon (MTN, Orange, etc.) through our Mesomb integration, as well as bank transfers.</p>
                </div>
                <div class="bg-gray-50 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-brand-navy mb-3">Is there a free trial for paid plans?</h3>
                    <p class="text-slate-600">Our Professional plan includes a 14-day free trial. You can explore all features before committing to a subscription.</p>
                </div>
                <div class="bg-gray-50 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-brand-navy mb-3">What happens if I exceed my job post limit?</h3>
                    <p class="text-slate-600">You'll receive a notification when approaching your limit. You can upgrade your plan or purchase additional job posts as needed.</p>
                </div>
                <div class="bg-gray-50 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-brand-navy mb-3">How does advertising pricing work?</h3>
                    <p class="text-slate-600">Advertising is priced per campaign duration. Plans range from 3,000 XAF for 2 days up to 50,000 XAF for 2 months. All plans include banner placement on our platform and WhatsApp channels, with targeting options and performance analytics.</p>
                </div>
                <div class="bg-gray-50 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-brand-navy mb-3">Can I target specific audiences with my ads?</h3>
                    <p class="text-slate-600">Yes! Our advertising platform allows targeting by user roles, locations, company sizes, and job categories to ensure your ads reach the most relevant audience.</p>
                </div>
                <div class="bg-gray-50 rounded-xl p-6">
                    <h3 class="text-lg font-semibold text-brand-navy mb-3">Do you offer refunds for advertising campaigns?</h3>
                    <p class="text-slate-600">We offer refunds within 24 hours of campaign activation if the ad hasn't started running. Once the campaign begins, refunds are processed on a prorated basis.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-20 bg-gradient-to-r from-brand-navy via-slate-800 to-brand-navy relative overflow-hidden">
        <div class="absolute inset-0 bg-black/20"></div>
        <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.03"%3E%3Ccircle cx="30" cy="30" r="2"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-30"></div>
        <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-4xl font-bold text-white mb-6">Ready to Transform Your Hiring?</h2>
            <p class="text-xl text-slate-300 mb-8 max-w-2xl mx-auto">
                Join thousands of Cameroonian companies already using HireCameroon to find top talent and streamline their recruitment process.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo e(route('register')); ?>" class="inline-flex items-center px-8 py-4 bg-black text-white hover:bg-gray-800 font-bold text-lg rounded-xl transition shadow-2xl hover:shadow-3xl transform hover:-translate-y-1">
                    <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                    Start Free Today
                </a>
                <a href="/contact" class="inline-flex items-center px-8 py-4 bg-white/10 backdrop-blur-sm border border-white/20 text-white font-semibold text-lg rounded-xl hover:bg-white/20 transition">
                    <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                    </svg>
                    Talk to Sales
                </a>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const monthlyToggle = document.getElementById('monthly-toggle');
    const yearlyToggle = document.getElementById('yearly-toggle');
    const monthlyPrice = document.getElementById('monthly-price');
    const yearlyPrice = document.getElementById('yearly-price');

    function updatePricing(isYearly) {
        if (isYearly) {
            monthlyToggle.classList.remove('bg-white', 'text-brand-navy', 'shadow-sm');
            monthlyToggle.classList.add('text-slate-600', 'hover:text-brand-navy');
            yearlyToggle.classList.add('bg-white', 'text-brand-navy', 'shadow-sm');
            yearlyToggle.classList.remove('text-slate-600', 'hover:text-brand-navy');

            monthlyPrice.classList.add('hidden');
            yearlyPrice.classList.remove('hidden');
        } else {
            yearlyToggle.classList.remove('bg-white', 'text-brand-navy', 'shadow-sm');
            yearlyToggle.classList.add('text-slate-600', 'hover:text-brand-navy');
            monthlyToggle.classList.add('bg-white', 'text-brand-navy', 'shadow-sm');
            monthlyToggle.classList.remove('text-slate-600', 'hover:text-brand-navy');

            yearlyPrice.classList.add('hidden');
            monthlyPrice.classList.remove('hidden');
        }
    }

    monthlyToggle.addEventListener('click', function() {
        updatePricing(false);
    });

    yearlyToggle.addEventListener('click', function() {
        updatePricing(true);
    });

    // Set yearly as default active
    updatePricing(true);
});
</script>

<?php echo $__env->make('layouts.marketing', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\www\github\hiringcameroon\resources\views/marketing/pricing.blade.php ENDPATH**/ ?>