<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', 'HireCameroon – Find work. Hire faster.'); ?></title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/brand/logo.png')); ?>">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <!-- Custom Styles -->
    <style>
        @keyframes slideIn {
            0% { transform: translateX(-100%) translateY(-50%); }
            100% { transform: translateX(0) translateY(-50%); }
        }
        @keyframes pulse {
            0% { transform: translateY(-50%) scale(1); }
            50% { transform: translateY(-50%) scale(1.05); }
            100% { transform: translateY(-50%) scale(1); }
        }
        .floating-ad-button {
            animation: slideIn 0.5s ease-out forwards, pulse 2s ease-in-out 1s 1;
        }
        @media (max-width: 640px) {
            .floating-ad-button {
                padding: 0.75rem !important;
            }
            .floating-ad-button span {
                display: none;
            }
            .floating-ad-button:hover {
                padding: 0.75rem !important;
            }
        }
    </style>
</head>
<body class="antialiased">
    <!-- Floating Ads Button with proper z-index management -->
    <div class="fixed left-0 top-1/2 -translate-y-1/2 z-50 group" style="margin-left: 0;">
        <button onclick="window.location.href='/ads/create'"
           class="floating-ad-button flex items-center bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white px-4 py-3 rounded-r-lg shadow-xl transition-all duration-300 hover:px-6 relative hover:shadow-2xl">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5.882V19.24a1.76 1.76 0 01-3.417.592l-2.147-6.15M18 13a3 3 0 100-6M5.436 13.683A4.001 4.001 0 017 6h1.832c4.1 0 7.625-1.234 9.168-3v14c-1.543-1.766-5.067-3-9.168-3H7a3.988 3.988 0 01-1.564-.317z" />
            </svg>
            <span class="font-semibold">Post an Ad</span>
            
            <!-- Tooltip -->
            <div class="hidden group-hover:block absolute left-full ml-2 px-3 py-2 bg-gray-800 text-white text-sm rounded whitespace-nowrap shadow-lg z-[60]">
                <div class="absolute left-0 top-1/2 transform -translate-x-1/2 -translate-y-1/2">
                    <div class="border-8 border-transparent border-r-gray-800"></div>
                </div>
                Boost your visibility! Create an advertisement
            </div>
        </button>
    </div>

    <!-- Navigation -->
    <nav class="bg-white shadow-sm border-b border-gray-200">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex">
                    <!-- Logo -->
                    <div class="shrink-0 flex items-center">
                        <a href="<?php echo e(url('/')); ?>" class="flex items-center">
                            <img src="<?php echo e(asset('assets/brand/logo.png')); ?>" alt="HireCameroon" class="h-8 w-auto">
                            <span class="ml-2 text-xl font-bold text-gray-900">HireCameroon</span>
                        </a>
                    </div>

                    <!-- Navigation Links -->
                    <div class="hidden space-x-8 sm:-my-px sm:ml-10 sm:flex">
                        <a href="<?php echo e(url('/')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium <?php echo e(request()->routeIs('welcome') ? 'border-indigo-400 text-gray-900' : ''); ?>">
                            Home
                        </a>
                        <a href="<?php echo e(route('jobs.index')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium <?php echo e(request()->routeIs('jobs.*') ? 'border-indigo-400 text-gray-900' : ''); ?>">
                            Jobs
                        </a>
                        <a href="<?php echo e(route('companies.index')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium <?php echo e(request()->routeIs('companies.*') ? 'border-indigo-400 text-gray-900' : ''); ?>">
                            Companies
                        </a>
                        <a href="<?php echo e(route('pricing')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium <?php echo e(request()->routeIs('pricing') ? 'border-indigo-400 text-gray-900' : ''); ?>">
                            Pricing
                        </a>
                        <a href="<?php echo e(route('news')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium <?php echo e(request()->routeIs('news') ? 'border-indigo-400 text-gray-900' : ''); ?>">
                            News & FAQ
                        </a>
                        <a href="<?php echo e(route('about')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium <?php echo e(request()->routeIs('about') ? 'border-indigo-400 text-gray-900' : ''); ?>">
                            About
                        </a>
                        <a href="<?php echo e(route('contact')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium <?php echo e(request()->routeIs('contact') ? 'border-indigo-400 text-gray-900' : ''); ?>">
                            Contact
                        </a>
                        <a href="<?php echo e(route('donate')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 inline-flex items-center px-1 pt-1 border-b-2 text-sm font-medium">
                            Support Us
                        </a>
                    </div>
                </div>

                <!-- Right Side -->
                <div class="hidden sm:flex sm:items-center sm:ml-6">
                    <?php if(auth()->guard()->guest()): ?>
                        <div class="flex items-center space-x-4">
                            <a href="<?php echo e(route('login')); ?>" class="text-gray-500 hover:text-gray-700 text-sm font-medium">Log in</a>
                            <a href="<?php echo e(route('register')); ?>" class="bg-gradient-to-r from-yellow-400 to-yellow-500 hover:from-yellow-500 hover:to-yellow-600 text-black px-6 py-3 rounded-lg text-sm font-bold transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">Get Started Free</a>
                        </div>
                    <?php else: ?>
                        <div class="flex items-center space-x-4">
                            <a href="<?php echo e(route('dashboard')); ?>" class="text-gray-500 hover:text-gray-700 text-sm font-medium">Dashboard</a>
                            <form method="POST" action="<?php echo e(route('logout')); ?>" class="inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="text-gray-500 hover:text-gray-700 text-sm font-medium">Log out</button>
                            </form>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Mobile menu button -->
                <div class="-mr-2 flex items-center sm:hidden">
                    <button type="button" onclick="toggleMobileMenu()" class="bg-white inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-indigo-500" aria-expanded="false">
                        <span class="sr-only">Open main menu</span>
                        <svg class="block h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile menu -->
        <div id="mobile-menu" class="hidden sm:hidden">
            <div class="pt-2 pb-3 space-y-1">
                <a href="<?php echo e(url('/')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 block pl-3 pr-4 py-2 border-l-4 text-base font-medium <?php echo e(request()->routeIs('welcome') ? 'border-indigo-400 text-gray-900 bg-indigo-50' : ''); ?>">Home</a>
                <a href="<?php echo e(route('jobs.index')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 block pl-3 pr-4 py-2 border-l-4 text-base font-medium <?php echo e(request()->routeIs('jobs.*') ? 'border-indigo-400 text-gray-900 bg-indigo-50' : ''); ?>">Jobs</a>
                <a href="<?php echo e(route('companies.index')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 block pl-3 pr-4 py-2 border-l-4 text-base font-medium <?php echo e(request()->routeIs('companies.*') ? 'border-indigo-400 text-gray-900 bg-indigo-50' : ''); ?>">Companies</a>
                <a href="<?php echo e(route('pricing')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 block pl-3 pr-4 py-2 border-l-4 text-base font-medium <?php echo e(request()->routeIs('pricing') ? 'border-indigo-400 text-gray-900 bg-indigo-50' : ''); ?>">Pricing</a>
                <a href="<?php echo e(route('news')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 block pl-3 pr-4 py-2 border-l-4 text-base font-medium <?php echo e(request()->routeIs('news') ? 'border-indigo-400 text-gray-900 bg-indigo-50' : ''); ?>">News & FAQ</a>
                <a href="<?php echo e(route('about')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 block pl-3 pr-4 py-2 border-l-4 text-base font-medium <?php echo e(request()->routeIs('about') ? 'border-indigo-400 text-gray-900 bg-indigo-50' : ''); ?>">About</a>
                <a href="<?php echo e(route('contact')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 block pl-3 pr-4 py-2 border-l-4 text-base font-medium <?php echo e(request()->routeIs('contact') ? 'border-indigo-400 text-gray-900 bg-indigo-50' : ''); ?>">Contact</a>
                <a href="<?php echo e(route('donate')); ?>" class="border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 block pl-3 pr-4 py-2 border-l-4 text-base font-medium">Support Us</a>
            </div>
            <div class="pt-4 pb-1 border-t border-gray-200">
                <?php if(auth()->guard()->guest()): ?>
                    <div class="flex items-center px-4">
                        <div class="flex-shrink-0">
                            <svg class="h-10 w-10 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <div class="text-base font-medium text-gray-800">Guest</div>
                            <div class="text-sm font-medium text-gray-500">
                                <a href="<?php echo e(route('login')); ?>" class="text-indigo-600 hover:text-indigo-500">Log in</a>
                                <span class="text-gray-300">|</span>
                                <a href="<?php echo e(route('register')); ?>" class="text-yellow-600 hover:text-yellow-700 font-semibold">Register</a>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="flex items-center px-4">
                        <div class="flex-shrink-0">
                            <svg class="h-10 w-10 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <div class="text-base font-medium text-gray-800"><?php echo e(Auth::user()->name); ?></div>
                            <div class="text-sm font-medium text-gray-500">
                                <a href="<?php echo e(route('dashboard')); ?>" class="text-indigo-600 hover:text-indigo-500">Dashboard</a>
                                <span class="text-gray-300">|</span>
                                <form method="POST" action="<?php echo e(route('logout')); ?>" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="text-indigo-600 hover:text-indigo-500">Log out</button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <!-- Page Content -->
    <main>
        <?php if (! empty(trim($__env->yieldContent('content')))): ?>
            <?php echo $__env->yieldContent('content'); ?>
        <?php else: ?>
            <?php echo e($slot ?? ''); ?>

        <?php endif; ?>
    </main>

    <!-- Footer with Black Background -->
    <footer class="bg-black border-t border-gray-800">
        <div class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:py-16 lg:px-8">
            <div class="xl:grid xl:grid-cols-3 xl:gap-8">
                <!-- Company info -->
                <div class="space-y-8 xl:col-span-1">
                    <div class="flex items-center">
                        <img src="<?php echo e(asset('assets/brand/logo.png')); ?>" alt="HireCameroon" class="h-8 w-auto">
                        <span class="ml-2 text-xl font-bold text-white">HireCameroon</span>
                    </div>
                    <p class="text-gray-300 text-base">
                        Connecting Cameroonian talent with opportunities. Bilingual job platform for Douala, Yaoundé, and beyond.
                    </p>
                    <div class="flex space-x-6">
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">
                            <span class="sr-only">Facebook</span>
                            <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
                                <path fill-rule="evenodd" d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z" clip-rule="evenodd" />
                            </svg>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">
                            <span class="sr-only">Twitter</span>
                            <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 010 18.407a11.616 11.616 0 006.29 1.84" />
                            </svg>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">
                            <span class="sr-only">LinkedIn</span>
                            <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
                                <path fill-rule="evenodd" d="M16.338 16.338H13.67V12.16c0-.995-.017-2.277-1.387-2.277-1.39 0-1.601 1.086-1.601 2.207v4.248H8.014v-8.59h2.559v1.174h.037c.356-.675 1.227-1.387 2.526-1.387 2.703 0 3.203 1.778 3.203 4.092v4.711zM5.005 6.575a1.548 1.548 0 11-.003-3.096 1.548 1.548 0 01.003 3.096zm-1.337 9.763H6.34v-8.59H3.667v8.59zM17.668 1H2.328C1.595 1 1 1.581 1 2.298v15.403C1 18.418 1.595 19 2.328 19h15.34c.734 0 1.332-.582 1.332-1.299V2.298C19 1.581 18.402 1 17.668 1z" clip-rule="evenodd" />
                            </svg>
                        </a>
                    </div>
                </div>

                <!-- Links -->
                <div class="mt-12 grid grid-cols-2 gap-8 xl:mt-0 xl:col-span-2">
                    <div class="md:grid md:grid-cols-2 md:gap-8">
                        <div>
                            <h3 class="text-sm font-semibold text-gray-400 tracking-wider uppercase">For Job Seekers</h3>
                            <ul class="mt-4 space-y-4">
                                <li><a href="<?php echo e(route('jobs.index')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Browse Jobs</a></li>
                                <li><a href="<?php echo e(route('register')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Create Account</a></li>
                                <li><a href="<?php echo e(route('about')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">How It Works</a></li>
                                <li><a href="<?php echo e(route('news')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Career Tips</a></li>
                            </ul>
                        </div>
                        <div class="mt-12 md:mt-0">
                            <h3 class="text-sm font-semibold text-gray-400 tracking-wider uppercase">For Employers</h3>
                            <ul class="mt-4 space-y-4">
                                <li><a href="<?php echo e(route('register')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Post a Job</a></li>
                                <li><a href="<?php echo e(route('pricing')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Pricing</a></li>
                                <li><a href="<?php echo e(route('about')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Employer Guide</a></li>
                                <li><a href="<?php echo e(route('contact')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Support</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="md:grid md:grid-cols-2 md:gap-8">
                        <div>
                            <h3 class="text-sm font-semibold text-gray-400 tracking-wider uppercase">Company</h3>
                            <ul class="mt-4 space-y-4">
                                <li><a href="<?php echo e(route('about')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">About Us</a></li>
                                <li><a href="<?php echo e(route('news')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">News</a></li>
                                <li><a href="<?php echo e(route('contact')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Contact</a></li>
                                <li><a href="#careers" class="text-base text-gray-300 hover:text-white transition-colors">Careers</a></li>
                            </ul>
                        </div>
                        <div class="mt-12 md:mt-0">
                            <h3 class="text-sm font-semibold text-gray-400 tracking-wider uppercase">Legal</h3>
                            <ul class="mt-4 space-y-4">
                                <li><a href="<?php echo e(route('privacy')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Privacy Policy</a></li>
                                <li><a href="<?php echo e(route('faq')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Terms of Service</a></li>
                                <li><a href="<?php echo e(route('contact')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Cookie Policy</a></li>
                                <li><a href="<?php echo e(route('donate')); ?>" class="text-base text-gray-300 hover:text-white transition-colors">Support Us</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-12 border-t border-gray-800 pt-8">
                <p class="text-base text-gray-400 xl:text-center">
                    &copy; <?php echo e(date('Y')); ?> HireCameroon. All rights reserved.
                </p>
            </div>
        </div>
    </footer>
</body>
    <script>
        function toggleMobileMenu() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        }
    </script>
</body>
</html>
</html><?php /**PATH C:\xampp\htdocs\www\github\hiringcameroon\resources\views/layouts/marketing.blade.php ENDPATH**/ ?>