<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['user' => null, 'size' => 'md', 'showTooltip' => false, 'id' => null]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['user' => null, 'size' => 'md', 'showTooltip' => false, 'id' => null]); ?>
<?php foreach (array_filter((['user' => null, 'size' => 'md', 'showTooltip' => false, 'id' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php
    $sizes = [
        'xs' => 'w-6 h-6 text-xs',
        'sm' => 'w-8 h-8 text-sm', 
        'md' => 'w-10 h-10 text-sm',
        'lg' => 'w-16 h-16 text-lg',
        'xl' => 'w-20 h-20 text-xl',
        '2xl' => 'w-32 h-32 text-2xl',
    ];
    
    $sizeClass = $sizes[$size] ?? $sizes['md'];
?>

<div class="relative inline-flex items-center justify-center <?php echo e($sizeClass); ?> bg-gray-200 rounded-full overflow-hidden group"
     <?php if($showTooltip): ?> title="<?php echo e($user?->name ?? 'User'); ?>" <?php endif; ?>
     <?php if($id): ?> id="<?php echo e($id); ?>" <?php endif; ?>>
    
    <div class="w-full h-full flex items-center justify-center font-semibold text-white"
         style="background-color: <?php echo e($user?->avatar_color ?? '#6B7280'); ?>">
        <?php echo e(strtoupper($user?->initials ?? 'U')); ?>

    </div>
    
    <?php if($showTooltip): ?>
        <div class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-3 py-2 bg-gray-900 text-white text-sm rounded-lg opacity-0 group-hover:opacity-100 transition-opacity duration-200 pointer-events-none whitespace-nowrap z-50">
            <?php echo e($user?->name ?? 'User'); ?>

            <div class="absolute top-full left-1/2 transform -translate-x-1/2 border-4 border-transparent border-t-gray-900"></div>
        </div>
    <?php endif; ?>
</div><?php /**PATH C:\xampp\htdocs\www\github\hiringcameroon\resources\views/components/profile-avatar.blade.php ENDPATH**/ ?>