<?php $__env->startSection('title', 'HireCameroon – Find work. Hire faster.'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Simple Hero Section with Stock Slideshow -->
    <section class="relative bg-black text-white overflow-hidden min-h-[65vh]">
        <!-- Full-Screen Stock Image Slideshow -->
            <div class="absolute inset-0">
            <!-- Slideshow Container -->
            <div class="slideshow-container relative w-full h-full">
                <!-- Slide 1: Modern Office -->
                <div class="slide active absolute inset-0 bg-cover bg-center transition-opacity duration-1000" style="background-image: url('https://images.unsplash.com/photo-1497366216548-37526070297c?w=1920&h=1080&fit=crop&crop=center');">
                    <div class="absolute inset-0 bg-black/70"></div>
                </div>

                <!-- Slide 2: Team Collaboration -->
                <div class="slide absolute inset-0 bg-cover bg-center transition-opacity duration-1000 opacity-0" style="background-image: url('https://images.unsplash.com/photo-1522071820081-009f0129c71c?w=1920&h=1080&fit=crop&crop=center');">
                    <div class="absolute inset-0 bg-black/70"></div>
                </div>

                <!-- Slide 3: Professional Meeting -->
                <div class="slide absolute inset-0 bg-cover bg-center transition-opacity duration-1000 opacity-0" style="background-image: url('https://images.unsplash.com/photo-1552664730-d307ca884978?w=1920&h=1080&fit=crop&crop=center');">
                    <div class="absolute inset-0 bg-black/70"></div>
                </div>

                <!-- Slide 4: Tech Workspace -->
                <div class="slide absolute inset-0 bg-cover bg-center transition-opacity duration-1000 opacity-0" style="background-image: url('https://images.unsplash.com/photo-1553877522-43269d4ea984?w=1920&h=1080&fit=crop&crop=center');">
                    <div class="absolute inset-0 bg-black/70"></div>
                </div>
            </div>
        </div>

        <!-- Content Container - Centered -->
        <div class="relative min-h-[65vh] flex items-center justify-center px-4 sm:px-6 lg:px-8" style="z-index: 10;">
            <div class="max-w-4xl mx-auto text-center">
                <!-- Main Headline -->
                <div class="space-y-6 mb-12">
                    <h1 class="text-5xl md:text-6xl lg:text-7xl font-black leading-tight">
                        Find Your Next
                        <span class="block text-yellow-400">Career Opportunity</span>
                    </h1>
                    <p class="text-xl md:text-2xl text-gray-300 max-w-3xl mx-auto leading-relaxed">
                        Connect with top Cameroonian companies and discover bilingual job opportunities across Douala, Yaoundé, and beyond.
                    </p>
                </div>

                <!-- Centered Search Bar -->
                <div class="max-w-2xl mx-auto mb-12">
                    <form class="bg-white rounded-2xl p-6 shadow-2xl" action="<?php echo e(route('jobs.index')); ?>" method="GET">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                            <!-- Job Search -->
                            <div class="md:col-span-2">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Job Title or Keywords</label>
                                <input type="text" name="q" placeholder="e.g. Software Engineer, Marketing..."
                                        class="w-full px-4 py-3 rounded-xl border border-gray-300 text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:border-transparent transition-all">
                            </div>

                            <!-- Location -->
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Location</label>
                                <input type="text" name="location" placeholder="Douala, Yaoundé..."
                                        class="w-full px-4 py-3 rounded-xl border border-gray-300 text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:border-transparent transition-all">
                            </div>
                        </div>

                        <!-- Search Button -->
                        <div class="mt-6">
                            <button type="submit" class="w-full px-8 py-4 bg-yellow-400 hover:bg-yellow-500 text-black font-bold rounded-xl transition-all duration-300 shadow-2xl hover:shadow-yellow-400/50 transform hover:scale-105 flex items-center justify-center">
                                <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                </svg>
                                Search Jobs
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Call to Action -->
                <div>
                    <p class="text-gray-400 mb-6">New to HireCameroon? Create your profile in minutes</p>
                    <div class="flex flex-col sm:flex-row gap-4 justify-center">
                        <a href="<?php echo e(route('jobs.index')); ?>" class="px-8 py-4 bg-white text-black font-bold rounded-xl hover:bg-gray-100 transition-all duration-300 shadow-2xl">
                            Browse Jobs
                        </a>
                        <a href="<?php echo e(route('register')); ?>" class="px-8 py-4 border border-white/30 text-white font-semibold rounded-xl hover:bg-white/10 transition-all duration-300">
                            Create Free Account
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Slideshow Navigation Dots - Removed -->

        <!-- JavaScript for Slideshow and Job Interactions -->
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const slides = document.querySelectorAll('.slide');
                const dots = document.querySelectorAll('.slideshow-dot');
                let currentSlide = 0;
                let slideInterval;
    
                function showSlide(index) {
                    // Hide all slides
                    slides.forEach(slide => {
                        slide.classList.remove('active');
                        slide.style.opacity = '0';
                    });
    
                    // Remove active class from all dots
                    dots.forEach(dot => dot.classList.remove('active'));
    
                    // Show current slide
                    slides[index].classList.add('active');
                    slides[index].style.opacity = '1';
                    dots[index].classList.add('active');
    
                    currentSlide = index;
                }
    
                function nextSlide() {
                    currentSlide = (currentSlide + 1) % slides.length;
                    showSlide(currentSlide);
                }
    
                // Auto-play slideshow
                slideInterval = setInterval(nextSlide, 5000);
    
                // Dot navigation
                dots.forEach((dot, index) => {
                    dot.addEventListener('click', () => {
                        clearInterval(slideInterval);
                        showSlide(index);
                        slideInterval = setInterval(nextSlide, 5000);
                    });
                });
    
                // Pause on hover
                const slideshowContainer = document.querySelector('.slideshow-container');
                slideshowContainer.addEventListener('mouseenter', () => {
                    clearInterval(slideInterval);
                });
    
                slideshowContainer.addEventListener('mouseleave', () => {
                    slideInterval = setInterval(nextSlide, 5000);
                });
            });
    
            // Job interaction functions
            function toggleJobOptions(jobId) {
                const options = document.getElementById(`job-options-${jobId}`);
                // Close other open options
                document.querySelectorAll('[id^="job-options-"]').forEach(el => {
                    if (el.id !== `job-options-${jobId}`) {
                        el.classList.add('hidden');
                    }
                });
                options.classList.toggle('hidden');
            }
    
            function reportJob(jobId) {
                if (confirm('Are you sure you want to report this job?')) {
                    fetch(`/api/jobs/${jobId}/report`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify({ reason: 'inappropriate_content' })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            showNotification('Job reported successfully', 'success');
                            document.getElementById(`job-options-${jobId}`).classList.add('hidden');
                        } else {
                            showNotification('Failed to report job', 'error');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        showNotification('Failed to report job', 'error');
                    });
                }
            }
    
            function hideJob(jobId) {
                if (confirm('Are you sure you want to hide this job?')) {
                    // Hide the job card
                    const jobCard = document.querySelector(`[data-job-id="${jobId}"]`);
                    if (jobCard) {
                        jobCard.closest('.bg-white').style.display = 'none';
                    }
                    showNotification('Job hidden from your feed', 'info');
                    document.getElementById(`job-options-${jobId}`).classList.add('hidden');
                }
            }
    
            function likeJob(jobId) {
                <?php if(auth()->guard()->check()): ?>
                    const button = document.querySelector(`.like-btn[data-job-id="${jobId}"]`);
                    const icon = button.querySelector('svg');
                    const likesCount = document.getElementById(`likes-count-${jobId}`);
    
                    fetch(`/api/v1/jobs/${jobId}/like`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            if (data.liked) {
                                icon.classList.add('fill-current', 'text-red-500');
                                if (likesCount) likesCount.textContent = parseInt(likesCount.textContent) + 1;
                            } else {
                                icon.classList.remove('fill-current', 'text-red-500');
                                if (likesCount) likesCount.textContent = Math.max(0, parseInt(likesCount.textContent) - 1);
                            }
                            showNotification(data.liked ? 'Job liked!' : 'Job unliked', 'success');
                        } else {
                            showNotification('Failed to like job', 'error');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        showNotification('Failed to like job', 'error');
                    });
                <?php else: ?>
                    window.location.href = '<?php echo e(route("login")); ?>';
                <?php endif; ?>
            }
    
            function showComments(jobId) {
                const commentsSection = document.getElementById(`comments-${jobId}`);
                const isHidden = commentsSection.classList.contains('hidden');
    
                if (isHidden) {
                    // Load comments if not already loaded
                    loadComments(jobId);
                }
    
                commentsSection.classList.toggle('hidden');
            }
    
            function loadComments(jobId) {
                fetch(`/api/v1/jobs/${jobId}/comments`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            renderComments(jobId, data.data);
                        }
                    })
                    .catch(error => {
                        console.error('Error loading comments:', error);
                    });
            }
    
            function renderComments(jobId, comments) {
                const commentsList = document.getElementById(`comments-list-${jobId}`);
                const commentsCount = document.getElementById(`comments-count-${jobId}`);
    
                if (commentsCount) {
                    commentsCount.textContent = comments.length;
                }
    
                if (comments.length === 0) {
                    commentsList.innerHTML = '<div class="text-center py-4 text-gray-500 text-sm">No comments yet. Be the first to comment!</div>';
                    return;
                }
    
                commentsList.innerHTML = comments.map(comment => `
                    <div class="flex space-x-2">
                        <div class="flex-shrink-0">
                            ${comment.user.avatar ?
                                `<img src="/storage/${comment.user.avatar}" alt="${comment.user.name}" class="w-6 h-6 rounded-full object-cover">` :
                                `<div class="w-6 h-6 bg-gradient-to-br from-gray-400 to-gray-600 rounded-full flex items-center justify-center">
                                    <span class="text-white font-bold text-xs">${comment.user.name.charAt(0)}</span>
                                </div>`
                            }
                        </div>
                        <div class="flex-1">
                            <div class="bg-white rounded-lg px-3 py-2 shadow-sm">
                                <div class="flex items-center space-x-2 mb-1">
                                    <span class="font-semibold text-sm text-gray-900">${comment.user.name}</span>
                                    <span class="text-xs text-gray-500">${new Date(comment.created_at).toLocaleDateString()}</span>
                                </div>
                                <p class="text-sm text-gray-700">${comment.comment}</p>
                                ${comment.replies && comment.replies.length > 0 ? `
                                <div class="mt-2 space-y-1">
                                    ${comment.replies.map(reply => `
                                    <div class="flex space-x-2 ml-4 border-l-2 border-gray-200 pl-3">
                                        <div class="flex-shrink-0">
                                            ${reply.user.avatar ?
                                                `<img src="/storage/${reply.user.avatar}" alt="${reply.user.name}" class="w-5 h-5 rounded-full object-cover">` :
                                                `<div class="w-5 h-5 bg-gradient-to-br from-gray-400 to-gray-600 rounded-full flex items-center justify-center">
                                                    <span class="text-white font-bold text-xs">${reply.user.name.charAt(0)}</span>
                                                </div>`
                                            }
                                        </div>
                                        <div class="flex-1">
                                            <div class="bg-gray-50 rounded px-2 py-1">
                                                <div class="flex items-center space-x-1 mb-1">
                                                    <span class="font-medium text-xs text-gray-900">${reply.user.name}</span>
                                                    <span class="text-xs text-gray-500">${new Date(reply.created_at).toLocaleDateString()}</span>
                                                </div>
                                                <p class="text-xs text-gray-700">${reply.comment}</p>
                                            </div>
                                        </div>
                                    </div>
                                    `).join('')}
                                </div>
                                ` : ''}
                                <div class="mt-1">
                                    <button onclick="showReplyForm(${comment.id}, ${jobId})" class="text-xs text-blue-600 hover:text-blue-800">Reply</button>
                                </div>
                            </div>
                            <div id="reply-form-${comment.id}" class="hidden mt-2 ml-8">
                                ${document.querySelector('[data-auth]') ? `
                                <div class="flex space-x-2">
                                    <input type="text" placeholder="Write a reply..." class="flex-1 px-2 py-1 text-xs border border-gray-300 rounded focus:outline-none focus:ring-1 focus:ring-blue-500" onkeypress="handleReplyKeypress(event, ${comment.id}, ${jobId})">
                                    <button onclick="postReply(${comment.id}, ${jobId})" class="px-3 py-1 bg-blue-600 text-white text-xs rounded hover:bg-blue-700 transition">
                                        Reply
                                    </button>
                                </div>
                                ` : `
                                <div class="text-center py-1">
                                    <a href="/login" class="text-blue-600 hover:text-blue-800 text-xs">Login to reply</a>
                                </div>
                                `}
                            </div>
                        </div>
                    </div>
                `).join('');
            }
    
            function showReplyForm(commentId, jobId) {
                const replyForm = document.getElementById(`reply-form-${commentId}`);
                replyForm.classList.toggle('hidden');
            }
    
            function handleReplyKeypress(event, commentId, jobId) {
                if (event.key === 'Enter') {
                    postReply(commentId, jobId);
                }
            }
    
            function postReply(commentId, jobId) {
                <?php if(auth()->guard()->check()): ?>
                    const input = event.target.closest('.flex').querySelector('input');
                    const reply = input.value.trim();
    
                    if (!reply) return;
    
                    fetch(`/api/v1/jobs/${jobId}/comments`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify({
                            comment: reply,
                            parent_id: commentId
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            input.value = '';
                            // Hide reply form
                            document.getElementById(`reply-form-${commentId}`).classList.add('hidden');
                            // Reload comments
                            loadComments(jobId);
                            showNotification('Reply posted successfully', 'success');
                        } else {
                            showNotification('Failed to post reply', 'error');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        showNotification('Failed to post reply', 'error');
                    });
                <?php else: ?>
                    window.location.href = '<?php echo e(route("login")); ?>';
                <?php endif; ?>
            }
    
            function postComment(jobId) {
                <?php if(auth()->guard()->check()): ?>
                    const input = event.target.closest('.flex-1').querySelector('input');
                    const comment = input.value.trim();
    
                    if (!comment) return;
    
                    fetch(`/api/v1/jobs/${jobId}/comments`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify({ comment: comment })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            input.value = '';
                            // Reload comments
                            loadComments(jobId);
                            showNotification('Comment posted successfully', 'success');
                        } else {
                            showNotification('Failed to post comment', 'error');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        showNotification('Failed to post comment', 'error');
                    });
                <?php else: ?>
                    window.location.href = '<?php echo e(route("login")); ?>';
                <?php endif; ?>
            }
    
            function handleCommentKeypress(event, jobId) {
                if (event.key === 'Enter') {
                    postComment(jobId);
                }
            }
    
            function shareJob(jobId, jobTitle) {
                const url = `${window.location.origin}/jobs/${jobId}`;
    
                if (navigator.share) {
                    navigator.share({
                        title: jobTitle,
                        text: `Check out this job opportunity: ${jobTitle}`,
                        url: url
                    }).catch(() => {
                        // Fallback to clipboard if share fails
                        copyToClipboard(url);
                    });
                } else {
                    // Fallback: copy to clipboard
                    copyToClipboard(url);
                }
            }
    
            function copyToClipboard(text) {
                navigator.clipboard.writeText(text).then(() => {
                    showNotification('Job link copied to clipboard!', 'success');
                }).catch(() => {
                    // Fallback for older browsers
                    const textArea = document.createElement('textarea');
                    textArea.value = text;
                    document.body.appendChild(textArea);
                    textArea.select();
                    document.execCommand('copy');
                    document.body.removeChild(textArea);
                    showNotification('Job link copied to clipboard!', 'success');
                });
            }
    
            function visitCompanyProfile(companyId) {
                if (companyId) {
                    window.location.href = `/companies/${companyId}`;
                }
            }
    
            function quickApply(jobId) {
                <?php if(auth()->guard()->check()): ?>
                    if (confirm('Apply with your existing profile information?')) {
                        fetch(`/api/v1/jobs/${jobId}/apply`, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                            },
                            body: JSON.stringify({
                                cover_letter: 'Applied via quick apply from landing page'
                            })
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                showNotification('Application submitted successfully!', 'success');
                                // Update apply button
                                const button = event.target.closest('button');
                                button.disabled = true;
                                button.innerHTML = `
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                    Applied
                                `;
                                button.classList.remove('bg-gradient-to-r', 'from-blue-600', 'to-blue-700', 'hover:from-blue-700', 'hover:to-blue-800');
                                button.classList.add('bg-green-600', 'hover:bg-green-700');
                            } else {
                                showNotification(data.message || 'Failed to apply', 'error');
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            showNotification('Failed to apply for job', 'error');
                        });
                    }
                <?php else: ?>
                    window.location.href = '<?php echo e(route("login")); ?>';
                <?php endif; ?>
            }
    
            function showNotification(message, type = 'info') {
                // Create notification element
                const notification = document.createElement('div');
                notification.className = `fixed top-4 right-4 z-50 p-4 rounded-lg shadow-lg transform transition-all duration-300 translate-x-full max-w-sm`;
    
                // Set colors based on type
                const colors = {
                    success: 'bg-green-500 text-white',
                    error: 'bg-red-500 text-white',
                    info: 'bg-blue-500 text-white'
                };
    
                notification.classList.add(...colors[type].split(' '));
                notification.innerHTML = `
                    <div class="flex items-center">
                        <div class="flex-1">${message}</div>
                        <button onclick="this.parentElement.parentElement.remove()" class="ml-2 text-white hover:text-gray-200">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </button>
                    </div>
                `;
    
                document.body.appendChild(notification);
    
                // Animate in
                setTimeout(() => {
                    notification.classList.remove('translate-x-full');
                }, 100);
    
                // Auto remove after 5 seconds
                setTimeout(() => {
                    if (document.body.contains(notification)) {
                        notification.classList.add('translate-x-full');
                        setTimeout(() => {
                            if (document.body.contains(notification)) {
                                document.body.removeChild(notification);
                            }
                        }, 300);
                    }
                }, 5000);
            }
    
            // Close dropdowns when clicking outside
            document.addEventListener('click', function(event) {
                if (!event.target.closest('[onclick*="toggleJobOptions"]') && !event.target.closest('[id^="job-options-"]')) {
                    document.querySelectorAll('[id^="job-options-"]').forEach(el => {
                        el.classList.add('hidden');
                    });
                }
            });
        </script>
    </section>
    <!-- News & Announcements Marquee -->
    <section class="bg-black text-white py-6 overflow-hidden relative">
        <!-- TV-style background effect -->
        <div class="absolute inset-0 bg-gradient-to-r from-gray-900 via-black to-gray-900"></div>
        <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="40" height="40" viewBox="0 0 40 40" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23ffffff" fill-opacity="0.02"%3E%3Ccircle cx="20" cy="20" r="1"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-30"></div>

        <!-- Breaking News Banner -->
        <div class="relative">
            <div class="flex items-center justify-center mb-4">
                <div class="bg-red-600 text-white px-4 py-1 rounded text-sm font-bold uppercase tracking-wider animate-pulse">
                    BREAKING NEWS
                </div>
            </div>

            <div class="marquee-container">
                <div class="marquee-content flex items-center space-x-12">
                    <!-- News Items with CLICKABLE headlines -->
                    <a href="/jobs?featured=true" class="flex items-center space-x-3 text-white hover:text-yellow-400 transition-all duration-300 hover:scale-105 group cursor-pointer">
                        <div class="w-8 h-8 bg-yellow-400 rounded-full flex items-center justify-center flex-shrink-0 group-hover:bg-yellow-300 transition-colors">
                            <svg class="w-4 h-4 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/>
                            </svg>
                        </div>
                        <span class="font-semibold text-base">🎉 AI-Powered Job Matching Now Live!</span>
                    </a>

                    <a href="/jobs?location=Douala" class="flex items-center space-x-3 text-white hover:text-yellow-400 transition-all duration-300 hover:scale-105 group cursor-pointer">
                        <div class="w-8 h-8 bg-green-500 rounded-full flex items-center justify-center flex-shrink-0 group-hover:bg-green-400 transition-colors">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                            </svg>
                        </div>
                        <span class="font-semibold text-base">📈 500+ New Jobs in Douala This Week</span>
                    </a>

                    <button onclick="openCVReviewModal()" class="flex items-center space-x-3 text-white hover:text-yellow-400 transition-all duration-300 hover:scale-105 group cursor-pointer">
                        <div class="w-8 h-8 bg-blue-500 rounded-full flex items-center justify-center flex-shrink-0 group-hover:bg-blue-400 transition-colors">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                            </svg>
                        </div>
                        <span class="font-semibold text-base">📚 Free CV Review Workshop - Register Now!</span>
                    </button>

                    <button onclick="openSupportModal()" class="flex items-center space-x-3 text-white hover:text-yellow-400 transition-all duration-300 hover:scale-105 group cursor-pointer">
                        <div class="w-8 h-8 bg-purple-500 rounded-full flex items-center justify-center flex-shrink-0 group-hover:bg-purple-400 transition-colors">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                            </svg>
                        </div>
                        <span class="font-semibold text-base">💬 Join Our Job Seeker Community Chat</span>
                    </button>

                    <a href="/about#security" class="flex items-center space-x-3 text-white hover:text-yellow-400 transition-all duration-300 hover:scale-105 group cursor-pointer">
                        <div class="w-8 h-8 bg-red-500 rounded-full flex items-center justify-center flex-shrink-0 group-hover:bg-red-400 transition-colors">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                            </svg>
                        </div>
                        <span class="font-semibold text-base">🔒 Bank-Level Security & Encryption Active</span>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Premium Job Cards Section with Categories -->
    <section id="jobs" class="section-premium bg-gradient-to-br from-slate-50 via-brand-blue/5 to-brand-indigo/10 py-24 relative">
        <!-- Dynamic Background -->
        <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="100" height="100" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill-rule="evenodd"%3E%3Cg fill="%23e0f2fe" fill-opacity="0.1"%3E%3Ccircle cx="50" cy="50" r="1"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-40"></div>
        <div class="absolute top-0 left-1/4 w-96 h-96 bg-gradient-to-br from-brand-cyan/10 to-transparent rounded-full blur-3xl"></div>
        <div class="absolute bottom-0 right-1/4 w-80 h-80 bg-gradient-to-br from-brand-purple/10 to-transparent rounded-full blur-3xl"></div>

        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-5xl font-bold text-premium mb-6">Featured Opportunities</h2>
                <p class="text-slate-600 max-w-3xl mx-auto text-xl leading-relaxed">Discover the most sought-after positions in Cameroon</p>
            </div>

            <!-- Job Category Tabs -->
            <div class="flex flex-wrap justify-center mb-12 bg-white/80 backdrop-blur-lg rounded-2xl p-2 shadow-xl max-w-2xl mx-auto">
                <button onclick="showJobCategory('most-searched')" class="job-tab-btn active flex-1 px-6 py-3 rounded-xl font-semibold transition-all duration-300 flex items-center justify-center space-x-2" data-category="most-searched">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                    <span>Most Searched</span>
                </button>
                <button onclick="showJobCategory('most-wanted')" class="job-tab-btn flex-1 px-6 py-3 rounded-xl font-semibold transition-all duration-300 flex items-center justify-center space-x-2" data-category="most-wanted">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"/>
                    </svg>
                    <span>Most Wanted</span>
                </button>
                <button onclick="showJobCategory('latest')" class="job-tab-btn flex-1 px-6 py-3 rounded-xl font-semibold transition-all duration-300 flex items-center justify-center space-x-2" data-category="latest">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    <span>Latest</span>
                </button>
            </div>

            <!-- Job Categories Content -->
            <div id="job-content" class="relative">
                <!-- Most Searched Jobs -->
                <div id="most-searched-jobs" class="job-category-content">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php $__empty_1 = true; $__currentLoopData = $featuredJobs->where('views_count', '>', 150); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php echo $__env->make('components.job-card', ['job' => $job], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-span-full text-center py-12">
                                <div class="w-24 h-24 bg-gray-200 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <svg class="w-12 h-12 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                                    </svg>
                                </div>
                                <h3 class="text-xl font-semibold text-gray-900 mb-2">No searched jobs available</h3>
                                <p class="text-gray-600">Check back later for trending opportunities</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Most Wanted Jobs -->
                <div id="most-wanted-jobs" class="job-category-content hidden">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php $__empty_1 = true; $__currentLoopData = $featuredJobs->sortByDesc('applications_count')->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php echo $__env->make('components.job-card', ['job' => $job], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-span-full text-center py-12">
                                <div class="w-24 h-24 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <svg class="w-12 h-12 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"/>
                                    </svg>
                                </div>
                                <h3 class="text-xl font-semibold text-gray-900 mb-2">No wanted jobs available</h3>
                                <p class="text-gray-600">Check back later for high-demand positions</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Latest Jobs -->
                <div id="latest-jobs" class="job-category-content hidden">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php $__empty_1 = true; $__currentLoopData = $featuredJobs->sortByDesc('created_at')->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php echo $__env->make('components.job-card', ['job' => $job], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="col-span-full text-center py-12">
                                <div class="w-24 h-24 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <svg class="w-12 h-12 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                </div>
                                <h3 class="text-xl font-semibold text-gray-900 mb-2">No latest jobs available</h3>
                                <p class="text-gray-600">Check back later for fresh opportunities</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Enhanced CTA -->
            <div class="text-center mt-20">
                <a href="<?php echo e(route('jobs.index')); ?>" class="inline-flex items-center px-8 py-4 bg-white/80 backdrop-blur-lg border border-white/50 rounded-2xl shadow-2xl hover:shadow-3xl transition-all duration-300 hover:-translate-y-2">
                    <svg class="w-8 h-8 mr-4 text-brand-navy" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 10h16M4 14h16M4 18h16"/>
                    </svg>
                    <div class="text-left">
                        <div class="font-bold text-slate-900 text-lg">Browse All Jobs</div>
                        <div class="text-slate-600">Discover 500+ opportunities waiting for you</div>
                    </div>
                    <svg class="w-6 h-6 ml-4 text-brand-green" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
            </div>
        </div>
    </section>

    <style>
        .job-tab-btn.active {
            background: linear-gradient(135deg, #fbbf24, #f59e0b);
            color: #000;
            box-shadow: 0 4px 15px rgba(251, 191, 36, 0.4);
        }
        
        .job-tab-btn:not(.active) {
            color: #6b7280;
            background: transparent;
        }
        
        .job-tab-btn:not(.active):hover {
            background: rgba(243, 244, 246, 0.8);
            color: #374151;
        }
        
        .job-category-content {
            animation: fadeIn 0.3s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>

    <script>
        function showJobCategory(category) {
            // Hide all job categories
            document.querySelectorAll('.job-category-content').forEach(content => {
                content.classList.add('hidden');
            });
            
            // Remove active class from all tabs
            document.querySelectorAll('.job-tab-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            
            // Show selected category
            document.getElementById(category + '-jobs').classList.remove('hidden');
            
            // Add active class to clicked tab
            document.querySelector(`[data-category="${category}"]`).classList.add('active');
        }
        
        // Show most searched jobs by default
        document.addEventListener('DOMContentLoaded', function() {
            showJobCategory('most-searched');
        });
    </script>

    <!-- Testimonials -->
    <section class="bg-gray-50 py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-8">
                <h2 class="text-2xl font-bold text-gray-900 mb-2">What Our Users Say</h2>
                <p class="text-gray-600 text-sm">Real stories from job seekers and employers</p>
            </div>

            <!-- Two Row Scrolling Testimonials -->
            <div class="space-y-4">
                <!-- Row 1 - Left to Right -->
                <div class="testimonial-row-1 overflow-hidden">
                    <div class="flex animate-scroll-left">
                        <!-- Testimonial 1 -->
                        <div class="flex-shrink-0 w-80 mx-4">
                            <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-100">
                                <div class="flex items-center mb-3">
                                    <img src="https://images.unsplash.com/photo-1494790108755-2616b612b786?w=40&h=40&fit=crop&crop=face" alt="Alice Johnson" class="w-10 h-10 rounded-full object-cover border-2 border-yellow-400">
                                    <div class="ml-3">
                                        <div class="font-semibold text-gray-900 text-sm">Alice Johnson</div>
                                        <div class="text-xs text-gray-600">Software Developer</div>
                                    </div>
                                </div>
                                <p class="text-gray-700 text-sm leading-relaxed mb-2">"HireCameroon transformed my job search! Got 3 interview offers in 2 weeks."</p>
                                <div class="flex text-yellow-400 text-xs">
                                    <span>★★★★★</span>
                                </div>
                            </div>
                        </div>

                        <!-- Testimonial 2 -->
                        <div class="flex-shrink-0 w-80 mx-4">
                            <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-100">
                                <div class="flex items-center mb-3">
                                    <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=40&h=40&fit=crop&crop=face" alt="Michael Chen" class="w-10 h-10 rounded-full object-cover border-2 border-blue-400">
                                    <div class="ml-3">
                                        <div class="font-semibold text-gray-900 text-sm">Michael Chen</div>
                                        <div class="text-xs text-gray-600">HR Director</div>
                                    </div>
                                </div>
                                <p class="text-gray-700 text-sm leading-relaxed mb-2">"60% faster hiring process. Hired 23 amazing professionals this year."</p>
                                <div class="flex text-yellow-400 text-xs">
                                    <span>★★★★★</span>
                                </div>
                            </div>
                        </div>

                        <!-- Testimonial 3 -->
                        <div class="flex-shrink-0 w-80 mx-4">
                            <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-100">
                                <div class="flex items-center mb-3">
                                    <img src="https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=40&h=40&fit=crop&crop=face" alt="Sarah Nkou" class="w-10 h-10 rounded-full object-cover border-2 border-purple-400">
                                    <div class="ml-3">
                                        <div class="font-semibold text-gray-900 text-sm">Sarah Nkou</div>
                                        <div class="text-xs text-gray-600">Marketing Manager</div>
                                    </div>
                                </div>
                                <p class="text-gray-700 text-sm leading-relaxed mb-2">"Bilingual support is amazing! Easy to connect with companies in both languages."</p>
                                <div class="flex text-yellow-400 text-xs">
                                    <span>★★★★★</span>
                                </div>
                            </div>
                        </div>

                        <!-- Testimonial 4 -->
                        <div class="flex-shrink-0 w-80 mx-4">
                            <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-100">
                                <div class="flex items-center mb-3">
                                    <img src="https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=40&h=40&fit=crop&crop=face" alt="David Mbarga" class="w-10 h-10 rounded-full object-cover border-2 border-green-400">
                                    <div class="ml-3">
                                        <div class="font-semibold text-gray-900 text-sm">David Mbarga</div>
                                        <div class="text-xs text-gray-600">Startup Founder</div>
                                    </div>
                                </div>
                                <p class="text-gray-700 text-sm leading-relaxed mb-2">"Built our entire dev team through HireCameroon. Quality candidates unmatched."</p>
                                <div class="flex text-yellow-400 text-xs">
                                    <span>★★★★★</span>
                                </div>
                            </div>
                        </div>

                        <!-- Duplicate for seamless loop -->
                        <div class="flex-shrink-0 w-80 mx-4">
                            <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-100">
                                <div class="flex items-center mb-3">
                                    <img src="https://images.unsplash.com/photo-1494790108755-2616b612b786?w=40&h=40&fit=crop&crop=face" alt="Alice Johnson" class="w-10 h-10 rounded-full object-cover border-2 border-yellow-400">
                                    <div class="ml-3">
                                        <div class="font-semibold text-gray-900 text-sm">Alice Johnson</div>
                                        <div class="text-xs text-gray-600">Software Developer</div>
                                    </div>
                                </div>
                                <p class="text-gray-700 text-sm leading-relaxed mb-2">"HireCameroon transformed my job search! Got 3 interview offers in 2 weeks."</p>
                                <div class="flex text-yellow-400 text-xs">
                                    <span>★★★★★</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Row 2 - Right to Left -->
                <div class="testimonial-row-2 overflow-hidden">
                    <div class="flex animate-scroll-right">
                        <!-- Testimonial 5 -->
                        <div class="flex-shrink-0 w-80 mx-4">
                            <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-100">
                                <div class="flex items-center mb-3">
                                    <img src="https://images.unsplash.com/photo-1534528741775-53994a69daeb?w=40&h=40&fit=crop&crop=face" alt="Marie-Claire Ngo" class="w-10 h-10 rounded-full object-cover border-2 border-pink-400">
                                    <div class="ml-3">
                                        <div class="font-semibold text-gray-900 text-sm">Marie-Claire Ngo</div>
                                        <div class="text-xs text-gray-600">UX Designer</div>
                                    </div>
                                </div>
                                <p class="text-gray-700 text-sm leading-relaxed mb-2">"The platform understands Cameroon's job market perfectly. Found my dream role!"</p>
                                <div class="flex text-yellow-400 text-xs">
                                    <span>★★★★★</span>
                                </div>
                            </div>
                        </div>

                        <!-- Testimonial 6 -->
                        <div class="flex-shrink-0 w-80 mx-4">
                            <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-100">
                                <div class="flex items-center mb-3">
                                    <img src="https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=40&h=40&fit=crop&crop=face" alt="Jean-Paul Mbia" class="w-10 h-10 rounded-full object-cover border-2 border-indigo-400">
                                    <div class="ml-3">
                                        <div class="font-semibold text-gray-900 text-sm">Jean-Paul Mbia</div>
                                        <div class="text-xs text-gray-600">Project Manager</div>
                                    </div>
                                </div>
                                <p class="text-gray-700 text-sm leading-relaxed mb-2">"Professional platform with excellent candidate quality. Highly recommended!"</p>
                                <div class="flex text-yellow-400 text-xs">
                                    <span>★★★★★</span>
                                </div>
                            </div>
                        </div>

                        <!-- Testimonial 7 -->
                        <div class="flex-shrink-0 w-80 mx-4">
                            <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-100">
                                <div class="flex items-center mb-3">
                                    <img src="https://images.unsplash.com/photo-1544005313-94ddf0286df2?w=40&h=40&fit=crop&crop=face" alt="Grace Abena" class="w-10 h-10 rounded-full object-cover border-2 border-teal-400">
                                    <div class="ml-3">
                                        <div class="font-semibold text-gray-900 text-sm">Grace Abena</div>
                                        <div class="text-xs text-gray-600">Data Analyst</div>
                                    </div>
                                </div>
                                <p class="text-gray-700 text-sm leading-relaxed mb-2">"Mobile-first design works perfectly in Cameroon. Easy to use on any device."</p>
                                <div class="flex text-yellow-400 text-xs">
                                    <span>★★★★★</span>
                                </div>
                            </div>
                        </div>

                        <!-- Testimonial 8 -->
                        <div class="flex-shrink-0 w-80 mx-4">
                            <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-100">
                                <div class="flex items-center mb-3">
                                    <img src="https://images.unsplash.com/photo-1517841905240-472988babdf9?w=40&h=40&fit=crop&crop=face" alt="Ahmed Hassan" class="w-10 h-10 rounded-full object-cover border-2 border-orange-400">
                                    <div class="ml-3">
                                        <div class="font-semibold text-gray-900 text-sm">Ahmed Hassan</div>
                                        <div class="text-xs text-gray-600">Business Analyst</div>
                                    </div>
                                </div>
                                <p class="text-gray-700 text-sm leading-relaxed mb-2">"Secure payments and professional service. Cameroon finally has a world-class job platform."</p>
                                <div class="flex text-yellow-400 text-xs">
                                    <span>★★★★★</span>
                                </div>
                            </div>
                        </div>

                        <!-- Duplicate for seamless loop -->
                        <div class="flex-shrink-0 w-80 mx-4">
                            <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-100">
                                <div class="flex items-center mb-3">
                                    <img src="https://images.unsplash.com/photo-1534528741775-53994a69daeb?w=40&h=40&fit=crop&crop=face" alt="Marie-Claire Ngo" class="w-10 h-10 rounded-full object-cover border-2 border-pink-400">
                                    <div class="ml-3">
                                        <div class="font-semibold text-gray-900 text-sm">Marie-Claire Ngo</div>
                                        <div class="text-xs text-gray-600">UX Designer</div>
                                    </div>
                                </div>
                                <p class="text-gray-700 text-sm leading-relaxed mb-2">"The platform understands Cameroon's job market perfectly. Found my dream role!"</p>
                                <div class="flex text-yellow-400 text-xs">
                                    <span>★★★★★</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Write Review CTA -->
            <div class="text-center mt-8">
                <button onclick="openReviewModal()" class="inline-flex items-center px-4 py-2 bg-black hover:bg-gray-800 text-yellow-400 text-sm font-medium rounded-lg transition-colors">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                    </svg>
                    Write a Review
                </button>
            </div>

            <!-- Review Modal -->
            <div id="reviewModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center p-4">
                <div class="bg-white rounded-2xl max-w-md w-full max-h-[90vh] overflow-y-auto">
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-6">
                            <h3 class="text-xl font-bold text-gray-900">Write a Review</h3>
                            <button onclick="closeReviewModal()" class="text-gray-400 hover:text-gray-600">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                </svg>
                            </button>
                        </div>

                        <form id="reviewForm" onsubmit="submitReview(event)">
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Your Name</label>
                                <input type="text" id="reviewerName" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-400 focus:border-transparent">
                            </div>

                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Your Role</label>
                                <input type="text" id="reviewerRole" placeholder="e.g. Software Developer, HR Manager" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-400 focus:border-transparent">
                            </div>

                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Rating</label>
                                <div class="flex space-x-1">
                                    <input type="radio" id="rating5" name="rating" value="5" class="hidden">
                                    <label for="rating5" class="cursor-pointer text-2xl text-gray-300 hover:text-yellow-400 star-rating">★</label>
                                    <input type="radio" id="rating4" name="rating" value="4" class="hidden">
                                    <label for="rating4" class="cursor-pointer text-2xl text-gray-300 hover:text-yellow-400 star-rating">★</label>
                                    <input type="radio" id="rating3" name="rating" value="3" class="hidden">
                                    <label for="rating3" class="cursor-pointer text-2xl text-gray-300 hover:text-yellow-400 star-rating">★</label>
                                    <input type="radio" id="rating2" name="rating" value="2" class="hidden">
                                    <label for="rating2" class="cursor-pointer text-2xl text-gray-300 hover:text-yellow-400 star-rating">★</label>
                                    <input type="radio" id="rating1" name="rating" value="1" class="hidden" checked>
                                    <label for="rating1" class="cursor-pointer text-2xl text-gray-300 hover:text-yellow-400 star-rating">★</label>
                                </div>
                            </div>

                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Your Review</label>
                                <textarea id="reviewContent" rows="4" required placeholder="Share your experience with HireCameroon..." class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-400 focus:border-transparent resize-none"></textarea>
                            </div>

                            <div class="mb-6">
                                <label class="block text-sm font-medium text-gray-700 mb-2">I am a:</label>
                                <div class="flex space-x-4">
                                    <label class="flex items-center">
                                        <input type="radio" name="userType" value="job_seeker" checked class="text-blue-600 focus:ring-blue-500">
                                        <span class="ml-2 text-sm text-gray-700">Job Seeker</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="radio" name="userType" value="employer" class="text-blue-600 focus:ring-blue-500">
                                        <span class="ml-2 text-sm text-gray-700">Employer</span>
                                    </label>
                                </div>
                            </div>

                            <div class="flex space-x-3">
                                <button type="button" onclick="closeReviewModal()" class="flex-1 px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                                    Cancel
                                </button>
                                <button type="submit" class="flex-1 px-4 py-2 bg-black text-yellow-400 rounded-lg hover:bg-gray-800 transition-colors">
                                    Submit Review
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CV Review Workshop Modal -->
    <div id="cvReviewModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center p-4">
        <div class="bg-white rounded-2xl max-w-md w-full max-h-[90vh] overflow-y-auto">
            <div class="p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-bold text-gray-900">Free CV Review Workshop</h3>
                    <button onclick="closeCVReviewModal()" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>

                <div class="mb-4">
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-3 mb-4">
                        <h4 class="font-semibold text-blue-900 mb-2">What's included:</h4>
                        <ul class="text-sm text-blue-800 space-y-1">
                            <li>• Professional CV/Resume review</li>
                            <li>• Industry-specific feedback</li>
                            <li>• LinkedIn profile optimization</li>
                            <li>• Interview preparation tips</li>
                        </ul>
                    </div>
                </div>

                <form id="cvReviewForm" onsubmit="submitCVReview(event)">
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Your Name</label>
                        <input type="text" id="cvName" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-400 focus:border-transparent">
                    </div>

                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
                        <input type="email" id="cvEmail" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-400 focus:border-transparent">
                    </div>

                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Phone Number</label>
                        <input type="tel" id="cvPhone" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-400 focus:border-transparent" placeholder="+237 6XX XXX XXX">
                    </div>

                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Years of Experience</label>
                        <select id="cvExperience" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-400 focus:border-transparent">
                            <option value="">Select experience level</option>
                            <option value="0-1">0-1 years (Entry level)</option>
                            <option value="2-5">2-5 years (Mid level)</option>
                            <option value="6-10">6-10 years (Senior level)</option>
                            <option value="10+">10+ years (Expert level)</option>
                        </select>
                    </div>

                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Current Role/Target Role</label>
                        <input type="text" id="cvCurrentRole" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-400 focus:border-transparent" placeholder="e.g. Software Developer, Marketing Manager">
                    </div>

                    <div class="flex space-x-3">
                        <button type="button" onclick="closeCVReviewModal()" class="flex-1 px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                            Cancel
                        </button>
                        <button type="submit" class="flex-1 px-4 py-2 bg-yellow-400 text-black rounded-lg hover:bg-yellow-500 transition-colors font-semibold">
                            Register Free
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Support Modal -->
    <div id="supportModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center p-4">
        <div class="bg-white rounded-2xl max-w-lg w-full max-h-[90vh] overflow-y-auto">
            <div class="p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-bold text-gray-900">Contact Support</h3>
                    <button onclick="closeSupportModal()" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>

                <div class="mb-6">
                    <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                        <div class="flex items-center mb-2">
                            <svg class="w-5 h-5 text-green-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <h4 class="font-semibold text-green-900">Quick Support Options</h4>
                        </div>
                        <div class="space-y-2 text-sm text-green-800">
                            <p>• <strong>Email:</strong> support@hirecameroon.com</p>
                            <p>• <strong>Phone:</strong> +237 6XX XXX XXX</p>
                            <p>• <strong>Response Time:</strong> Within 24 hours</p>
                            <p>• <strong>Live Chat:</strong> Available 9 AM - 6 PM (WAT)</p>
                        </div>
                    </div>
                </div>

                <form id="supportForm" onsubmit="submitSupportRequest(event)">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Your Name</label>
                            <input type="text" id="supportName" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="Enter your full name">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
                            <input type="email" id="supportEmail" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="your@email.com">
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Subject</label>
                        <input type="text" id="supportSubject" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="Brief description of your issue">
                    </div>

                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Category</label>
                        <select id="supportCategory" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                            <option value="">Select a category</option>
                            <option value="account">Account Issues</option>
                            <option value="job_posting">Job Posting Problems</option>
                            <option value="application">Application Issues</option>
                            <option value="payment">Payment & Billing</option>
                            <option value="technical">Technical Support</option>
                            <option value="feature_request">Feature Request</option>
                            <option value="other">Other</option>
                        </select>
                    </div>

                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Message</label>
                        <textarea id="supportMessage" rows="4" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent resize-none" placeholder="Please describe your issue in detail..."></textarea>
                    </div>

                    <div class="flex space-x-3">
                        <button type="button" onclick="closeSupportModal()" class="flex-1 px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                            Cancel
                        </button>
                        <button type="submit" class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors font-semibold">
                            Send Request
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <style>
        @keyframes scroll-left {
            0% { transform: translateX(0); }
            100% { transform: translateX(-50%); }
        }

        @keyframes scroll-right {
            0% { transform: translateX(-50%); }
            100% { transform: translateX(0); }
        }

        .animate-scroll-left {
            animation: scroll-left 40s linear infinite;
        }

        .animate-scroll-right {
            animation: scroll-right 35s linear infinite;
        }

        .testimonial-row-1:hover .animate-scroll-left,
        .testimonial-row-2:hover .animate-scroll-right {
            animation-play-state: paused;
        }

        /* Breaking News Marquee Animation */
        .marquee-container {
            overflow: hidden;
        }

        .marquee-content {
            animation: scroll-marquee 30s linear infinite;
        }

        @keyframes scroll-marquee {
            0% { transform: translateX(100%); }
            100% { transform: translateX(-100%); }
        }

        .marquee-container:hover .marquee-content {
            animation-play-state: paused;
        }
    </style>

    <!-- Benefits -->
    <section class="bg-white py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-gray-900 mb-4">Why Choose HireCameroon?</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">Built specifically for the Cameroonian job market</p>
            </div>
            <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
                <div class="text-center">
                    <div class="w-12 h-12 bg-yellow-400 rounded-lg flex items-center justify-center mx-auto mb-4">
                        <svg class="w-6 h-6 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064"/>
                        </svg>
                    </div>
                    <h3 class="font-semibold text-gray-900 mb-2">Bilingual Support</h3>
                    <p class="text-gray-600 text-sm">Full English and French language support</p>
                </div>
                <div class="text-center">
                    <div class="w-12 h-12 bg-yellow-400 rounded-lg flex items-center justify-center mx-auto mb-4">
                        <svg class="w-6 h-6 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                        </svg>
                    </div>
                    <h3 class="font-semibold text-gray-900 mb-2">Mobile First</h3>
                    <p class="text-gray-600 text-sm">Optimized for mobile devices and slow connections</p>
                </div>
                <div class="text-center">
                    <div class="w-12 h-12 bg-yellow-400 rounded-lg flex items-center justify-center mx-auto mb-4">
                        <svg class="w-6 h-6 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                    </div>
                    <h3 class="font-semibold text-gray-900 mb-2">Local Payments</h3>
                    <p class="text-gray-600 text-sm">Mesomb integration for seamless XAF payments</p>
                </div>
                <div class="text-center">
                    <div class="w-12 h-12 bg-yellow-400 rounded-lg flex items-center justify-center mx-auto mb-4">
                        <svg class="w-6 h-6 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                        </svg>
                    </div>
                    <h3 class="font-semibold text-gray-900 mb-2">Secure & Trusted</h3>
                    <p class="text-gray-600 text-sm">Bank-level security and data protection</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Frequently Asked Questions -->
    <section class="bg-gray-50 py-24">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">Frequently Asked Questions</h2>
                <p class="text-gray-600 max-w-2xl mx-auto text-lg">Everything you need to know about getting started with HireCameroon</p>
            </div>

            <div class="grid md:grid-cols-2 gap-8">
                <!-- FAQ Column 1 -->
                <div class="space-y-6">
                    <!-- FAQ Item 1 -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                        <button class="faq-toggle w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-1">
                            <h3 class="font-bold text-gray-900 pr-4 text-lg">Is HireCameroon free to use?</h3>
                            <svg class="faq-icon w-6 h-6 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                        </button>
                        <div id="faq-1" class="faq-content px-6 pb-6 hidden">
                            <p class="text-gray-600 leading-relaxed text-base">Yes! Creating an account and searching for jobs is completely free. Employers can post one job for free, with premium plans starting at 25,000 XAF/month for unlimited postings and advanced features.</p>
                        </div>
                    </div>

                    <!-- FAQ Item 2 -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                        <button class="faq-toggle w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-2">
                            <h3 class="font-bold text-gray-900 pr-4 text-lg">How does the bilingual support work?</h3>
                            <svg class="faq-icon w-6 h-6 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                        </button>
                        <div id="faq-2" class="faq-content px-6 pb-6 hidden">
                            <p class="text-gray-600 leading-relaxed text-base">Our platform supports both English and French seamlessly. You can create your profile, search for jobs, and communicate in your preferred language. All major features are available in both languages with culturally relevant content.</p>
                        </div>
                    </div>

                    <!-- FAQ Item 3 -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                        <button class="faq-toggle w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-3">
                            <h3 class="font-bold text-gray-900 pr-4 text-lg">How quickly can I get hired?</h3>
                            <svg class="faq-icon w-6 h-6 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                        </button>
                        <div id="faq-3" class="faq-content px-6 pb-6 hidden">
                            <p class="text-gray-600 leading-relaxed text-base">Our average time to first interview is just 48 hours! Many users find suitable opportunities within their first week. Premium job postings get even faster response times with priority placement.</p>
                        </div>
                    </div>
                </div>

                <!-- FAQ Column 2 -->
                <div class="space-y-6">
                    <!-- FAQ Item 4 -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                        <button class="faq-toggle w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-4">
                            <h3 class="font-bold text-gray-900 pr-4 text-lg">Are payments secure?</h3>
                            <svg class="faq-icon w-6 h-6 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                        </button>
                        <div id="faq-4" class="faq-content px-6 pb-6 hidden">
                            <p class="text-gray-600 leading-relaxed text-base">Absolutely! We use Mesomb for secure mobile money payments and bank-level encryption for all data. All transactions are processed through trusted financial institutions with industry-standard security protocols.</p>
                        </div>
                    </div>

                    <!-- FAQ Item 5 -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                        <button class="faq-toggle w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-5">
                            <h3 class="font-bold text-gray-900 pr-4 text-lg">Can I switch between plans?</h3>
                            <svg class="faq-icon w-6 h-6 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                        </button>
                        <div id="faq-5" class="faq-content px-6 pb-6 hidden">
                            <p class="text-gray-600 leading-relaxed text-base">Yes! You can upgrade or downgrade your plan at any time. Changes take effect immediately, and we'll prorate any charges. No long-term contracts or cancellation fees - just flexible pricing that grows with your business.</p>
                        </div>
                    </div>

                    <!-- FAQ Item 6 -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden">
                        <button class="faq-toggle w-full px-6 py-5 text-left flex items-center justify-between hover:bg-gray-50 transition-colors focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:ring-inset" data-target="faq-6">
                            <h3 class="font-bold text-gray-900 pr-4 text-lg">Do you support remote work?</h3>
                            <svg class="faq-icon w-6 h-6 text-gray-500 transform transition-transform duration-200 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                        </button>
                        <div id="faq-6" class="faq-content px-6 pb-6 hidden">
                            <p class="text-gray-600 leading-relaxed text-base">Yes! We have a growing number of remote and hybrid opportunities. Many Cameroonian companies are embracing remote work, and we help connect talent with opportunities that fit their preferred work arrangement.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- CTA -->
            <div class="text-center mt-16">
                <p class="text-gray-600 mb-6 text-lg">Still have questions?</p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <button onclick="openSupportModal()" class="inline-flex items-center px-8 py-4 bg-yellow-400 hover:bg-yellow-500 text-black font-bold rounded-xl transition-all duration-300 shadow-lg hover:shadow-xl">
                        <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                        </svg>
                        Contact Support
                    </button>
                    <a href="<?php echo e(route('jobs.index')); ?>" class="inline-flex items-center px-8 py-4 border-2 border-gray-300 text-gray-700 hover:border-gray-400 font-semibold rounded-xl transition-all duration-300">
                        <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                        Browse Jobs
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const toggles = document.querySelectorAll('.faq-toggle');

            toggles.forEach(toggle => {
                toggle.addEventListener('click', function() {
                    const targetId = this.getAttribute('data-target');
                    const content = document.getElementById(targetId);
                    const icon = this.querySelector('.faq-icon');

                    // Close all other FAQs
                    document.querySelectorAll('.faq-content').forEach(item => {
                        if (item.id !== targetId) {
                            item.classList.add('hidden');
                            item.previousElementSibling.querySelector('.faq-icon').classList.remove('rotate-180');
                        }
                    });

                    // Toggle current FAQ
                    content.classList.toggle('hidden');
                    icon.classList.toggle('rotate-180');
                });
            });
        });
    </script>

    <!-- Review Modal Functions -->
    <script>
        function openReviewModal() {
            document.getElementById('reviewModal').classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }

        function closeReviewModal() {
            document.getElementById('reviewModal').classList.add('hidden');
            document.body.style.overflow = 'auto';
            // Reset form
            document.getElementById('reviewForm').reset();
            document.getElementById('rating1').checked = true;
        }

        function openCVReviewModal() {
            document.getElementById('cvReviewModal').classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }

        function closeCVReviewModal() {
            document.getElementById('cvReviewModal').classList.add('hidden');
            document.body.style.overflow = 'auto';
            // Reset form
            document.getElementById('cvReviewForm').reset();
        }

        // Support System Functions
        function openSupportModal() {
            document.getElementById('supportModal').classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }

        function closeSupportModal() {
            document.getElementById('supportModal').classList.add('hidden');
            document.body.style.overflow = 'auto';
            document.getElementById('supportForm').reset();
        }

        function submitCVReview(event) {
            event.preventDefault();
            
            const formData = new FormData(document.getElementById('cvReviewForm'));
            const cvData = {
                name: formData.get('cvName') || document.getElementById('cvName').value,
                email: formData.get('cvEmail') || document.getElementById('cvEmail').value,
                phone: formData.get('cvPhone') || document.getElementById('cvPhone').value,
                experience: formData.get('cvExperience') || document.getElementById('cvExperience').value,
                currentRole: formData.get('cvCurrentRole') || document.getElementById('cvCurrentRole').value
            };

            // Validate required fields
            if (!cvData.name || !cvData.email || !cvData.phone || !cvData.experience || !cvData.currentRole) {
                showNotification('Please fill in all required fields', 'error');
                return;
            }

            // Show loading state
            const submitButton = event.target.querySelector('button[type="submit"]');
            const originalText = submitButton.textContent;
            submitButton.disabled = true;
            submitButton.textContent = 'Registering...';

            // API call for CV Review Workshop
            fetch('/api/cv-review-workshop', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify(cvData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    closeCVReviewModal();
                    showNotification('Thank you for registering! We will contact you with workshop details.', 'success');
                } else {
                    showNotification(data.message || 'Failed to register. Please try again.', 'error');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showNotification('Failed to register. Please try again.', 'error');
            })
            .finally(() => {
                // Reset button state
                submitButton.disabled = false;
                submitButton.textContent = originalText;
            });
        }

        function submitReview(event) {
            event.preventDefault();
            
            const formData = new FormData(document.getElementById('reviewForm'));
            const reviewData = {
                name: formData.get('reviewerName') || document.getElementById('reviewerName').value,
                role: formData.get('reviewerRole') || document.getElementById('reviewerRole').value,
                rating: formData.get('rating') || document.querySelector('input[name="rating"]:checked').value,
                content: formData.get('reviewContent') || document.getElementById('reviewContent').value,
                userType: formData.get('userType') || document.querySelector('input[name="userType"]:checked').value
            };

            // Validate required fields
            if (!reviewData.name || !reviewData.rating || !reviewData.content) {
                showNotification('Please fill in all required fields and provide a rating', 'error');
                return;
            }

            // Show loading state
            const submitButton = event.target.querySelector('button[type="submit"]');
            const originalText = submitButton.textContent;
            submitButton.disabled = true;
            submitButton.textContent = 'Submitting...';

            // API call for review submission
            fetch('/api/reviews', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify(reviewData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    closeReviewModal();
                    showNotification('Thank you for your review! It helps other users make informed decisions.', 'success');
                } else {
                    showNotification(data.message || 'Failed to submit review. Please try again.', 'error');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showNotification('Failed to submit review. Please try again.', 'error');
            })
            .finally(() => {
                // Reset button state
                submitButton.disabled = false;
                submitButton.textContent = originalText;
            });
        }

        function submitSupportRequest(event) {
            event.preventDefault();
            
            const formData = new FormData(document.getElementById('supportForm'));
            const supportData = {
                name: document.getElementById('supportName').value,
                email: document.getElementById('supportEmail').value,
                subject: document.getElementById('supportSubject').value,
                category: document.getElementById('supportCategory').value,
                message: document.getElementById('supportMessage').value
            };

            // Validate required fields
            if (!supportData.name || !supportData.email || !supportData.subject || !supportData.message) {
                showNotification('Please fill in all required fields', 'error');
                return;
            }

            // Email validation
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test(supportData.email)) {
                showNotification('Please enter a valid email address', 'error');
                return;
            }

            // Show loading state
            const submitButton = event.target.querySelector('button[type="submit"]');
            const originalText = submitButton.textContent;
            submitButton.disabled = true;
            submitButton.textContent = 'Sending...';

            // API call for support request
            fetch('/api/support', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify(supportData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    closeSupportModal();
                    showNotification('Your support request has been sent successfully! We will respond within 24 hours.', 'success');
                } else {
                    showNotification(data.message || 'Failed to send support request. Please try again.', 'error');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showNotification('Failed to send support request. Please try again.', 'error');
            })
            .finally(() => {
                // Reset button state
                submitButton.disabled = false;
                submitButton.textContent = originalText;
            });
        }

        // Star rating interaction
        document.addEventListener('DOMContentLoaded', function() {
            const stars = document.querySelectorAll('.star-rating');
            const ratingInputs = document.querySelectorAll('input[name="rating"]');

            stars.forEach((star, index) => {
                star.addEventListener('click', function() {
                    // Update radio button
                    ratingInputs[index].checked = true;
                    
                    // Update star colors
                    stars.forEach((s, i) => {
                        if (i <= index) {
                            s.classList.add('text-yellow-400');
                            s.classList.remove('text-gray-300');
                        } else {
                            s.classList.add('text-gray-300');
                            s.classList.remove('text-yellow-400');
                        }
                    });
                });

                star.addEventListener('mouseenter', function() {
                    stars.forEach((s, i) => {
                        if (i <= index) {
                            s.classList.add('text-yellow-400');
                            s.classList.remove('text-gray-300');
                        } else {
                            s.classList.add('text-gray-300');
                            s.classList.remove('text-yellow-400');
                        }
                    });
                });
            });

            // Reset stars on mouse leave from rating container
            const ratingContainer = stars[0].parentElement;
            ratingContainer.addEventListener('mouseleave', function() {
                const checkedRating = document.querySelector('input[name="rating"]:checked');
                const checkedIndex = checkedRating ? Array.from(ratingInputs).indexOf(checkedRating) : -1;
                
                stars.forEach((s, i) => {
                    if (checkedRating && i <= checkedIndex) {
                        s.classList.add('text-yellow-400');
                        s.classList.remove('text-gray-300');
                    } else {
                        s.classList.add('text-gray-300');
                        s.classList.remove('text-yellow-400');
                    }
                });
            });
        });

        // Close modal when clicking outside
        document.getElementById('reviewModal').addEventListener('click', function(event) {
            if (event.target === this) {
                closeReviewModal();
            }
        });

        // Close CV modal when clicking outside
        document.getElementById('cvReviewModal').addEventListener('click', function(event) {
            if (event.target === this) {
                closeCVReviewModal();
            }
        });

        // Close support modal when clicking outside
        document.getElementById('supportModal').addEventListener('click', function(event) {
            if (event.target === this) {
                closeSupportModal();
            }
        });
    </script>




    <!-- Partners Section with Scrolling Animation -->
    <section class="bg-gray-50 py-16 overflow-hidden">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-gray-900 mb-4">Trusted by Leading Companies</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">We're proud to partner with the best companies in Cameroon</p>
            </div>

            <!-- Scrolling Partners Animation -->
            <div class="relative">
                <div class="flex animate-scroll-left space-x-16">
                    <!-- Partner 1 -->
                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">MTN</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">MTN Cameroon</p>
                        </div>
                    </div>

                    <!-- Partner 2 -->
                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-green-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">OR</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">Orange</p>
                        </div>
                    </div>

                    <!-- Partner 3 -->
                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-red-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">NC</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">NCR Cameroon</p>
                        </div>
                    </div>

                    <!-- Partner 4 -->
                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">SG</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">SG Cameroon</p>
                        </div>
                    </div>

                    <!-- Partner 5 -->
                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-yellow-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">BC</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">BCA Cameroon</p>
                        </div>
                    </div>

                    <!-- Partner 6 -->
                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-indigo-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">UC</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">UBA Cameroon</p>
                        </div>
                    </div>

                    <!-- Partner 7 -->
                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-teal-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">AC</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">Access Bank</p>
                        </div>
                    </div>

                    <!-- Partner 8 -->
                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-pink-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">EC</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">Ecobank</p>
                        </div>
                    </div>

                    <!-- Duplicate for seamless loop -->
                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">MTN</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">MTN Cameroon</p>
                        </div>
                    </div>

                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-green-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">OR</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">Orange</p>
                        </div>
                    </div>

                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-red-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">NC</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">NCR Cameroon</p>
                        </div>
                    </div>

                    <div class="flex-shrink-0 w-32 h-24 bg-white rounded-xl shadow-md flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center mx-auto mb-2">
                                <span class="text-white font-bold text-lg">SG</span>
                            </div>
                            <p class="text-xs text-gray-600 font-medium">SG Cameroon</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section with Black Background -->
    <section class="bg-black text-white py-16">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h3 class="text-3xl font-bold mb-4 text-white">Ready to get started?</h3>
            <p class="text-gray-300 mb-8">Create your free account and post your first job today.</p>
            <a href="<?php echo e(route('register')); ?>" class="bg-yellow-400 hover:bg-yellow-500 text-black font-semibold py-3 px-6 rounded-lg transition">
                Create account
            </a>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.marketing', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\www\github\hiringcameroon\resources\views/welcome.blade.php ENDPATH**/ ?>