

<?php $__env->startSection('title', 'Support HireCameroon - Make a Donation'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="bg-black text-white py-24">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <div class="mb-8">
                <div class="w-20 h-20 bg-yellow-400 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-10 h-10 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                    </svg>
                </div>
                <h1 class="text-4xl md:text-5xl font-black text-white mb-6">
                    Support HireCameroon
                </h1>
                <p class="text-xl text-gray-300 max-w-2xl mx-auto leading-relaxed">
                    Your donation helps keep HireCameroon free and accessible to job seekers and employers across Cameroon. Every contribution makes a difference in connecting talent with opportunity.
                </p>
            </div>
        </div>
    </section>

    <!-- Impact Section -->
    <section class="py-16 bg-white">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-black mb-4">Your Impact</h2>
                <p class="text-gray-600 max-w-2xl mx-auto">See how your donation helps the Cameroonian job market</p>
            </div>

            <div class="grid md:grid-cols-3 gap-8">
                <div class="text-center p-6 bg-gray-50 rounded-2xl border border-gray-200">
                    <div class="w-16 h-16 bg-yellow-400 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-black mb-2">Job Seekers</h3>
                    <p class="text-gray-700">Help job seekers find opportunities and build careers in their home country</p>
                </div>

                <div class="text-center p-6 bg-gray-50 rounded-2xl border border-gray-200">
                    <div class="w-16 h-16 bg-black rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-black mb-2">Employers</h3>
                    <p class="text-gray-700">Support local businesses in finding qualified talent and growing their operations</p>
                </div>

                <div class="text-center p-6 bg-gray-50 rounded-2xl border border-gray-200">
                    <div class="w-16 h-16 bg-yellow-400 rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-black mb-2">Community</h3>
                    <p class="text-gray-700">Strengthen Cameroon's economy by keeping skilled workers in the country</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Donation Options -->
    <section class="py-16 bg-gray-50">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-black mb-4">Choose Your Donation Amount</h2>
                <p class="text-gray-600">All donations are processed securely through Mesomb</p>
            </div>

            <!-- Preset Amounts -->
            <div class="grid md:grid-cols-4 gap-4 mb-8">
                <button onclick="selectAmount(5000)" class="donation-amount bg-white border-2 border-gray-200 hover:border-yellow-400 text-black hover:text-yellow-600 font-bold py-4 px-6 rounded-xl transition-all duration-300 hover:shadow-lg hover:-translate-y-1">
                    XAF 5,000
                </button>
                <button onclick="selectAmount(10000)" class="donation-amount bg-white border-2 border-gray-200 hover:border-yellow-400 text-black hover:text-yellow-600 font-bold py-4 px-6 rounded-xl transition-all duration-300 hover:shadow-lg hover:-translate-y-1">
                    XAF 10,000
                </button>
                <button onclick="selectAmount(25000)" class="donation-amount bg-white border-2 border-gray-200 hover:border-yellow-400 text-black hover:text-yellow-600 font-bold py-4 px-6 rounded-xl transition-all duration-300 hover:shadow-lg hover:-translate-y-1">
                    XAF 25,000
                </button>
                <button onclick="selectAmount(50000)" class="donation-amount bg-white border-2 border-gray-200 hover:border-yellow-400 text-black hover:text-yellow-600 font-bold py-4 px-6 rounded-xl transition-all duration-300 hover:shadow-lg hover:-translate-y-1">
                    XAF 50,000
                </button>
            </div>

            <!-- Custom Amount -->
            <div class="bg-white rounded-2xl p-8 shadow-lg border border-gray-100 mb-8">
                <div class="text-center mb-6">
                    <h3 class="text-xl font-bold text-black mb-2">Custom Amount</h3>
                    <p class="text-gray-600">Enter any amount you'd like to donate</p>
                </div>

                <form id="donationForm" class="space-y-6">
                    <div class="flex justify-center">
                        <div class="relative">
                            <span class="absolute left-4 top-4 text-gray-500 font-semibold">XAF</span>
                            <input type="number" id="customAmount" name="amount" min="1000" step="1000"
                                   placeholder="Enter amount"
                                   class="pl-16 pr-4 py-4 bg-gray-50 border-2 border-gray-200 rounded-xl text-black placeholder-gray-500 focus:outline-none focus:ring-4 focus:ring-yellow-400/20 focus:border-yellow-400 transition-all duration-300 text-xl font-bold w-48 text-center">
                        </div>
                    </div>

                    <!-- Donor Information -->
                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Full Name</label>
                            <input type="text" name="name" required
                                   class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-black placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:border-transparent transition-all">
                        </div>
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Phone Number</label>
                            <input type="tel" name="phone" required pattern="[0-9]{9}"
                                   placeholder="e.g., 670123456"
                                   class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-black placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-yellow-400 focus:border-transparent transition-all">
                        </div>
                    </div>

                    <!-- Payment Method -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-4">Payment Method</label>
                        <div class="grid md:grid-cols-2 gap-4">
                            <label class="payment-method flex items-center p-4 bg-gray-50 border-2 border-gray-200 rounded-xl cursor-pointer hover:border-yellow-400 transition-all">
                                <input type="radio" name="payment_method" value="mtn" checked class="mr-3">
                                <div class="flex items-center">
                                    <div class="w-8 h-8 bg-yellow-400 rounded-lg flex items-center justify-center mr-3">
                                        📱
                                    </div>
                                    <div>
                                        <div class="font-semibold text-black">MTN Mobile Money</div>
                                        <div class="text-sm text-gray-600">Most popular option</div>
                                    </div>
                                </div>
                            </label>

                            <label class="payment-method flex items-center p-4 bg-gray-50 border-2 border-gray-200 rounded-xl cursor-pointer hover:border-yellow-400 transition-all">
                                <input type="radio" name="payment_method" value="orange" class="mr-3">
                                <div class="flex items-center">
                                    <div class="w-8 h-8 bg-black rounded-lg flex items-center justify-center mr-3">
                                        📱
                                    </div>
                                    <div>
                                        <div class="font-semibold text-black">Orange Money</div>
                                        <div class="text-sm text-gray-600">Alternative option</div>
                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>

                    <!-- Donate Button -->
                    <div class="text-center">
                        <button type="submit" class="bg-yellow-400 hover:bg-yellow-500 text-black font-bold px-12 py-4 rounded-xl transition-all duration-300 shadow-xl hover:shadow-2xl transform hover:scale-105 hover:-translate-y-1 flex items-center mx-auto">
                            <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                            </svg>
                            Complete Donation
                        </button>
                    </div>
                </form>
            </div>

            <!-- Security Notice -->
            <div class="bg-green-50 border border-green-200 rounded-xl p-6">
                <div class="flex items-start">
                    <div class="w-8 h-8 bg-green-500 rounded-lg flex items-center justify-center mr-4 flex-shrink-0">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                        </svg>
                    </div>
                    <div>
                        <h4 class="font-semibold text-green-900 mb-2">Secure & Trusted</h4>
                        <p class="text-green-800 text-sm">Your donation is processed securely through Mesomb with bank-level encryption. All transactions are protected and your information is never stored.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        let selectedAmount = null;

        function selectAmount(amount) {
            selectedAmount = amount;
            document.getElementById('customAmount').value = amount;

            // Update button styles
            document.querySelectorAll('.donation-amount').forEach(btn => {
                btn.classList.remove('border-yellow-400', 'text-yellow-600', 'bg-yellow-50');
                btn.classList.add('border-gray-200', 'text-black');
            });

            event.target.classList.remove('border-gray-200', 'text-black');
            event.target.classList.add('border-yellow-400', 'text-yellow-600', 'bg-yellow-50');
        }

        document.getElementById('donationForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(this);
            const amount = formData.get('amount') || selectedAmount;
            const name = formData.get('name');
            const phone = formData.get('phone');
            const paymentMethod = formData.get('payment_method');

            if (!amount || amount < 1000) {
                alert('Please enter a donation amount of at least XAF 1,000');
                return;
            }

            if (!name || name.trim().length < 2) {
                alert('Please enter your full name');
                return;
            }

            if (!phone || !/^[0-9]{9}$/.test(phone)) {
                alert('Please enter a valid 9-digit phone number');
                return;
            }

            // Show loading state
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.innerHTML = '<div class="animate-spin rounded-full h-6 w-6 border-b-2 border-black mx-auto"></div>';
            submitBtn.disabled = true;

            // Simulate payment processing with Mesomb-like flow
            setTimeout(() => {
                // In a real implementation, this would integrate with Mesomb API
                alert(`Thank you for your donation of XAF ${amount.toLocaleString()}!\n\nPlease check your phone (${phone}) for a payment prompt from ${paymentMethod === 'mtn' ? 'MTN' : 'Orange'} Mobile Money.\n\nYour support helps keep HireCameroon running and connecting talent across Cameroon.`);
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
                this.reset();
                selectedAmount = null;

                // Reset button styles
                document.querySelectorAll('.donation-amount').forEach(btn => {
                    btn.classList.remove('border-yellow-400', 'text-yellow-600', 'bg-yellow-50');
                    btn.classList.add('border-gray-200', 'text-black');
                });

                // Reset payment method styles
                document.querySelectorAll('.payment-method').forEach(m => {
                    m.classList.remove('border-yellow-400', 'bg-yellow-50');
                    m.classList.add('border-gray-200', 'bg-gray-50');
                });
            }, 2000);
        });

        // Payment method selection
        document.querySelectorAll('.payment-method').forEach(method => {
            method.addEventListener('click', function() {
                document.querySelectorAll('.payment-method').forEach(m => {
                    m.classList.remove('border-yellow-400', 'bg-yellow-50');
                    m.classList.add('border-gray-200', 'bg-gray-50');
                });
                this.classList.remove('border-gray-200', 'bg-gray-50');
                this.classList.add('border-yellow-400', 'bg-yellow-50');

                const radio = this.querySelector('input[type="radio"]');
                radio.checked = true;
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.marketing', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\www\github\hiringcameroon\resources\views/donate.blade.php ENDPATH**/ ?>