const defaultTheme = require('tailwindcss/defaultTheme');

/** @type {import('tailwindcss').Config} */
module.exports = {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                'brand-navy': '#0f172a',
                'brand-slate': '#334155',
                'brand-green': '#16a34a',
                'brand-emerald': '#059669',
                'brand-cyan': '#0891b2',
                'brand-sky': '#0284c7',
                'brand-purple': '#7c3aed',
                'brand-violet': '#8b5cf6',
                'brand-gold': '#f59e0b',
                'brand-amber': '#d97706',
                'brand-orange': '#ea580c',
                'brand-rose': '#dc2626',
                'brand-pink': '#db2777',
                'brand-indigo': '#4f46e5',
                'brand-blue': '#2563eb',
                'brand-teal': '#0d9488',
                'brand-lime': '#65a30d',
                'brand-yellow': '#ca8a04',
            },
        },
    },

    plugins: [require('@tailwindcss/forms')],
};
